/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.triggers;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang3.SerializationUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.joml.Vector3d;

public class Jumppad
implements Trigger {
    static BoundingBox boundingBox = new BoundingBox(-0.5, 0.0, -0.5, 0.5, 1.0, 0.5);
    private Vector launchVec;
    private Marker marker;
    private boolean triggered;
    private BukkitRunnable particleEmitter;

    public Jumppad(Location loc, Vector launchVec) {
        this.marker = (Marker)loc.getWorld().spawnEntity(loc, EntityType.MARKER);
        this.launchVec = launchVec;
        QEntityUtil.setEntityType((Entity)this.marker, "jumppad");
        byte[] serializedLaunchVec = SerializationUtils.serialize((Serializable)this.launchVec.toVector3d());
        PersistentDataContainer pdc = this.marker.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "launch_vec"), PersistentDataType.BYTE_ARRAY, (Object)serializedLaunchVec);
        this.particleEmitter = this.newParticleEmitter();
        this.particleEmitter.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 15L);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public Jumppad(Marker marker) {
        this.marker = marker;
        PersistentDataContainer pdc = this.marker.getPersistentDataContainer();
        byte[] launchVecData = (byte[])pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "launch_vec"), PersistentDataType.BYTE_ARRAY);
        this.launchVec = Vector.fromJOML((Vector3d)((Vector3d)SerializationUtils.deserialize(launchVecData)));
        this.particleEmitter = this.newParticleEmitter();
        this.particleEmitter.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 15L);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    private BukkitRunnable newParticleEmitter() {
        return new BukkitRunnable(){

            public void run() {
                if (Jumppad.this.marker.isDead()) {
                    this.cancel();
                    return;
                }
                Location center = Jumppad.this.marker.getLocation();
                center.setY(center.getY() + 0.05);
                Color trailColor = Color.fromRGB((int)255, (int)200, (int)0);
                int durationTicks = 15;
                for (int i = 0; i < 32; ++i) {
                    double angle = (double)i * Math.PI / 16.0;
                    double destX = Math.cos(angle) * 0.5;
                    double destZ = Math.sin(angle) * 0.5;
                    Location targetLocation = center.clone().add(destX, 0.0, destZ);
                    Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, durationTicks);
                    center.getWorld().spawnParticle(Particle.TRAIL, center, 0, (Object)trailData);
                }
            }
        };
    }

    @Override
    public void onTrigger(final Entity entity) {
        if (this.triggered || entity.isSneaking()) {
            return;
        }
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (this.ticks == 2) {
                    this.cancel();
                }
                entity.setVelocity(Jumppad.this.launchVec);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 1L);
        this.marker.getWorld().playSound(this.marker.getLocation(), "quake.world.jumppad", 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.setSprinting(false);
        }
        Location iloc = entity.getLocation();
        iloc.setY(iloc.y() + 0.1);
        this.triggered = true;
        Location center = this.marker.getLocation();
        center.setY(center.getY() + 0.05);
        Color trailColor = Color.fromRGB((int)0xFFFFFF);
        Random randomGenerator = new Random();
        for (int i = 0; i < 64; ++i) {
            double angle = (double)i * Math.PI / 32.0;
            int random = randomGenerator.nextInt(6) + 5;
            double destX = Math.cos(angle) * 1.5 * ((double)random / 10.0);
            double destZ = Math.sin(angle) * 1.5 * ((double)random / 10.0);
            Location targetLocation = iloc.clone().add(destX, 0.0, destZ);
            Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, random);
            center.getWorld().spawnParticle(Particle.TRAIL, iloc, 0, (Object)trailData);
        }
        new BukkitRunnable(){

            public void run() {
                Jumppad.this.triggered = false;
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 10L);
    }

    @Override
    public void onUnload() {
        this.particleEmitter.cancel();
    }

    public static void testJump(final Player player, final Vector launchVec, QuakePlugin plugin) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (this.ticks == 2) {
                    this.cancel();
                }
                player.setVelocity(launchVec);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    @Override
    public Location getLocation() {
        return this.marker.getLocation();
    }

    @Override
    public Entity getEntity() {
        return this.marker;
    }

    public Vector getLaunchVec() {
        return this.launchVec;
    }

    @Override
    public BoundingBox getOffsetBoundingBox() {
        return boundingBox;
    }

    @Override
    public void remove() {
        this.onUnload();
        this.marker.remove();
    }
}

