/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.events.listeners.CombatListener;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class WeaponSpawner
extends Spawner {
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;
    public static final String[] NAMES = new String[]{"pickup.weapon.machinegun", "pickup.weapon.shotgun", "pickup.weapon.rocketLauncher", "pickup.weapon.lightningGun", "pickup.weapon.railgun", "pickup.weapon.plasmaGun", "pickup.weapon.bfg"};

    public WeaponSpawner(int weaponIndex, World world, Location location) {
        super(new ItemStack(Material.AIR), world, location);
        ItemStack item = WeaponSpawner.getWeapon(weaponIndex);
        this.display.setItemStack(item);
        QEntityUtil.setEntityType((Entity)this.display, "weapon_spawner");
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public WeaponSpawner(ItemDisplay display) {
        super(display);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public static void convert(ItemDisplay displayToConvert) {
        int modelData = displayToConvert.getItemStack().getItemMeta().getCustomModelData();
        ItemStack item = WeaponSpawner.getWeapon(modelData);
        displayToConvert.setItemStack(item);
        QEntityUtil.setEntityType((Entity)displayToConvert, "weapon_spawner");
        new WeaponSpawner(displayToConvert);
    }

    public static ItemStack getWeapon(int index) {
        ItemStack itemStack = new ItemStack(Material.CARROT_ON_A_STICK);
        ItemMeta weaponMeta = itemStack.getItemMeta();
        String weaponName = NAMES[index];
        weaponMeta.displayName(Component.text((String)weaponName).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.byBoolean((boolean)false)));
        weaponMeta.setCustomModelData(Integer.valueOf(index));
        itemStack.setItemMeta(weaponMeta);
        return itemStack;
    }

    @Override
    public void onPickup(Player player) {
        ItemStack item = this.display.getItemStack();
        if (item.isEmpty()) {
            return;
        }
        ItemMeta weaponMeta = item.getItemMeta();
        int weaponIndex = weaponMeta.getCustomModelData();
        weaponMeta.displayName(TranslationManager.t(NAMES[weaponIndex], player, new TagResolver[0]));
        item.setItemMeta(weaponMeta);
        this.itemForRespawn = item;
        CombatListener.sortGun(item, player);
        this.display.setItemStack(new ItemStack(Material.AIR));
        player.getWorld().playSound((Entity)player, "quake.weapons.pickup", 0.5f, 1.0f);
        Hud.pickupMessage(player, Objects.requireNonNull(weaponMeta.displayName()));
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        int respawnTimeTicks = 100;
        if (userState.currentMatch != null && userState.currentMatch.getTeamOfPlayer(player) != Team.FREE) {
            respawnTimeTicks = 600;
        }
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                WeaponSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, (long)respawnTimeTicks);
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty()) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
        if (this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }
}

