/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.DisplayPickup;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;

public abstract class Spawner
implements DisplayPickup {
    public ItemDisplay display;
    static BoundingBox boundingBox = new BoundingBox(-1.0, -1.0, -1.0, 1.0, 0.0, 1.0);

    public Spawner(ItemStack item, World world, Location location) {
        this.display = (ItemDisplay)world.spawnEntity(location, EntityType.ITEM_DISPLAY);
        this.display.setItemStack(item);
        this.display.setInterpolationDuration(20);
        this.display.setTeleportDuration(20);
        this.display.setRotation(0.0f, 0.0f);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public Spawner(ItemDisplay display) {
        assert (display != null);
        this.display = display;
        this.display.setInterpolationDuration(20);
        this.display.setTeleportDuration(20);
        this.display.setRotation(0.0f, 0.0f);
    }

    @Override
    public abstract void onPickup(Player var1);

    public abstract void respawn();

    @Override
    public Location getLocation() {
        return this.display.getLocation();
    }

    @Override
    public ItemDisplay getDisplay() {
        return this.display;
    }

    @Override
    public BoundingBox getOffsetBoundingBox() {
        return boundingBox;
    }

    @Override
    public Entity getEntity() {
        return this.display;
    }

    @Override
    public void remove() {
        this.display.remove();
    }

    @Override
    public void onTrigger(Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPickup((Player)entity);
    }

    @Override
    public void onUnload() {
    }
}

