/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PowerupSpawner
extends Spawner {
    private static final int RESPAWN_TIME = 1200;
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;
    private PowerupType type;
    private boolean isDrop;
    private int duration;
    private Match belongingMatch;

    public PowerupSpawner(PowerupType type, World world, Location location, boolean isDrop, int duration) {
        super(new ItemStack(Material.TOTEM_OF_UNDYING), world, location);
        ItemStack powerupItem = this.display.getItemStack();
        ItemMeta itemMeta = powerupItem.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(type.ordinal()));
        powerupItem.setItemMeta(itemMeta);
        this.display.setItemStack(powerupItem);
        this.type = type;
        this.isDrop = isDrop;
        this.duration = duration;
        PersistentDataContainer displayData = this.display.getPersistentDataContainer();
        NamespacedKey typeKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "type");
        displayData.set(typeKey, PersistentDataType.STRING, (Object)this.type.toString());
        if (!isDrop) {
            QEntityUtil.setEntityType((Entity)this.display, "powerup_spawner");
        }
    }

    public PowerupSpawner(ItemDisplay display) {
        super(display);
        PersistentDataContainer displayData = display.getPersistentDataContainer();
        NamespacedKey typeKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "type");
        this.type = PowerupType.valueOf((String)displayData.get(typeKey, PersistentDataType.STRING));
        this.isDrop = false;
        this.duration = 30;
        ItemStack powerupItem = this.display.getItemStack();
        ItemMeta itemMeta = powerupItem.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(this.type.ordinal()));
        powerupItem.setItemMeta(itemMeta);
        this.display.setItemStack(powerupItem);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public static void doPowerup(Player player, PowerupType type, int time) {
        boolean found = false;
        QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
        for (Powerup powerup : state.activePowerups) {
            if (powerup.getType() != type) continue;
            powerup.extendDuration(time);
            found = true;
            break;
        }
        if (!found) {
            Powerup powerup2 = new Powerup(player, type, time);
            state.activePowerups.add(powerup2);
        }
    }

    @Override
    public void onPickup(Player player) {
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        ItemStack item = this.display.getItemStack();
        if (item.isEmpty()) {
            return;
        }
        this.itemForRespawn = item;
        PowerupSpawner.doPowerup(player, this.type, this.duration);
        this.despawn(userState.currentMatch);
        if (this.belongingMatch != null) {
            for (Player mPlayer : this.belongingMatch.getPlayers()) {
                mPlayer.playSound(Sound.sound((Key)Key.key((String)Powerup.SOUNDS.get((Object)this.type)), (Sound.Source)Sound.Source.NEUTRAL, (float)0.5f, (float)1.0f), (Sound.Emitter)mPlayer);
            }
        } else {
            player.getWorld().playSound((Entity)player, Powerup.SOUNDS.get((Object)this.type), 0.5f, 1.0f);
        }
        Hud.pickupMessage(player, TranslationManager.t(Powerup.NAMES.get((Object)this.type), player, new TagResolver[0]));
        if (!this.isDrop) {
            this.respawnTask = new BukkitRunnable(){

                public void run() {
                    PowerupSpawner.this.respawn();
                }
            }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 1200L);
        } else {
            this.display.remove();
        }
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty() || this.isDrop) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        if (this.belongingMatch != null) {
            for (Player mPlayer : this.belongingMatch.getPlayers()) {
                mPlayer.playSound(Sound.sound((Key)Key.key((String)"quake.items.powerups.respawn"), (Sound.Source)Sound.Source.NEUTRAL, (float)0.5f, (float)1.0f), (Sound.Emitter)mPlayer);
            }
        } else {
            this.display.getWorld().playSound((Entity)this.display, "quake.items.powerups.respawn", 0.5f, 1.0f);
        }
        if (!this.isDrop && this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }

    public void despawn(Match match) {
        ItemStack item = this.display.getItemStack();
        if (item.isEmpty()) {
            return;
        }
        this.itemForRespawn = item;
        this.belongingMatch = match;
        this.display.setItemStack(new ItemStack(Material.AIR));
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                PowerupSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 1200L);
    }

    public void matchCleanup() {
        this.belongingMatch = null;
        if (this.isDrop) {
            QuakePlugin.INSTANCE.triggers.remove(this);
            this.remove();
        } else {
            this.respawn();
        }
    }
}

