/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.events.listeners.CombatListener;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.Team;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

@Deprecated
public class ItemSpawner
extends Spawner {
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;

    public ItemSpawner(ItemStack item, World world, Location location) {
        super(item, world, location);
        QEntityUtil.setEntityType((Entity)this.display, "item_spawner");
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public ItemSpawner(ItemDisplay display) {
        super(display);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    @Override
    public void onPickup(Player player) {
        ItemStack item = this.display.getItemStack();
        if (item.isEmpty()) {
            return;
        }
        this.itemForRespawn = item;
        PlayerInventory inv = player.getInventory();
        if (item.getItemMeta().hasCustomModelData() && item.getType() == Material.CARROT_ON_A_STICK) {
            CombatListener.sortGun(item, player);
        } else {
            inv.addItem(new ItemStack[]{item});
        }
        this.display.setItemStack(new ItemStack(Material.AIR));
        player.getWorld().playSound((Entity)player, "quake.weapons.pickup", 0.5f, 1.0f);
        Hud.pickupMessage(player, Objects.requireNonNull(item.getItemMeta().displayName()));
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        int respawnTimeTicks = 100;
        if (userState.currentMatch != null && userState.currentMatch.getTeamOfPlayer(player) != Team.FREE) {
            respawnTimeTicks = 600;
        }
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                ItemSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, (long)respawnTimeTicks);
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty()) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
        if (this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }
}

