/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HealthSpawner
extends Spawner {
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;
    private int health;

    public HealthSpawner(int health, World world, Location location) {
        super(new ItemStack(Material.PORKCHOP), world, location);
        ItemStack item = null;
        switch (health) {
            case 1: {
                item = new ItemStack(Material.CARROT);
                break;
            }
            case 5: {
                item = new ItemStack(Material.BAKED_POTATO);
                break;
            }
            case 10: {
                item = new ItemStack(Material.COOKED_BEEF);
                break;
            }
            case 20: {
                item = new ItemStack(Material.GOLDEN_APPLE);
            }
        }
        this.health = health;
        PersistentDataContainer displayData = this.display.getPersistentDataContainer();
        NamespacedKey healthKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "health");
        displayData.set(healthKey, PersistentDataType.INTEGER, (Object)this.health);
        this.display.setItemStack(item);
        QEntityUtil.setEntityType((Entity)this.display, "health_spawner");
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public HealthSpawner(ItemDisplay display) {
        super(display);
        PersistentDataContainer displayData = display.getPersistentDataContainer();
        NamespacedKey healthKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "health");
        this.health = (Integer)displayData.get(healthKey, PersistentDataType.INTEGER);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    @Override
    public void onPickup(Player player) {
        boolean isMegaOrSmall;
        boolean bl = isMegaOrSmall = this.health == 20 || this.health == 1;
        if (this.display.getItemStack().isEmpty() || isMegaOrSmall && player.getHealth() == 40.0 || !isMegaOrSmall && player.getHealth() >= 20.0) {
            return;
        }
        this.itemForRespawn = this.display.getItemStack();
        double totalHealth = player.getHealth() + (double)this.health;
        if (isMegaOrSmall) {
            if (totalHealth > 40.0) {
                totalHealth = 40.0;
            }
            if (totalHealth > 20.0) {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(totalHealth);
            }
        } else if (totalHealth > 20.0) {
            totalHealth = 20.0;
        }
        player.setHealth(totalHealth);
        player.sendHealthUpdate();
        EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, (double)this.health, EntityRegainHealthEvent.RegainReason.CUSTOM);
        event.callEvent();
        this.display.setItemStack(new ItemStack(Material.AIR));
        player.getWorld().playSound((Entity)player, "quake.items.health.pickup_" + this.health, 0.5f, 1.0f);
        if (this.health == 20) {
            Hud.pickupMessage(player, TranslationManager.t("pickup.health.mega", player, new TagResolver[0]));
        } else {
            Hud.pickupMessage(player, TranslationManager.t("pickup.health.generic", player, new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(this.health * 5))}));
        }
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                HealthSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 700L);
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty()) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
        if (this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }
}

