/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.entities.DisplayPickup;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.matches.CTFMatch;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class CTFFlag
implements DisplayPickup {
    private ItemDisplay display;
    private Team team;
    private CTFMatch match;
    private boolean isDrop;
    static BoundingBox boundingBox = new BoundingBox(-1.0, -1.0, -1.0, 1.0, 0.0, 1.0);

    public CTFFlag(Team team, boolean isDrop, CTFMatch match, Location location) {
        ItemStack item = this.displayItem(team);
        this.display = (ItemDisplay)location.getWorld().spawnEntity(location, EntityType.ITEM_DISPLAY);
        this.display.setItemStack(item);
        this.team = team;
        this.isDrop = isDrop;
        this.match = match;
        PersistentDataContainer displayData = this.display.getPersistentDataContainer();
        NamespacedKey teamKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "team");
        displayData.set(teamKey, PersistentDataType.STRING, (Object)team.name());
        NamespacedKey isDropKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "is_drop");
        displayData.set(isDropKey, PersistentDataType.BOOLEAN, (Object)isDrop);
        QEntityUtil.setEntityType((Entity)this.display, "ctf_flag");
        this.display.setInterpolationDuration(20);
        this.display.setTeleportDuration(20);
        this.display.setRotation(0.0f, 0.0f);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public CTFFlag(ItemDisplay display) {
        assert (display != null);
        PersistentDataContainer displayData = display.getPersistentDataContainer();
        NamespacedKey teamKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "team");
        String teamString = (String)displayData.get(teamKey, PersistentDataType.STRING);
        NamespacedKey isDropKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "is_drop");
        boolean isDrop = Boolean.TRUE.equals(displayData.get(isDropKey, PersistentDataType.BOOLEAN));
        this.display = display;
        this.team = Team.valueOf(teamString);
        this.isDrop = isDrop;
        this.display.setInterpolationDuration(20);
        this.display.setTeleportDuration(20);
        this.display.setRotation(0.0f, 0.0f);
        for (QMap map : QuakePlugin.INSTANCE.maps) {
            CTFMatch match;
            Match match2;
            if (display.getWorld() != map.world || !map.bounds.contains(display.getLocation().toVector()) || !((match2 = map.getMatch()) instanceof CTFMatch)) continue;
            this.match = match = (CTFMatch)match2;
        }
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    private ItemStack displayItem(Team team) {
        ItemStack item = switch (team) {
            case Team.RED -> new ItemStack(Material.RED_BANNER);
            case Team.BLUE -> new ItemStack(Material.BLUE_BANNER);
            default -> throw new IllegalArgumentException("Only RED or BLUE team allowed for CTFFlag!");
        };
        return item;
    }

    public void prepareForMatch(CTFMatch match) {
        this.match = match;
        this.respawn();
    }

    public void cleanup() {
        this.respawn();
        this.match = null;
    }

    public void respawn() {
        if (!this.display.getItemStack().isEmpty() || this.isDrop) {
            return;
        }
        this.display.setItemStack(this.displayItem(this.team));
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
    }

    @Override
    public ItemDisplay getDisplay() {
        return this.display;
    }

    public boolean isDrop() {
        return this.isDrop;
    }

    @Override
    public void onPickup(Player player) {
        if (this.match == null) {
            return;
        }
        ItemStack item = this.display.getItemStack();
        if (item.isEmpty()) {
            return;
        }
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (!(userState.currentMatch instanceof CTFMatch)) {
            return;
        }
        if (this.isDrop && this.match.getPlayersInTeam(this.team).contains(player)) {
            this.match.returnFlag(this.team, player);
            this.remove();
            return;
        }
        if (!this.isDrop) {
            if (this.match.getCarryingFlagTeam(player) == this.team.oppositeTeam()) {
                this.match.captureFlag(this.team, player);
                return;
            }
            if (this.match.getPlayersInTeam(this.team).contains(player)) {
                return;
            }
        }
        if (!this.isDrop) {
            this.display.setItemStack(null);
        } else {
            this.remove();
            QuakePlugin.INSTANCE.triggers.remove(this);
        }
        this.match.grabFlag(this.team, player);
        Hud.pickupMessage(player, TranslationManager.t("pickup.ctfFlag.title", player, new TagResolver[]{Placeholder.parsed((String)"team_color", (String)TranslationManager.tLegacy("pickup.ctfFlag." + this.team.name().toLowerCase() + "Adj", player))}));
    }

    public Team getTeam() {
        return this.team;
    }

    @Override
    public void onTrigger(Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPickup((Player)entity);
    }

    @Override
    public void onUnload() {
    }

    @Override
    public Location getLocation() {
        return this.display.getLocation();
    }

    @Override
    public Entity getEntity() {
        return this.display;
    }

    @Override
    public BoundingBox getOffsetBoundingBox() {
        return boundingBox;
    }

    @Override
    public void remove() {
        this.display.remove();
    }
}

