/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ArmorSpawner
extends Spawner {
    public static final Map<Integer, String> NAMES = new HashMap<Integer, String>();
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;
    private int armor;

    public ArmorSpawner(int armor, World world, Location location) {
        super(new ItemStack(Material.PORKCHOP), world, location);
        ItemStack item = null;
        switch (armor) {
            case 5: {
                item = new ItemStack(Material.IRON_INGOT);
                break;
            }
            case 50: {
                item = new ItemStack(Material.GOLDEN_CHESTPLATE);
                break;
            }
            case 100: {
                item = new ItemStack(Material.NETHERITE_CHESTPLATE);
            }
        }
        this.armor = armor;
        PersistentDataContainer displayData = this.display.getPersistentDataContainer();
        NamespacedKey armorKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "armor");
        displayData.set(armorKey, PersistentDataType.INTEGER, (Object)this.armor);
        this.display.setItemStack(item);
        QEntityUtil.setEntityType((Entity)this.display, "armor_spawner");
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public ArmorSpawner(ItemDisplay display) {
        super(display);
        PersistentDataContainer displayData = display.getPersistentDataContainer();
        NamespacedKey armorKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "armor");
        this.armor = (Integer)displayData.get(armorKey, PersistentDataType.INTEGER);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    @Override
    public void onPickup(Player player) {
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (this.display.getItemStack().isEmpty() || userState.armor >= 200) {
            return;
        }
        this.itemForRespawn = this.display.getItemStack();
        userState.armor += this.armor;
        if (userState.armor > 200) {
            userState.armor = 200;
        }
        if (userState.armor > 100) {
            userState.startArmorDecreaser();
        }
        this.display.setItemStack(new ItemStack(Material.AIR));
        if (this.armor == 5) {
            player.getWorld().playSound((Entity)player, "quake.items.armor_shard.pickup", 0.5f, 1.0f);
        } else {
            player.getWorld().playSound((Entity)player, "quake.items.armor.pickup", 0.5f, 1.0f);
        }
        Hud.pickupMessage(player, TranslationManager.t(NAMES.get(this.armor), player, new TagResolver[0]));
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                ArmorSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 500L);
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty()) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
        if (this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }

    static {
        NAMES.put(5, "pickup.armor.shard");
        NAMES.put(50, "pickup.armor.light");
        NAMES.put(100, "pickup.armor.heavy");
    }
}

