/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.pickups;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.combat.WeaponUserState;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AmmoSpawner
extends Spawner {
    public static final int[] AMOUNTS = new int[]{50, 10, 5, 60, 10, 30, 1};
    public static final String[] NAMES = new String[]{"pickup.ammo.bullets", "pickup.ammo.shells", "pickup.ammo.rockets", "pickup.ammo.battery", "pickup.ammo.slugs", "pickup.ammo.cells", "pickup.ammo.bfg"};
    public static final String[] ALIASES = new String[]{"bullets", "shells", "rockets", "battery", "slugs", "cells", "bfg"};
    private ItemStack itemForRespawn;
    private BukkitTask respawnTask;
    private int ammoType;

    public AmmoSpawner(int ammoType, World world, Location location) {
        super(new ItemStack(Material.GUNPOWDER), world, location);
        ItemStack displayItem = new ItemStack(Material.GUNPOWDER);
        ItemMeta displayItemMeta = displayItem.getItemMeta();
        displayItemMeta.setCustomModelData(Integer.valueOf(ammoType));
        displayItem.setItemMeta(displayItemMeta);
        this.ammoType = ammoType;
        PersistentDataContainer displayData = this.display.getPersistentDataContainer();
        NamespacedKey ammoTypeKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "ammoType");
        displayData.set(ammoTypeKey, PersistentDataType.INTEGER, (Object)this.ammoType);
        this.display.setItemStack(displayItem);
        QEntityUtil.setEntityType((Entity)this.display, "ammo_spawner");
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public AmmoSpawner(ItemDisplay display) {
        super(display);
        PersistentDataContainer displayData = display.getPersistentDataContainer();
        NamespacedKey ammoTypeKey = new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "ammoType");
        this.ammoType = (Integer)displayData.get(ammoTypeKey, PersistentDataType.INTEGER);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    @Override
    public void onPickup(Player player) {
        WeaponUserState weaponState = QuakePlugin.INSTANCE.userStates.get((Object)player).weaponState;
        if (this.display.getItemStack().isEmpty() || weaponState.ammo[this.ammoType] >= 200) {
            return;
        }
        this.itemForRespawn = this.display.getItemStack();
        int n = this.ammoType;
        weaponState.ammo[n] = weaponState.ammo[n] + AMOUNTS[this.ammoType];
        if (weaponState.ammo[this.ammoType] > 200) {
            weaponState.ammo[this.ammoType] = 200;
        }
        this.display.setItemStack(new ItemStack(Material.AIR));
        player.getWorld().playSound((Entity)player, "quake.items.ammo.pickup", 0.5f, 1.0f);
        Hud.pickupMessage(player, TranslationManager.t(NAMES[this.ammoType], player, new TagResolver[0]));
        this.respawnTask = new BukkitRunnable(){

            public void run() {
                AmmoSpawner.this.respawn();
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 800L);
    }

    @Override
    public void respawn() {
        if (!this.display.getItemStack().isEmpty()) {
            return;
        }
        this.display.setItemStack(this.itemForRespawn);
        this.display.getWorld().spawnParticle(Particle.INSTANT_EFFECT, this.display.getLocation(), 16, 0.5, 0.5, 0.5);
        this.display.getWorld().playSound((Entity)this.display, "quake.items.respawn", 0.5f, 1.0f);
        if (this.respawnTask != null) {
            this.respawnTask.cancel();
        }
    }
}

