/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities;

import com.github.polyzium.quakechasm.QuakePlugin;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class QEntityUtil {
    public static String getEntityType(Entity entity) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        String oldType = (String)pdc.get(new NamespacedKey("darkchronics-quake", "entity_type"), PersistentDataType.STRING);
        if (oldType != null) {
            Set keys = pdc.getKeys();
            QuakePlugin.INSTANCE.getLogger().warning(String.format("Migrating DarkChronics-Quake entity %s to Quakechasm entity", oldType));
            String oldNamespace = "darkchronics-quake";
            String newNamespace = "quakechasm";
            for (NamespacedKey key : keys) {
                if (!key.getNamespace().equalsIgnoreCase(oldNamespace)) continue;
                NamespacedKey newKey = new NamespacedKey(newNamespace, key.getKey());
                try {
                    String stringValue = (String)pdc.get(key, PersistentDataType.STRING);
                    if (stringValue != null) {
                        pdc.set(newKey, PersistentDataType.STRING, (Object)stringValue);
                        pdc.remove(key);
                        continue;
                    }
                }
                catch (IllegalArgumentException stringValue) {
                    // empty catch block
                }
                try {
                    Integer intValue = (Integer)pdc.get(key, PersistentDataType.INTEGER);
                    if (intValue != null) {
                        pdc.set(newKey, PersistentDataType.INTEGER, (Object)intValue);
                        pdc.remove(key);
                        continue;
                    }
                }
                catch (IllegalArgumentException intValue) {
                    // empty catch block
                }
                try {
                    byte[] byteArrayValue = (byte[])pdc.get(key, PersistentDataType.BYTE_ARRAY);
                    if (byteArrayValue != null) {
                        pdc.set(newKey, PersistentDataType.BYTE_ARRAY, (Object)byteArrayValue);
                        pdc.remove(key);
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                QuakePlugin.INSTANCE.getLogger().warning(String.format("Could not migrate key %s - unknown data type", key));
            }
        }
        return (String)pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "entity_type"), PersistentDataType.STRING);
    }

    public static void setEntityType(Entity entity, String type) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "entity_type"), PersistentDataType.STRING, (Object)type);
    }

    public static Entity nearestEntity(Location loc, double radius, Predicate<Entity> predicate) {
        Entity nearestEntity = null;
        for (Entity nearbyEntity : loc.getNearbyEntities(radius, radius, radius)) {
            if (!predicate.test(nearbyEntity) || nearestEntity != null && !(nearbyEntity.getLocation().distance(loc) < nearestEntity.getLocation().distance(loc))) continue;
            nearestEntity = nearbyEntity;
        }
        return nearestEntity;
    }
}

