/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.combat.powerup;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.game.entities.pickups.PowerupSpawner;
import java.util.EnumMap;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Powerup {
    public static EnumMap<PowerupType, String> NAMES = new EnumMap(PowerupType.class);
    public static EnumMap<PowerupType, String> SOUNDS;
    private int time;
    private PowerupType type;
    public BukkitTask timer;

    public Powerup(final Player player, final PowerupType type, int time) {
        this.type = type;
        this.time = time;
        final QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
        final Powerup self = this;
        this.timer = new BukkitRunnable(this){

            public void run() {
                --self.time;
                if (self.time < 0) {
                    state.activePowerups.remove(self);
                    if (type == PowerupType.REGENERATION) {
                        state.startHealthDecreaser();
                    }
                    state.hud.powerupBoard.update();
                    this.cancel();
                    return;
                }
                if (self.time < 5 && self.time >= 0) {
                    player.playSound((Entity)player, "quake.items.powerups.wearoff", SoundCategory.NEUTRAL, 0.5f, 1.0f);
                }
                if (type == PowerupType.REGENERATION && player.getHealth() < 40.0) {
                    float newHealth = (float)Math.round(player.getHealth() * 5.0) / 5.0f;
                    double maxHealth = 0.0;
                    if (newHealth < 20.0f) {
                        maxHealth = (newHealth += 3.0f) > 20.0f ? (double)newHealth : 20.0;
                    } else if (newHealth < 40.0f) {
                        maxHealth = newHealth += 1.0f;
                    }
                    if (newHealth > 40.0f) {
                        newHealth = 40.0f;
                        maxHealth = 40.0;
                    }
                    player.getWorld().playSound((Entity)player, "quake.items.powerups.regeneration.heal", 0.5f, 1.0f);
                    player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(maxHealth);
                    player.setHealth((double)newHealth);
                }
                state.hud.powerupBoard.update();
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 20L);
    }

    public PowerupType getType() {
        return this.type;
    }

    public int getTime() {
        return this.time;
    }

    public void extendDuration(int time) {
        this.time += time;
    }

    public static boolean hasPowerup(Player player, PowerupType type) {
        QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
        for (Powerup powerup : state.activePowerups) {
            if (powerup.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void dropPowerups(Player player) {
        QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
        for (int i = 0; i < state.activePowerups.size(); ++i) {
            Powerup powerup = state.activePowerups.get(i);
            Location playerLocation = player.getLocation().clone();
            playerLocation.setY(playerLocation.getY() + 1.0);
            if (playerLocation.y() > -64.0) {
                new PowerupSpawner(powerup.type, player.getWorld(), playerLocation, true, powerup.time);
            }
            powerup.timer.cancel();
            state.hud.powerupBoard.update();
            state.activePowerups.remove(powerup);
        }
    }

    static {
        NAMES.put(PowerupType.QUAD_DAMAGE, "pickup.powerup.quad");
        NAMES.put(PowerupType.REGENERATION, "pickup.powerup.regeneration");
        NAMES.put(PowerupType.PROTECTION, "pickup.powerup.protection");
        SOUNDS = new EnumMap(PowerupType.class);
        SOUNDS.put(PowerupType.QUAD_DAMAGE, "quake.items.powerups.quad_damage.pickup");
        SOUNDS.put(PowerupType.REGENERATION, "quake.items.powerups.regeneration.pickup");
        SOUNDS.put(PowerupType.PROTECTION, "quake.items.powerups.protection.pickup");
    }
}

