/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.combat;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.combat.DamageData;
import com.github.polyzium.quakechasm.game.combat.ProjectileUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.matchmaking.Team;
import java.util.HashSet;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public abstract class WeaponUtil {
    public static final int[] PERIODS = new int[]{2, 20, 16, 1, 30, 2, 50};
    public static final int[] DEFAULT_AMMO = new int[]{100, 10, 10, 100, 10, 50, 1};
    public static int WEAPONS_NUM = 7;

    public static int getHoldingWeaponIndex(Player player) {
        if (player.getInventory().getItemInMainHand().getItemMeta() == null) {
            return -1;
        }
        if (!player.getInventory().getItemInMainHand().getItemMeta().hasCustomModelData()) {
            return -1;
        }
        return player.getInventory().getItemInMainHand().getItemMeta().getCustomModelData();
    }

    private static void applySpread(Vector vector, double spread) {
        double horizontalAngle = Math.toRadians(Math.random() * spread - spread / 2.0);
        double verticalAngle = Math.toRadians(Math.random() * spread - spread / 2.0);
        double zAngle = Math.toRadians(Math.random() * spread - spread / 2.0);
        vector.rotateAroundY(horizontalAngle);
        vector.rotateAroundX(verticalAngle);
        vector.rotateAroundZ(zAngle);
        vector.normalize();
    }

    public static RayTraceResult cast(Player player, double spread, double limit) {
        Location loc = player.getEyeLocation();
        Vector look = loc.getDirection();
        WeaponUtil.applySpread(look, spread);
        return player.getWorld().rayTrace(loc, look, limit, FluidCollisionMode.NEVER, true, 0.35, e -> e != player && e instanceof LivingEntity);
    }

    public static void spawnParticlesLine(Location startLocation, Location endLocation, double density, Consumer<Location> particleFunction) {
        World world = startLocation.getWorld();
        double distance = startLocation.distance(endLocation);
        int particleCount = (int)(distance * density);
        for (int i = 0; i < particleCount; ++i) {
            double ratio = (double)i / (double)particleCount;
            double x = startLocation.getX() + ratio * (endLocation.getX() - startLocation.getX());
            double y = startLocation.getY() + ratio * (endLocation.getY() - startLocation.getY());
            double z = startLocation.getZ() + ratio * (endLocation.getZ() - startLocation.getZ());
            Location particleLocation = new Location(world, x, y, z);
            particleFunction.accept(particleLocation);
        }
    }

    public static void railTrail(Location startLocation, Location endLocation) {
        World world = startLocation.getWorld();
        double density = 8.0;
        Color trailColor = Color.fromRGB((int)65280);
        int durationTicks = 10;
        double distance = startLocation.distance(endLocation);
        int particleCount = (int)(distance * density);
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        Vector perpendicular1 = new Vector(-direction.getZ(), 0.0, direction.getX()).normalize();
        Vector perpendicular2 = direction.clone().crossProduct(perpendicular1).normalize();
        for (int i = 0; i < particleCount; ++i) {
            double ratio = (double)i / (double)particleCount;
            double x = startLocation.getX() + ratio * (endLocation.getX() - startLocation.getX());
            double y = startLocation.getY() + ratio * (endLocation.getY() - startLocation.getY());
            double z = startLocation.getZ() + ratio * (endLocation.getZ() - startLocation.getZ());
            Location particleLocation = new Location(world, x, y, z);
            double angle = (double)i * Math.PI / 4.0 / (density / 4.0);
            double radius = 0.15;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = Math.sin(angle) * radius;
            Vector offset = perpendicular1.clone().multiply(offsetX).add(perpendicular2.clone().multiply(offsetY));
            Location targetLocation = particleLocation.clone().add(offset);
            Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, durationTicks);
            world.spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)trailData, true);
        }
    }

    public static void bulletImpact(Location loc, Block hitBlock) {
        loc.getWorld().spawnParticle(Particle.BLOCK, loc, 8, (Object)hitBlock.getBlockData());
        loc.getWorld().spawnParticle(Particle.CRIT, loc, 4, 0.0, 0.0, 0.0, 0.25);
        loc.getWorld().playSound(loc, "quake.weapons.impact", 0.5f, 1.0f);
    }

    public static void lightningImpact(Location loc, Block hitBlock) {
        loc.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, loc, 8, 0.0, 0.0, 0.0, 1.0);
        loc.getWorld().playSound(loc, "quake.weapons.impact_lightning", 0.5f, 1.0f);
    }

    public static void railImpact(Location loc, Block hitBlock, Vector hitNormal) {
        loc.getWorld().playSound(loc, "quake.weapons.impact_energy", 0.5f, 1.0f);
        Location center = loc.clone();
        Vector normal = hitNormal.clone().normalize();
        center.add(normal.clone().multiply(0.05));
        Color trailColor = Color.fromRGB((int)65280);
        Random random = new Random();
        Vector tangent = Math.abs(normal.getX()) > 0.1 || Math.abs(normal.getZ()) > 0.1 ? new Vector(0, 1, 0).crossProduct(normal).normalize() : new Vector(1, 0, 0).crossProduct(normal).normalize();
        Vector bitangent = normal.crossProduct(tangent).normalize();
        for (int i = 0; i < 32; ++i) {
            double tangentOffset = (random.nextDouble() - 0.5) * 2.0;
            double bitangentOffset = (random.nextDouble() - 0.5) * 2.0;
            Vector offset = tangent.clone().multiply(tangentOffset).add(bitangent.clone().multiply(bitangentOffset));
            int durationTicks = random.nextInt(8) + 5;
            Location targetLocation = center.clone().add(offset);
            Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, durationTicks);
            center.getWorld().spawnParticle(Particle.TRAIL, center, 0, (Object)trailData);
        }
    }

    public static RayTraceResult fireHitscan(Player player, double damage, double spread, double limit, DamageCause cause, boolean pierce, BiConsumer<Location, Block> impact) {
        RayTraceResult initialRay = WeaponUtil.cast(player, spread, limit);
        if (initialRay == null) {
            if (cause == DamageCause.RAILGUN) {
                QuakePlugin.INSTANCE.userStates.get((Object)player).consecutiveRailgunHits = 0;
            }
            return WeaponUtil.createMissResult(player, limit);
        }
        RayTraceResult finalRay = WeaponUtil.processHitscanHit(initialRay, player, damage, cause, pierce, limit);
        WeaponUtil.applyBlockImpact(finalRay, player.getWorld(), impact);
        return finalRay;
    }

    private static RayTraceResult createMissResult(Player player, double limit) {
        Location eyeLocation = player.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        Vector missPosition = eyeLocation.toVector().add(direction.multiply(limit));
        return new RayTraceResult(missPosition);
    }

    private static RayTraceResult processHitscanHit(RayTraceResult initialRay, Player player, double damage, DamageCause cause, boolean pierce, double limit) {
        RayTraceResult currentRay = initialRay;
        Entity previousHitEntity = null;
        if (currentRay.getHitEntity() != null) {
            WeaponUtil.hitscanDamageEntity(currentRay.getHitEntity(), damage, player, cause);
            previousHitEntity = currentRay.getHitEntity();
        } else if (cause == DamageCause.RAILGUN) {
            QuakePlugin.INSTANCE.userStates.get((Object)player).consecutiveRailgunHits = 0;
        }
        if (pierce) {
            currentRay = WeaponUtil.processPiercingShot(currentRay, player, damage, cause, limit, previousHitEntity);
        }
        return currentRay;
    }

    private static RayTraceResult processPiercingShot(RayTraceResult initialRay, Player player, double damage, DamageCause cause, double limit, Entity previousHitEntity) {
        Vector currentHitPos;
        double distanceTraveled;
        double remainingLimit;
        RayTraceResult currentRay = initialRay;
        Location eyeLocation = player.getEyeLocation();
        Vector originPos = eyeLocation.toVector();
        HashSet<Entity> hitEntities = new HashSet<Entity>();
        if (previousHitEntity != null) {
            hitEntities.add(previousHitEntity);
        }
        while (currentRay != null && currentRay.getHitEntity() != null && !((remainingLimit = limit - (distanceTraveled = (currentHitPos = currentRay.getHitPosition()).distance(originPos))) <= 0.0)) {
            Vector direction = currentHitPos.clone().subtract(originPos).normalize();
            RayTraceResult nextRay = player.getWorld().rayTrace(currentHitPos.toLocation(player.getWorld()), direction, remainingLimit, FluidCollisionMode.NEVER, true, 0.35, e -> !hitEntities.contains(e) && e instanceof LivingEntity);
            if (nextRay == null) {
                Vector missPosition = originPos.clone().add(direction.multiply(limit));
                return new RayTraceResult(missPosition);
            }
            if (nextRay.getHitBlock() != null) {
                currentRay = nextRay;
                break;
            }
            if (nextRay.getHitEntity() != null) {
                WeaponUtil.hitscanDamageEntity(nextRay.getHitEntity(), damage, player, cause);
                hitEntities.add(nextRay.getHitEntity());
            }
            currentRay = nextRay;
        }
        return currentRay;
    }

    private static void hitscanDamageEntity(Entity entity, double damage, Player attacker, DamageCause cause) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            WeaponUtil.damageCustom(livingEntity, damage, (Entity)attacker, cause);
        } else if (entity instanceof EnderCrystal) {
            EnderCrystal crystal = (EnderCrystal)entity;
            Location crystalLocation = crystal.getLocation();
            crystal.remove();
            crystalLocation.getWorld().createExplosion(crystalLocation, 4.0f, false, false);
        }
    }

    private static void applyBlockImpact(RayTraceResult ray, World world, BiConsumer<Location, Block> impact) {
        if (ray == null || impact == null) {
            return;
        }
        Block hitBlock = ray.getHitBlock();
        if (hitBlock != null && !hitBlock.isEmpty()) {
            Vector hitPos = ray.getHitPosition();
            Location hitLocation = new Location(world, hitPos.getX(), hitPos.getY(), hitPos.getZ());
            impact.accept(hitLocation, hitBlock);
        }
    }

    private static void applyBlockImpactWithNormal(RayTraceResult ray, World world, TriConsumer<Location, Block, Vector> impact) {
        if (ray == null || impact == null) {
            return;
        }
        Block hitBlock = ray.getHitBlock();
        if (hitBlock != null && !hitBlock.isEmpty()) {
            Vector hitPos = ray.getHitPosition();
            Vector hitNormal = ray.getHitBlockFace() != null ? ray.getHitBlockFace().getDirection() : new Vector(0, 1, 0);
            Location hitLocation = new Location(world, hitPos.getX(), hitPos.getY(), hitPos.getZ());
            impact.accept(hitLocation, hitBlock, hitNormal);
        }
    }

    public static void damageCustom(LivingEntity victim, double amount, Entity attacker, DamageCause cause) {
        Player player;
        if (cause == null) {
            cause = DamageCause.UNKNOWN;
        }
        if (cause == DamageCause.RAILGUN && attacker instanceof Player) {
            Player attackerPlayer = (Player)attacker;
            QuakeUserState attackerState = QuakePlugin.INSTANCE.userStates.get(attackerPlayer);
            ++attackerState.consecutiveRailgunHits;
            attackerState.checkImpressiveMedal();
        }
        victim.setNoDamageTicks(0);
        if (victim instanceof Player && (player = (Player)victim).getGameMode() != GameMode.CREATIVE) {
            QuakePlugin.INSTANCE.userStates.get((Object)player).lastDamage = new DamageData(attacker, amount, cause);
        }
        victim.damage(amount, DamageSource.builder((DamageType)DamageType.GENERIC).withDirectEntity(attacker).withCausingEntity(attacker).build());
    }

    public static void knockback(Location from, Entity victim, double power) {
        victim.setVelocity(victim.getVelocity().add(from.getDirection().multiply(power)));
    }

    public static boolean hasLineOfSight(Entity viewer, Entity target) {
        double maxDistance;
        Vector direction;
        Location viewerLocation = viewer.getLocation();
        Location targetLocation = target.getLocation();
        World world = viewer.getWorld();
        RayTraceResult rayTraceResult = world.rayTrace(viewerLocation, direction = targetLocation.toVector().subtract(viewerLocation.toVector()).normalize(), maxDistance = viewerLocation.distance(targetLocation) + 1.0, FluidCollisionMode.NEVER, true, 0.0, null);
        return rayTraceResult != null && rayTraceResult.getHitEntity() == target;
    }

    public static void fireMachinegun(Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.machinegun.fire", 0.5f, 1.0f);
        WeaponUtil.fireHitscan(player, 1.4, 2.0, 256.0, DamageCause.MACHINEGUN, false, WeaponUtil::bulletImpact);
    }

    public static void fireShotgun(Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.shotgun.fire", 0.5f, 1.0f);
        for (int i = 0; i < 11; ++i) {
            WeaponUtil.fireHitscan(player, 2.0, 8.0, 256.0, DamageCause.SHOTGUN, false, WeaponUtil::bulletImpact);
        }
    }

    public static void fireRocket(Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.rocket_launcher.fire", 0.5f, 1.0f);
        Location playerLocation = player.getEyeLocation();
        RayTraceResult raycast = WeaponUtil.cast(player, 0.0, player.isSprinting() ? 6.0 : 2.0);
        if (raycast != null) {
            Location hitLoc = raycast.getHitPosition().toLocation(player.getWorld());
            ProjectileUtil.explodeRocket(hitLoc, (Entity)player, null);
            return;
        }
        final Snowball projectile = (Snowball)player.launchProjectile(Snowball.class);
        ProjectileUtil.setProjectileType((Projectile)projectile, "rocket");
        projectile.setItem(new ItemStack(Material.MAGMA_CREAM));
        projectile.setGravity(false);
        final Vector vel = player.getEyeLocation().getDirection().multiply(1);
        projectile.setVelocity(vel);
        BukkitRunnable particleEmitterRunnable = new BukkitRunnable(){
            private int ticks;

            public void run() {
                if (projectile.isDead()) {
                    this.cancel();
                    return;
                }
                if (this.ticks > 200) {
                    projectile.remove();
                    this.cancel();
                    return;
                }
                projectile.setVelocity(vel);
                Location ploc = projectile.getLocation();
                ploc.getWorld().spawnParticle(Particle.LARGE_SMOKE, ploc, 1, 0.0, 0.0, 0.0, 0.02);
                ++this.ticks;
            }
        };
        particleEmitterRunnable.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 1L, 1L);
    }

    public static void fireLightning(Player player, boolean emitSound) {
        RayTraceResult ray;
        if (emitSound) {
            player.getWorld().playSound((Entity)player, "quake.weapons.lightning_gun.fire", 0.5f, 1.0f);
        }
        if ((ray = WeaponUtil.fireHitscan(player, 1.6, 0.0, 16.0, DamageCause.LIGHTNING, false, WeaponUtil::lightningImpact)) == null) {
            return;
        }
        if (ray.getHitEntity() != null) {
            Entity victim = ray.getHitEntity();
            WeaponUtil.knockback(player.getLocation(), victim, 0.25);
        }
        Location playerLoc = player.getLocation();
        playerLoc.setY(playerLoc.y() + (player.getHeight() - 0.4));
        Vector hitPos = ray.getHitPosition();
        Location hitLoc = new Location(player.getWorld(), hitPos.getX(), hitPos.getY(), hitPos.getZ());
        WeaponUtil.spawnParticlesLine(playerLoc, hitLoc, 4.0, particleLocation -> playerLoc.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, particleLocation, 1, 0.0, 0.0, 0.0, 0.0));
    }

    public static void firePlasma(Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.plasma.fire", 0.5f, 1.0f);
        RayTraceResult raycast = WeaponUtil.cast(player, 0.0, player.isSprinting() ? 6.0 : 2.0);
        if (raycast != null) {
            Location hitLoc = raycast.getHitPosition().toLocation(player.getWorld());
            ProjectileUtil.explodePlasma(hitLoc, (Entity)player, null, true);
            return;
        }
        final Snowball projectile = (Snowball)player.launchProjectile(Snowball.class);
        ProjectileUtil.setProjectileType((Projectile)projectile, "plasma");
        projectile.setShooter((ProjectileSource)player);
        projectile.setGravity(false);
        final Vector vel = player.getEyeLocation().getDirection().multiply(1.75);
        projectile.setVelocity(vel);
        BukkitRunnable particleEmitterRunnable = new BukkitRunnable(){
            private int ticks;

            public void run() {
                if (projectile.isDead()) {
                    this.cancel();
                    return;
                }
                if (this.ticks > 200) {
                    projectile.remove();
                    this.cancel();
                    return;
                }
                projectile.setVelocity(vel);
                Location ploc = projectile.getLocation();
                ploc.getWorld().spawnParticle(Particle.DUST, ploc, 1, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.fromRGB((int)65535), 1.0f));
                ++this.ticks;
            }
        };
        particleEmitterRunnable.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 1L, 1L);
    }

    public static void fireRailgun(Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.railgun.fire", 0.5f, 1.0f);
        RayTraceResult ray = WeaponUtil.fireHitscan(player, 20.0, 0.0, 256.0, DamageCause.RAILGUN, true, null);
        WeaponUtil.applyBlockImpactWithNormal(ray, player.getWorld(), WeaponUtil::railImpact);
        if (ray == null) {
            return;
        }
        if (ray.getHitEntity() != null) {
            Entity victim = ray.getHitEntity();
            WeaponUtil.knockback(player.getLocation(), victim, 1.5);
        }
        Location playerLoc = player.getLocation();
        playerLoc.setY(playerLoc.y() + (player.getHeight() - 0.4));
        Vector hitPos = ray.getHitPosition();
        Location hitLoc = new Location(player.getWorld(), hitPos.getX(), hitPos.getY(), hitPos.getZ());
        WeaponUtil.railTrail(playerLoc, hitLoc);
    }

    public static void fireBFG(final Player player) {
        player.getWorld().playSound((Entity)player, "quake.weapons.bfg.fire", 1.0f, 1.0f);
        new BukkitRunnable(){

            public void run() {
                WeaponUtil.fireBFGGuts(player);
                if (Powerup.hasPowerup(player, PowerupType.QUAD_DAMAGE)) {
                    player.getWorld().playSound((Entity)player, "quake.items.powerups.quad_damage.fire", 0.5f, 1.0f);
                }
            }
        }.runTaskLater((Plugin)QuakePlugin.INSTANCE, 18L);
    }

    private static void fireBFGGuts(final Player player) {
        Location playerLocation = player.getLocation();
        playerLocation.setY(playerLocation.getY() + (player.getHeight() - 0.35));
        RayTraceResult raycast = WeaponUtil.cast(player, 0.0, player.isSprinting() ? 6.0 : 2.0);
        if (raycast != null) {
            Location hitLoc = raycast.getHitPosition().toLocation(player.getWorld());
            ProjectileUtil.explodeBFG(hitLoc, (Entity)player);
            return;
        }
        final Snowball projectile = (Snowball)player.launchProjectile(Snowball.class);
        ProjectileUtil.setProjectileType((Projectile)projectile, "bfg");
        final ItemDisplay display = (ItemDisplay)player.getWorld().spawnEntity(playerLocation, EntityType.ITEM_DISPLAY);
        display.setItemStack(new ItemStack(Material.SLIME_BLOCK));
        projectile.addPassenger((Entity)display);
        projectile.setItem(new ItemStack(Material.AIR));
        projectile.setGravity(false);
        final Vector vel = player.getEyeLocation().getDirection().multiply(0.5);
        projectile.setVelocity(vel);
        BukkitRunnable particleEmitterRunnable = new BukkitRunnable(){
            private int ticks;

            public void run() {
                if (projectile.isDead()) {
                    display.remove();
                    this.cancel();
                    return;
                }
                if (this.ticks > 200) {
                    display.remove();
                    projectile.remove();
                    this.cancel();
                    return;
                }
                projectile.setVelocity(vel);
                Location ploc = projectile.getLocation();
                ploc.getWorld().spawnParticle(Particle.COMPOSTER, ploc, 4, 0.5, 0.5, 0.5, 1.0);
                if (this.ticks % 2 == 0) {
                    for (Entity entity : ploc.getNearbyEntities(10.0, 10.0, 10.0)) {
                        LivingEntity livingEntity;
                        if (!(entity instanceof LivingEntity) || !WeaponUtil.hasLineOfSight((Entity)projectile, (Entity)(livingEntity = (LivingEntity)entity)) || entity == player) continue;
                        if (livingEntity instanceof Player) {
                            Player victim = (Player)livingEntity;
                            QuakeUserState attackerState = QuakePlugin.INSTANCE.userStates.get(player);
                            QuakeUserState victimState = QuakePlugin.INSTANCE.userStates.get(victim);
                            if (victimState.currentMatch != null && (victimState.currentMatch != attackerState.currentMatch || victimState.currentMatch.getTeamOfPlayer(victim) == attackerState.currentMatch.getTeamOfPlayer(player) && (victimState.currentMatch.getTeamOfPlayer(victim) != Team.FREE || attackerState.currentMatch.getTeamOfPlayer(player) != Team.FREE))) continue;
                        }
                        WeaponUtil.damageCustom(livingEntity, 1.0, (Entity)player, DamageCause.BFG_RAY);
                        WeaponUtil.spawnParticlesLine(ploc, livingEntity.getEyeLocation(), 8.0, particleLocation -> ploc.getWorld().spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(particleLocation, Color.fromRGB((int)65280), 2)));
                        livingEntity.getWorld().playSound(livingEntity.getLocation(), "quake.weapons.bfg.laser", 0.5f, 1.0f);
                    }
                }
                ++this.ticks;
            }
        };
        particleEmitterRunnable.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 1L, 1L);
    }

    @FunctionalInterface
    private static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

