/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.combat;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.Arrays;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class WeaponUserState {
    private BukkitRunnable shooter;
    private BukkitTask shooterTask;
    private BukkitRunnable clickDetector;
    private boolean shooting;
    public int[] ammo = new int[]{100, 0, 0, 0, 0, 0, 0};
    public int[] cooldowns = new int[]{0, 0, 0, 0, 0, 0, 0};

    public void shoot(final Player player) {
        if (!player.getInventory().getItemInMainHand().getItemMeta().hasCustomModelData()) {
            return;
        }
        int customModelData = player.getInventory().getItemInMainHand().getItemMeta().getCustomModelData();
        if (customModelData >= WeaponUtil.WEAPONS_NUM) {
            return;
        }
        if (this.ammo[customModelData] <= 0) {
            player.playSound((Entity)player, "quake.weapons.no_ammo", 0.5f, 1.0f);
            return;
        }
        if (this.shooterTask == null || this.shooterTask.isCancelled()) {
            this.shooter = new BukkitRunnable(){
                boolean justStartedShooting = true;

                public void run() {
                    block20: {
                        block19: {
                            for (int i = 0; i < WeaponUserState.this.cooldowns.length; ++i) {
                                if (WeaponUserState.this.cooldowns[i] >= WeaponUtil.PERIODS[i]) {
                                    WeaponUserState.this.cooldowns[i] = 0;
                                    continue;
                                }
                                if (WeaponUserState.this.cooldowns[i] == 0) continue;
                                int n = i;
                                WeaponUserState.this.cooldowns[n] = WeaponUserState.this.cooldowns[n] + 1;
                            }
                            if (player.getInventory().getItemInMainHand().getItemMeta() == null) break block19;
                            if (player.getInventory().getItemInMainHand().getItemMeta().hasCustomModelData()) break block20;
                        }
                        if (Arrays.stream(WeaponUserState.this.cooldowns).allMatch(0::equals)) {
                            this.cancel();
                        }
                        return;
                    }
                    int customModelData2 = player.getInventory().getItemInMainHand().getItemMeta().getCustomModelData();
                    if (WeaponUserState.this.ammo[customModelData2] <= 0) {
                        return;
                    }
                    if (WeaponUserState.this.shooting && WeaponUserState.this.cooldowns[customModelData2] == 0) {
                        boolean isLightningOrBFG;
                        switch (customModelData2) {
                            case 0: {
                                WeaponUtil.fireMachinegun(player);
                                break;
                            }
                            case 1: {
                                WeaponUtil.fireShotgun(player);
                                break;
                            }
                            case 2: {
                                WeaponUtil.fireRocket(player);
                                break;
                            }
                            case 3: {
                                WeaponUtil.fireLightning(player, this.justStartedShooting);
                                break;
                            }
                            case 4: {
                                WeaponUtil.fireRailgun(player);
                                break;
                            }
                            case 5: {
                                WeaponUtil.firePlasma(player);
                                break;
                            }
                            case 6: {
                                WeaponUtil.fireBFG(player);
                                break;
                            }
                            default: {
                                player.sendMessage(TranslationManager.t("error.weapon.unknown", player, new TagResolver[0]));
                                this.cancel();
                                return;
                            }
                        }
                        boolean hasQuad = Powerup.hasPowerup(player, PowerupType.QUAD_DAMAGE);
                        boolean bl = isLightningOrBFG = customModelData2 != 3 && customModelData2 != 6;
                        if (hasQuad && isLightningOrBFG || hasQuad && customModelData2 == 3 && this.justStartedShooting) {
                            player.getWorld().playSound((Entity)player, "quake.items.powerups.quad_damage.fire", 0.5f, 1.0f);
                        }
                        this.justStartedShooting = false;
                        int n = customModelData2;
                        WeaponUserState.this.ammo[n] = WeaponUserState.this.ammo[n] - 1;
                        int n2 = customModelData2;
                        WeaponUserState.this.cooldowns[n2] = WeaponUserState.this.cooldowns[n2] + 1;
                    }
                    if (Arrays.stream(WeaponUserState.this.cooldowns).allMatch(0::equals)) {
                        this.cancel();
                    }
                }
            };
            this.shooterTask = this.shooter.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 1L);
        }
        if (this.clickDetector != null) {
            this.clickDetector.cancel();
        }
        this.shooting = true;
        this.clickDetector = new BukkitRunnable(){

            public void run() {
                WeaponUserState.this.shooting = false;
            }
        };
        this.clickDetector.runTaskLater((Plugin)QuakePlugin.INSTANCE, 4L);
    }
}

