/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.combat;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.combat.MedalType;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public abstract class ProjectileUtil {
    public static String getProjectileType(Projectile projectile) {
        PersistentDataContainer pdc = projectile.getPersistentDataContainer();
        return (String)pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "projectile_type"), PersistentDataType.STRING);
    }

    public static void setProjectileType(Projectile projectile, String type) {
        PersistentDataContainer pdc = projectile.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "projectile_type"), PersistentDataType.STRING, (Object)type);
    }

    public static void impactRocket(ProjectileHitEvent event) {
        ProjectileSource attacker = event.getEntity().getShooter();
        Entity hitEntity = event.getHitEntity();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            hitLivingEntity.setNoDamageTicks(0);
            event.getEntity().remove();
        }
        Location loc = event.getEntity().getLocation();
        ProjectileUtil.explodeRocket(loc, (Entity)attacker, hitEntity);
    }

    public static void explodeRocket(Location loc, Entity attacker, Entity impactEntity) {
        loc.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 1.5f, 0.7f);
        loc.getWorld().spawnParticle(Particle.POOF, loc, 16, 0.0, 0.0, 0.0, 0.25);
        loc.getWorld().spawnParticle(Particle.EXPLOSION, loc, 1, 0.0, 0.0, 0.0, 0.25, null, true);
        ProjectileUtil.explodeCustom(loc, attacker, impactEntity, 5.0, 20.0, 10.0, 0.8, DamageCause.ROCKET, DamageCause.ROCKET_SPLASH);
    }

    public static void explodeBFG(Location loc, Entity attacker) {
        ProjectileUtil.explodeCustom(loc, attacker, null, 10.0, 40.0, 40.0, 2.0, DamageCause.BFG, DamageCause.BFG_SPLASH);
        loc.getWorld().playSound(loc, "quake.weapons.bfg.explode", 2.0f, 1.0f);
        loc.getWorld().spawnParticle(Particle.EXPLOSION_EMITTER, loc, 1, 0.0, 0.0, 0.0, 0.0, null, true);
        Location center = loc.clone();
        center.setY(center.getY() + 0.05);
        Color trailColor = Color.fromRGB((int)65280);
        Random random = new Random();
        for (int i = 0; i < 1024; ++i) {
            double destX = (random.nextDouble() - 0.5) * 8.0;
            double destY = (random.nextDouble() - 0.5) * 8.0;
            double destZ = (random.nextDouble() - 0.5) * 8.0;
            int durationTicks = random.nextInt(30);
            Location startLocation = center.clone().add(random.nextDouble() * 0.25, random.nextDouble() * 0.25, random.nextDouble() * 0.25);
            Location targetLocation = center.clone().add(destX, destY, destZ);
            Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, durationTicks);
            center.getWorld().spawnParticle(Particle.TRAIL, startLocation, 0, (Object)trailData);
        }
    }

    public static void impactPlasma(ProjectileHitEvent event) {
        ProjectileSource attacker = event.getEntity().getShooter();
        Entity hitEntity = event.getHitEntity();
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerEntity = (LivingEntity)attacker;
            if (hitEntity instanceof LivingEntity) {
                LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
                hitLivingEntity.setNoDamageTicks(0);
                WeaponUtil.damageCustom(hitLivingEntity, 6.0, (Entity)attackerEntity, DamageCause.PLASMA);
                event.getEntity().remove();
            }
            Location impactLoc = event.getEntity().getLocation();
            ProjectileUtil.explodePlasma(impactLoc, (Entity)attacker, hitEntity, event.getHitBlock() != null);
        }
    }

    public static void explodePlasma(Location loc, Entity attacker, Entity impactEntity, boolean hitBlock) {
        if (hitBlock) {
            loc.getWorld().playSound(loc, "quake.weapons.impact_energy", 0.5f, 1.0f);
            loc.getWorld().spawnParticle(Particle.SMOKE, loc, 16, 0.0, 0.0, 0.0, 0.1);
        }
        Location center = loc.clone();
        center.setY(center.getY() + 0.05);
        Color trailColor = Color.fromRGB((int)65535);
        Random random = new Random();
        for (int i = 0; i < 32; ++i) {
            double destX = (random.nextDouble() - 0.5) * 2.0;
            double destY = (random.nextDouble() - 0.5) * 2.0;
            double destZ = (random.nextDouble() - 0.5) * 2.0;
            int durationTicks = random.nextInt(8) + 5;
            Location targetLocation = center.clone().add(destX, destY, destZ);
            Particle.Trail trailData = new Particle.Trail(targetLocation, trailColor, durationTicks);
            center.getWorld().spawnParticle(Particle.TRAIL, center, 0, (Object)trailData);
        }
        ProjectileUtil.explodeCustom(loc, attacker, impactEntity, 2.0, 6.0, 6.0, 0.4, DamageCause.PLASMA, DamageCause.PLASMA_SPLASH);
    }

    public static void impactBFG(ProjectileHitEvent event) {
        ProjectileSource attacker = event.getEntity().getShooter();
        Entity hitEntity = event.getHitEntity();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            hitLivingEntity.setNoDamageTicks(0);
            event.getEntity().remove();
        }
        Location loc = event.getEntity().getLocation();
        ProjectileUtil.explodeBFG(loc, (Entity)attacker);
    }

    public static void explodeCustom(Location impactLocation, Entity attacker, Entity hitEntity, double explosionRadius, double directDamage, double splashDamage, double knockback, DamageCause directCause, DamageCause splashCause) {
        boolean awardedAccuracy = false;
        for (Entity entity : impactLocation.getWorld().getNearbyEntities(impactLocation, explosionRadius, explosionRadius, explosionRadius)) {
            Player pAttacker;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity victim = (LivingEntity)entity;
            Location loc = entity.getLocation();
            Location eloc = victim.getEyeLocation();
            double distance = impactLocation.distance(loc);
            double entityDamage = splashDamage * (1.0 - distance / explosionRadius);
            if (entityDamage < 0.0) continue;
            victim.setNoDamageTicks(0);
            if (attacker instanceof Player && Powerup.hasPowerup(pAttacker = (Player)attacker, PowerupType.QUAD_DAMAGE)) {
                knockback *= 3.0;
            }
            if (!awardedAccuracy && attacker instanceof Player) {
                QuakeUserState attackerState;
                pAttacker = (Player)attacker;
                if (victim instanceof Player && (directCause == DamageCause.ROCKET || splashCause == DamageCause.ROCKET_SPLASH) && !victim.isOnGround() && attacker != victim && (attackerState = QuakePlugin.INSTANCE.userStates.get(pAttacker)) != null) {
                    attackerState.awardMedal(MedalType.ACCURACY);
                    awardedAccuracy = true;
                }
            }
            if (hitEntity != null && entity == hitEntity) {
                WeaponUtil.damageCustom(victim, directDamage, attacker, directCause);
            } else {
                WeaponUtil.damageCustom(victim, entityDamage, attacker, splashCause);
            }
            Vector direction = eloc.toVector().subtract(impactLocation.toVector()).normalize();
            Vector knockbackVector = direction.multiply(knockback);
            Vector currentVelocity = entity.getVelocity();
            entity.setVelocity(currentVelocity.add(knockbackVector));
        }
    }
}

