/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.events.listeners;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.movement.StrafeJumpHandler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class MiscListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player joinedPlayer = event.getPlayer();
        for (QuakeUserState userState : QuakePlugin.INSTANCE.userStates.values()) {
            if (userState.currentMatch == null) continue;
            userState.getPlayer().unlistPlayer(joinedPlayer);
        }
        QuakePlugin.INSTANCE.initPlayer(joinedPlayer);
        joinedPlayer.teleport(QuakePlugin.LOBBY);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState.currentMatch != null) {
            userState.currentMatch.leave(player);
        }
        QuakePlugin.INSTANCE.userStates.remove(player);
        player.teleport(QuakePlugin.LOBBY);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER || event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (event.getEntity().getFallDistance() < 10.0f) {
            event.setCancelled(true);
        }
        event.setDamage(2.0);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState.currentMatch != null && userState.currentMatch.matchEnding) {
            event.setCancelled(true);
            return;
        }
        ++userState.strafeJumpTicks;
        Vector velocity = event.getTo().toVector().subtract(event.getFrom().toVector());
        StrafeJumpHandler.applyStrafeAcceleration(player, userState, velocity);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player teleportingPlayer = event.getPlayer();
        for (Entity entity : event.getTo().getWorld().getNearbyEntities(event.getTo(), 1.5, 2.0, 1.5)) {
            if (entity.equals((Object)teleportingPlayer) || !(entity instanceof LivingEntity)) continue;
            LivingEntity victim = (LivingEntity)entity;
            WeaponUtil.damageCustom(victim, 1000.0, (Entity)teleportingPlayer, DamageCause.TELEFRAG);
        }
    }
}

