/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.events.listeners;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.triggers.Jumppad;
import com.github.polyzium.quakechasm.game.entities.triggers.Portal;
import com.github.polyzium.quakechasm.game.mapper.EntityTool;
import com.github.polyzium.quakechasm.game.mapper.JumppadTool;
import com.github.polyzium.quakechasm.game.mapper.PortalTool;
import com.github.polyzium.quakechasm.game.mapper.SpawnerTool;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.apache.commons.lang3.SerializationUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.joml.Vector3d;

public class MapperToolListener
implements Listener {
    private static final String ENTITY_TOOL_KEY = "entity_tool";
    private static final String JUMPPAD_TOOL_KEY = "jumppad_tool";
    private static final String SPAWNPOINT_TOOL_KEY = "spawnpoint_tool";
    private static final String PORTAL_TOOL_KEY = "portal_tool";
    public static final int TOOL_UPDATE_TICKS = 4;

    public static boolean isEntityTool(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, ENTITY_TOOL_KEY), PersistentDataType.BYTE);
    }

    public static ItemStack createEntityTool() {
        ItemStack tool = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = tool.getItemMeta();
        meta.displayName(TranslationManager.t("mapper.tool.entity.name", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(TranslationManager.t("mapper.tool.entity.lore.leftClick", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.entity.lore.rightClick", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, ENTITY_TOOL_KEY), PersistentDataType.BYTE, (Object)1);
        tool.setItemMeta(meta);
        return tool;
    }

    public static boolean isJumppadTool(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, JUMPPAD_TOOL_KEY), PersistentDataType.BYTE);
    }

    public static ItemStack createJumppadTool() {
        ItemStack tool = new ItemStack(Material.STICK);
        ItemMeta meta = tool.getItemMeta();
        meta.displayName(TranslationManager.t("mapper.tool.jumppad.name", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(TranslationManager.t("mapper.tool.jumppad.lore.pointAtJumppad", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.jumppad.lore.leftClickEdit", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.jumppad.lore.pointAtBlock", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.jumppad.lore.rightClickPlace", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.jumppad.lore.rightClickLanding", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.jumppad.lore.leftClickCancel", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, JUMPPAD_TOOL_KEY), PersistentDataType.BYTE, (Object)1);
        tool.setItemMeta(meta);
        return tool;
    }

    public static boolean isSpawnpointTool(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, SPAWNPOINT_TOOL_KEY), PersistentDataType.STRING);
    }

    public static Team getSpawnpointTeam(ItemStack item) {
        if (!MapperToolListener.isSpawnpointTool(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        String teamName = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, SPAWNPOINT_TOOL_KEY), PersistentDataType.STRING);
        try {
            return Team.valueOf(teamName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ItemStack createSpawnpointTool(Team team) {
        ItemStack tool = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta meta = (LeatherArmorMeta)tool.getItemMeta();
        int colorRGB = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> 11546150;
            case Team.BLUE -> 3949738;
            case Team.FREE -> 16701501;
            case Team.SPECTATOR -> 8991416;
        };
        meta.setColor(Color.fromRGB((int)colorRGB));
        String teamKey = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> "mapper.tool.spawnpoint.name.red";
            case Team.BLUE -> "mapper.tool.spawnpoint.name.blue";
            case Team.FREE -> "mapper.tool.spawnpoint.name.free";
            case Team.SPECTATOR -> "mapper.tool.spawnpoint.name.spectator";
        };
        String teamNameKey = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> "mapper.tool.spawnpoint.team.red";
            case Team.BLUE -> "mapper.tool.spawnpoint.team.blue";
            case Team.FREE -> "mapper.tool.spawnpoint.team.free";
            case Team.SPECTATOR -> "mapper.tool.spawnpoint.team.spectator";
        };
        meta.displayName(TranslationManager.t(teamKey, TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of(TranslationManager.t("mapper.tool.spawnpoint.lore.rightClick", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.spawnpoint.lore.team", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"team", (String)TranslationManager.tLegacy(teamNameKey, TranslationManager.FALLBACK))}).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, SPAWNPOINT_TOOL_KEY), PersistentDataType.STRING, (Object)team.name());
        tool.setItemMeta((ItemMeta)meta);
        return tool;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (MapperToolListener.isEntityTool(item)) {
            this.handleEntityToolInteraction(event, player);
            return;
        }
        if (MapperToolListener.isJumppadTool(item)) {
            this.handleJumppadToolInteraction(event, player);
            return;
        }
        if (MapperToolListener.isSpawnpointTool(item)) {
            this.handleSpawnpointToolInteraction(event, player, item);
            return;
        }
        if (PortalTool.isPortalTool(item)) {
            this.handlePortalToolInteraction(event, player);
            return;
        }
        if (SpawnerTool.isSpawnerTool(item)) {
            this.handleSpawnerToolInteraction(event, player, item);
            return;
        }
    }

    private void handleSpawnpointToolInteraction(PlayerInteractEvent event, Player player, ItemStack item) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        event.setCancelled(true);
        Team team = MapperToolListener.getSpawnpointTeam(item);
        if (team == null) {
            player.sendMessage(TranslationManager.t("mapper.tool.spawnpoint.message.invalid", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        Location clickedBlock = event.getClickedBlock().getLocation();
        Location spawnLoc = clickedBlock.clone().add(0.5, 1.0, 0.5);
        float playerYaw = player.getLocation().getYaw();
        playerYaw += 180.0f;
        playerYaw = (playerYaw % 360.0f + 360.0f) % 360.0f;
        float snappedYaw = (float)Math.round(playerYaw / 45.0f) * 45.0f;
        spawnLoc.setYaw(snappedYaw);
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawnEntity(spawnLoc, EntityType.ARMOR_STAND);
        armorStand.setGravity(false);
        armorStand.setVisible(true);
        armorStand.setBasePlate(true);
        armorStand.setArms(false);
        ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta chestplateMeta = (LeatherArmorMeta)chestplate.getItemMeta();
        int chestplateColor = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> 11546150;
            case Team.BLUE -> 3949738;
            case Team.FREE -> 16701501;
            case Team.SPECTATOR -> 8991416;
        };
        chestplateMeta.setColor(Color.fromRGB((int)chestplateColor));
        chestplate.setItemMeta((ItemMeta)chestplateMeta);
        EntityEquipment equipment = armorStand.getEquipment();
        equipment.setChestplate(chestplate);
        String teamNameKey = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> "mapper.tool.spawnpoint.team.red";
            case Team.BLUE -> "mapper.tool.spawnpoint.team.blue";
            case Team.FREE -> "mapper.tool.spawnpoint.team.free";
            case Team.SPECTATOR -> "mapper.tool.spawnpoint.team.spectator";
        };
        player.sendMessage(TranslationManager.t("mapper.tool.spawnpoint.message.placed", player, new TagResolver[]{Placeholder.unparsed((String)"team", (String)TranslationManager.tLegacy(teamNameKey, player)), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", spawnLoc.getX(), spawnLoc.getY(), spawnLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
    }

    private void handleEntityToolInteraction(PlayerInteractEvent event, Player player) {
        event.setCancelled(true);
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState == null) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            if (userState.movingEntity != null) {
                userState.movingEntity = null;
                player.sendMessage(TranslationManager.t("mapper.tool.entity.message.cancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else {
                Trigger target = EntityTool.getTargetEntity(player);
                EntityTool.removeEntity(player, target);
            }
        } else if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            if (userState.movingEntity == null) {
                Trigger target = EntityTool.getTargetEntity(player);
                if (target != null) {
                    userState.movingEntity = target;
                    EntityTool.startMovingEntity(player, target);
                }
            } else {
                RayTraceResult blockRayTrace = player.rayTraceBlocks(10.0);
                if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                    Vector hitPosition = blockRayTrace.getHitPosition();
                    Location newLocation = hitPosition.toLocation(player.getWorld());
                    BoundingBox offsetBox = userState.movingEntity.getOffsetBoundingBox();
                    double minYOffset = offsetBox != null ? -offsetBox.getMinY() : 1.0;
                    newLocation.set(Math.floor(newLocation.x()) + 0.5, Math.floor(newLocation.y()) + minYOffset, Math.floor(newLocation.z()) + 0.5);
                    EntityTool.stopMovingEntity(player, userState.movingEntity, newLocation);
                } else {
                    player.sendMessage(TranslationManager.t("mapper.tool.entity.message.noBlock", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
                }
                userState.movingEntity = null;
            }
        }
    }

    private void handleJumppadToolInteraction(PlayerInteractEvent event, Player player) {
        event.setCancelled(true);
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState == null) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            if (userState.jumppadPlacementLoc != null) {
                userState.jumppadPlacementLoc = null;
                player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.cancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else if (userState.settingLandingPos && userState.editingJumppad != null) {
                userState.editingJumppad = null;
                userState.settingLandingPos = false;
                player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.editCancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else {
                Trigger target = EntityTool.getTargetEntity(player);
                if (target instanceof Jumppad) {
                    Jumppad jumppad;
                    userState.editingJumppad = jumppad = (Jumppad)target;
                    userState.settingLandingPos = true;
                    player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.clickLanding", player, new TagResolver[0]).color((TextColor)NamedTextColor.GREEN));
                } else {
                    player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.pointAtJumppad", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
                }
            }
        } else if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            RayTraceResult blockRayTrace = player.rayTraceBlocks(100.0);
            if (blockRayTrace == null || blockRayTrace.getHitBlock() == null) {
                player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.noBlock", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
                return;
            }
            Vector hitPosition = blockRayTrace.getHitPosition();
            Location targetLoc = hitPosition.toLocation(player.getWorld());
            targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
            if (userState.settingLandingPos && userState.editingJumppad != null) {
                Location jumppadLoc = userState.editingJumppad.getLocation();
                Vector launchVec = JumppadTool.calculateLaunchVector(jumppadLoc, targetLoc, userState.jumppadPowerMultiplier);
                if (launchVec != null) {
                    userState.editingJumppad.remove();
                    QuakePlugin.INSTANCE.triggers.remove(userState.editingJumppad);
                    new Jumppad(jumppadLoc, launchVec);
                    player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.updated", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ())), Placeholder.unparsed((String)"power", (String)String.format("%.1f", userState.jumppadPowerMultiplier))}).color((TextColor)NamedTextColor.GREEN));
                    userState.editingJumppad = null;
                    userState.settingLandingPos = false;
                } else {
                    player.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("mapper.tool.jumppad.message.trajectoryFailed", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(200L))));
                }
            } else if (userState.jumppadPlacementLoc == null) {
                userState.jumppadPlacementLoc = targetLoc;
                player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.locationSet", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
            } else {
                Location jumppadLoc = userState.jumppadPlacementLoc;
                Vector launchVec = JumppadTool.calculateLaunchVector(jumppadLoc, targetLoc, userState.jumppadPowerMultiplier);
                if (launchVec != null) {
                    new Jumppad(jumppadLoc, launchVec);
                    player.sendMessage(TranslationManager.t("mapper.tool.jumppad.message.created", player, new TagResolver[]{Placeholder.unparsed((String)"location1", (String)String.format("%.1f %.1f %.1f", jumppadLoc.getX(), jumppadLoc.getY(), jumppadLoc.getZ())), Placeholder.unparsed((String)"location2", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ())), Placeholder.unparsed((String)"power", (String)String.format("%.1f", userState.jumppadPowerMultiplier))}).color((TextColor)NamedTextColor.GREEN));
                    userState.jumppadPlacementLoc = null;
                } else {
                    player.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("mapper.tool.jumppad.message.trajectoryFailed", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(200L))));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        ItemStack oldItem = player.getInventory().getItem(event.getPreviousSlot());
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (MapperToolListener.isJumppadTool(oldItem) && (userState.jumppadPlacementLoc != null || userState.settingLandingPos)) {
            int slotDiff = event.getNewSlot() - event.getPreviousSlot();
            if (slotDiff > 5) {
                slotDiff -= 9;
            } else if (slotDiff < -5) {
                slotDiff += 9;
            }
            userState.jumppadPowerMultiplier += (double)slotDiff * 0.1;
            userState.jumppadPowerMultiplier = Math.max(0.1, Math.min(10.0, userState.jumppadPowerMultiplier));
            JumppadTool.displayPowerMultiplier(player, userState.jumppadPowerMultiplier);
            event.setCancelled(true);
            return;
        }
        if (MapperToolListener.isEntityTool(newItem)) {
            userState.holdingEntityTool = true;
            this.startEntityToolVisualization(player, userState);
            return;
        }
        userState.holdingEntityTool = false;
        if (MapperToolListener.isJumppadTool(newItem)) {
            this.startJumppadToolVisualization(player, userState);
            return;
        }
        if (PortalTool.isPortalTool(newItem)) {
            this.startPortalToolVisualization(player, userState);
            return;
        }
    }

    private void startEntityToolVisualization(final Player player, final QuakeUserState userState) {
        new BukkitRunnable(this){

            public void run() {
                ItemStack currentItem = player.getInventory().getItemInMainHand();
                if (!MapperToolListener.isEntityTool(currentItem)) {
                    this.cancel();
                    return;
                }
                Trigger target = EntityTool.getTargetEntity(player);
                EntityTool.displayEntityInfo(player, target);
                if (userState.movingEntity != null) {
                    EntityTool.visualizeEntityWithColor(player, userState.movingEntity, Color.fromRGB((int)0xFFFF00));
                    RayTraceResult blockRayTrace = player.rayTraceBlocks(10.0);
                    if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                        Vector hitPosition = blockRayTrace.getHitPosition();
                        Location targetLocation = hitPosition.toLocation(player.getWorld());
                        BoundingBox offsetBox = userState.movingEntity.getOffsetBoundingBox();
                        double minYOffset = offsetBox != null ? -offsetBox.getMinY() : 1.0;
                        targetLocation.set(Math.floor(targetLocation.x()) + 0.5, Math.floor(targetLocation.y()) + minYOffset, Math.floor(targetLocation.z()) + 0.5);
                        if (offsetBox != null) {
                            BoundingBox previewBox = offsetBox.clone().shift(targetLocation.toVector());
                            EntityTool.drawBoundingBox(player.getWorld(), previewBox, Color.fromRGB((int)65280), 4, 16.0);
                        }
                    }
                } else if (target != null) {
                    EntityTool.visualizeTargetEntity(player, target);
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 4L);
    }

    private void startJumppadToolVisualization(final Player player, final QuakeUserState userState) {
        new BukkitRunnable(this){

            public void run() {
                ItemStack currentItem = player.getInventory().getItemInMainHand();
                if (!MapperToolListener.isJumppadTool(currentItem)) {
                    this.cancel();
                    return;
                }
                RayTraceResult blockRayTrace = player.rayTraceBlocks(100.0);
                if (userState.settingLandingPos && userState.editingJumppad != null) {
                    JumppadTool.visualizeTrajectory(userState.editingJumppad.getLocation(), userState.editingJumppad.getLaunchVec(), Color.fromRGB((int)0xFFFF00), 4);
                    if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                        Location targetLoc = blockRayTrace.getHitPosition().toLocation(player.getWorld());
                        targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
                        Vector newLaunchVec = JumppadTool.calculateLaunchVector(userState.editingJumppad.getLocation(), targetLoc, userState.jumppadPowerMultiplier);
                        if (newLaunchVec != null) {
                            JumppadTool.visualizeTrajectory(userState.editingJumppad.getLocation(), newLaunchVec, Color.fromRGB((int)65280), 4);
                        }
                    }
                } else if (userState.jumppadPlacementLoc != null) {
                    Location jpLoc = userState.jumppadPlacementLoc;
                    jpLoc.getWorld().spawnParticle(Particle.TRAIL, jpLoc.clone().add(0.0, 0.5, 0.0), 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(jpLoc, Color.fromRGB((int)0xFFFF00), 20));
                    if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                        Location targetLoc = blockRayTrace.getHitPosition().toLocation(player.getWorld());
                        targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
                        Vector launchVec = JumppadTool.calculateLaunchVector(jpLoc, targetLoc, userState.jumppadPowerMultiplier);
                        if (launchVec != null) {
                            JumppadTool.visualizeTrajectory(jpLoc, launchVec, Color.fromRGB((int)65280), 4);
                        }
                    }
                } else {
                    Trigger target = EntityTool.getTargetEntity(player);
                    if (target instanceof Jumppad) {
                        Jumppad jumppad = (Jumppad)target;
                        JumppadTool.visualizeTrajectory(jumppad.getLocation(), jumppad.getLaunchVec(), Color.fromRGB((int)30719), 20);
                        JumppadTool.displayJumppadInfo(player, jumppad);
                    } else if (userState.jumppadPlacementLoc != null || userState.settingLandingPos) {
                        JumppadTool.displayPowerMultiplier(player, userState.jumppadPowerMultiplier);
                    }
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 4L);
    }

    private void handlePortalToolInteraction(PlayerInteractEvent event, Player player) {
        event.setCancelled(true);
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState == null) {
            return;
        }
        PortalTool.PortalToolData toolData = userState.portalToolData;
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
            if (toolData.state == PortalTool.PortalToolState.PLACING_PORTAL) {
                toolData.reset();
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.placementCancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else if (toolData.state == PortalTool.PortalToolState.SETTING_TARGET) {
                toolData.reset();
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.targetCancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else if (toolData.state == PortalTool.PortalToolState.EDITING_TARGET) {
                toolData.reset();
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.editCancelled", player, new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            } else {
                Trigger target = EntityTool.getTargetEntity(player);
                if (target instanceof Portal) {
                    Portal portal = (Portal)target;
                    toolData.state = PortalTool.PortalToolState.EDITING_TARGET;
                    toolData.editingPortal = portal;
                    player.sendMessage(TranslationManager.t("mapper.tool.portal.message.clickTarget", player, new TagResolver[0]).color((TextColor)NamedTextColor.GREEN));
                } else {
                    player.sendMessage(TranslationManager.t("mapper.tool.portal.message.pointAtPortal", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
                }
            }
        } else if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            RayTraceResult blockRayTrace = player.rayTraceBlocks(100.0);
            if (blockRayTrace == null || blockRayTrace.getHitBlock() == null) {
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.noBlock", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
                return;
            }
            Vector hitPosition = blockRayTrace.getHitPosition();
            Location targetLoc = hitPosition.toLocation(player.getWorld());
            targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
            float exitYaw = player.getLocation().getYaw();
            exitYaw = (exitYaw % 360.0f + 360.0f) % 360.0f;
            exitYaw = (float)Math.round(exitYaw / 45.0f) * 45.0f;
            targetLoc.setYaw(exitYaw);
            targetLoc.setPitch(0.0f);
            if (toolData.state == PortalTool.PortalToolState.EDITING_TARGET) {
                Location portalLoc = toolData.editingPortal.getLocation();
                toolData.editingPortal.remove();
                QuakePlugin.INSTANCE.triggers.remove(toolData.editingPortal);
                new Portal(portalLoc, targetLoc);
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.targetUpdated", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
                toolData.reset();
            } else if (toolData.state == PortalTool.PortalToolState.SETTING_TARGET) {
                Location portalLoc = toolData.portalLocation;
                new Portal(portalLoc, targetLoc);
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.created", player, new TagResolver[]{Placeholder.unparsed((String)"location1", (String)String.format("%.1f %.1f %.1f", portalLoc.getX(), portalLoc.getY(), portalLoc.getZ())), Placeholder.unparsed((String)"location2", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
                toolData.reset();
            } else {
                toolData.state = PortalTool.PortalToolState.SETTING_TARGET;
                toolData.portalLocation = targetLoc;
                player.sendMessage(TranslationManager.t("mapper.tool.portal.message.locationSet", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
            }
        }
    }

    private void startPortalToolVisualization(final Player player, final QuakeUserState userState) {
        new BukkitRunnable(this){

            public void run() {
                ItemStack currentItem = player.getInventory().getItemInMainHand();
                if (!PortalTool.isPortalTool(currentItem)) {
                    this.cancel();
                    return;
                }
                PortalTool.PortalToolData toolData = userState.portalToolData;
                RayTraceResult blockRayTrace = player.rayTraceBlocks(100.0);
                if (toolData.state == PortalTool.PortalToolState.EDITING_TARGET) {
                    Location portalLoc = toolData.editingPortal.getLocation();
                    BoundingBox portalBox = new BoundingBox(portalLoc.getX() - 0.5, portalLoc.getY(), portalLoc.getZ() - 0.5, portalLoc.getX() + 0.5, portalLoc.getY() + 2.0, portalLoc.getZ() + 0.5);
                    EntityTool.drawBoundingBox(player.getWorld(), portalBox, Color.fromRGB((int)0xFFFF00), 4, 16.0);
                    if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                        Location targetLoc = blockRayTrace.getHitPosition().toLocation(player.getWorld());
                        targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
                        float exitYaw = player.getLocation().getYaw();
                        exitYaw = (exitYaw % 360.0f + 360.0f) % 360.0f;
                        exitYaw = (float)Math.round(exitYaw / 45.0f) * 45.0f;
                        BoundingBox targetBox = new BoundingBox(targetLoc.getX() - 0.5, targetLoc.getY(), targetLoc.getZ() - 0.5, targetLoc.getX() + 0.5, targetLoc.getY() + 2.0, targetLoc.getZ() + 0.5);
                        EntityTool.drawBoundingBox(player.getWorld(), targetBox, Color.fromRGB((int)65280), 4, 16.0);
                        EntityTool.drawLine(player.getWorld(), portalLoc.getX(), portalLoc.getY() + 1.0, portalLoc.getZ(), targetLoc.getX(), targetLoc.getY() + 1.0, targetLoc.getZ(), Color.fromRGB((int)0xFFFFFF), 4, 16.0);
                        Location eyePos = targetLoc.clone().add(0.0, 1.62, 0.0);
                        double angleRadians = Math.toRadians(exitYaw);
                        Location angleEnd = eyePos.clone().add(-Math.sin(angleRadians) * 1.5, 0.0, Math.cos(angleRadians) * 1.5);
                        EntityTool.drawLine(player.getWorld(), eyePos.getX(), eyePos.getY(), eyePos.getZ(), angleEnd.getX(), angleEnd.getY(), angleEnd.getZ(), Color.fromRGB((int)0xFF0000), 4, 16.0);
                    }
                } else if (toolData.state == PortalTool.PortalToolState.SETTING_TARGET) {
                    Location portalLoc = toolData.portalLocation;
                    BoundingBox portalBox = new BoundingBox(portalLoc.getX() - 0.5, portalLoc.getY(), portalLoc.getZ() - 0.5, portalLoc.getX() + 0.5, portalLoc.getY() + 2.0, portalLoc.getZ() + 0.5);
                    EntityTool.drawBoundingBox(player.getWorld(), portalBox, Color.fromRGB((int)0xFFFF00), 4, 16.0);
                    if (blockRayTrace != null && blockRayTrace.getHitBlock() != null) {
                        Location targetLoc = blockRayTrace.getHitPosition().toLocation(player.getWorld());
                        targetLoc.set(Math.floor(targetLoc.x()) + 0.5, Math.floor(targetLoc.y()), Math.floor(targetLoc.z()) + 0.5);
                        float exitYaw = player.getLocation().getYaw();
                        exitYaw = (exitYaw % 360.0f + 360.0f) % 360.0f;
                        exitYaw = (float)Math.round(exitYaw / 45.0f) * 45.0f;
                        BoundingBox targetBox = new BoundingBox(targetLoc.getX() - 0.5, targetLoc.getY(), targetLoc.getZ() - 0.5, targetLoc.getX() + 0.5, targetLoc.getY() + 2.0, targetLoc.getZ() + 0.5);
                        EntityTool.drawBoundingBox(player.getWorld(), targetBox, Color.fromRGB((int)65280), 4, 16.0);
                        EntityTool.drawLine(player.getWorld(), portalLoc.getX(), portalLoc.getY() + 1.0, portalLoc.getZ(), targetLoc.getX(), targetLoc.getY() + 1.0, targetLoc.getZ(), Color.fromRGB((int)0xFFFFFF), 4, 16.0);
                        Location eyePos = targetLoc.clone().add(0.0, 1.62, 0.0);
                        double angleRadians = Math.toRadians(exitYaw);
                        Location angleEnd = eyePos.clone().add(-Math.sin(angleRadians) * 1.5, 0.0, Math.cos(angleRadians) * 1.5);
                        EntityTool.drawLine(player.getWorld(), eyePos.getX(), eyePos.getY(), eyePos.getZ(), angleEnd.getX(), angleEnd.getY(), angleEnd.getZ(), Color.fromRGB((int)0xFF0000), 4, 16.0);
                    }
                } else {
                    Trigger target = EntityTool.getTargetEntity(player);
                    if (target instanceof Portal) {
                        Portal portal = (Portal)target;
                        Location portalLoc = portal.getLocation();
                        EntityTool.visualizeTargetEntity(player, portal);
                        PersistentDataContainer pdc = portal.getEntity().getPersistentDataContainer();
                        byte[] targetPosData = (byte[])pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_pos"), PersistentDataType.BYTE_ARRAY);
                        byte[] targetDirData = (byte[])pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_dir"), PersistentDataType.BYTE_ARRAY);
                        if (targetPosData != null && targetDirData != null) {
                            Vector targetPos = Vector.fromJOML((Vector3d)((Vector3d)SerializationUtils.deserialize(targetPosData)));
                            Vector targetDir = Vector.fromJOML((Vector3d)((Vector3d)SerializationUtils.deserialize(targetDirData)));
                            Location targetLoc = targetPos.toLocation(portalLoc.getWorld()).setDirection(targetDir);
                            BoundingBox targetBox = new BoundingBox(targetLoc.getX() - 0.5, targetLoc.getY(), targetLoc.getZ() - 0.5, targetLoc.getX() + 0.5, targetLoc.getY() + 2.0, targetLoc.getZ() + 0.5);
                            EntityTool.drawBoundingBox(player.getWorld(), targetBox, Color.fromRGB((int)65280), 4, 16.0);
                            EntityTool.drawLine(player.getWorld(), portalLoc.getX(), portalLoc.getY() + 1.0, portalLoc.getZ(), targetLoc.getX(), targetLoc.getY() + 1.0, targetLoc.getZ(), Color.fromRGB((int)0xFFFFFF), 4, 16.0);
                            float exitYaw = targetLoc.getYaw();
                            Location eyePos = targetLoc.clone().add(0.0, 1.62, 0.0);
                            double angleRadians = Math.toRadians(exitYaw);
                            Location angleEnd = eyePos.clone().add(-Math.sin(angleRadians) * 1.5, 0.0, Math.cos(angleRadians) * 1.5);
                            EntityTool.drawLine(player.getWorld(), eyePos.getX(), eyePos.getY(), eyePos.getZ(), angleEnd.getX(), angleEnd.getY(), angleEnd.getZ(), Color.fromRGB((int)0xFF0000), 4, 16.0);
                            player.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("mapper.tool.portal.subtitle.target", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", targetLoc.getX(), targetLoc.getY(), targetLoc.getZ())), Placeholder.unparsed((String)"yaw", (String)String.format("%.0f", Float.valueOf(exitYaw)))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(200L))));
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 4L);
    }

    private void handleSpawnerToolInteraction(PlayerInteractEvent event, Player player, ItemStack item) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        event.setCancelled(true);
        String toolType = SpawnerTool.getSpawnerToolType(item);
        if (toolType == null) {
            player.sendMessage(TranslationManager.t("mapper.tool.spawner.message.invalid", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        Location clickedBlock = event.getClickedBlock().getLocation();
        Location spawnLoc = clickedBlock.clone().add(0.5, 2.0, 0.5);
        SpawnerTool.placeSpawner(toolType, spawnLoc);
        String spawnerName = item.getItemMeta().displayName() != null ? PlainTextComponentSerializer.plainText().serialize(item.getItemMeta().displayName()) : toolType;
        player.sendMessage(TranslationManager.t("mapper.tool.spawner.message.placed", player, new TagResolver[]{Placeholder.unparsed((String)"spawner", (String)spawnerName), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", spawnLoc.getX(), spawnLoc.getY(), spawnLoc.getZ()))}).color((TextColor)NamedTextColor.GREEN));
    }
}

