/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.events.listeners;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.combat.DamageData;
import com.github.polyzium.quakechasm.game.combat.MedalType;
import com.github.polyzium.quakechasm.game.combat.ProjectileUtil;
import com.github.polyzium.quakechasm.game.combat.WeaponUserState;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CombatListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() != Material.CARROT_ON_A_STICK) {
            return;
        }
        QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
        if (state.currentMatch != null && state.currentMatch.matchEnding) {
            event.setCancelled(true);
            return;
        }
        state.weaponState.shoot(player);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntityType() != EntityType.SNOWBALL) {
            return;
        }
        event.setCancelled(true);
        switch (ProjectileUtil.getProjectileType(event.getEntity())) {
            case "rocket": {
                ProjectileUtil.impactRocket(event);
                break;
            }
            case "plasma": {
                ProjectileUtil.impactPlasma(event);
                break;
            }
            case "bfg": {
                ProjectileUtil.impactBFG(event);
            }
        }
    }

    @EventHandler
    public void onKnockback(EntityKnockbackByEntityEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        double finalMaxHealth;
        Entity victim;
        Player player;
        EntityDamageByEntityEvent attackEvent;
        boolean isMeleeDamage;
        boolean bl = isMeleeDamage = event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getDamageSource().getDamageType().getTranslationKey().equals("player");
        if (event instanceof EntityDamageByEntityEvent && !((attackEvent = (EntityDamageByEntityEvent)event).getEntity() instanceof ArmorStand) && isMeleeDamage) {
            Player attackerPlayer;
            Player attackerPlayer2;
            event.setCancelled(true);
            Entity attacker = attackEvent.getDamager();
            boolean hasQuad = attacker instanceof Player && Powerup.hasPowerup(attackerPlayer2 = (Player)attacker, PowerupType.QUAD_DAMAGE);
            int amount = hasQuad ? 30 : 10;
            WeaponUtil.damageCustom((LivingEntity)attackEvent.getEntity(), amount, attacker, DamageCause.GAUNTLET);
            attacker.getWorld().playSound(attacker, "quake.weapons.gauntlet", 1.0f, 1.0f);
            if (attacker instanceof Player && Powerup.hasPowerup(attackerPlayer = (Player)attacker, PowerupType.QUAD_DAMAGE)) {
                attacker.getWorld().playSound(attacker, "quake.items.powerups.quad_damage.fire", 0.5f, 1.0f);
            }
            return;
        }
        QuakeUserState userState = null;
        Entity hasQuad = event.getEntity();
        if (hasQuad instanceof Player) {
            player = (Player)hasQuad;
            userState = QuakePlugin.INSTANCE.userStates.get(player);
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
            return;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent attackEvent2 = (EntityDamageByEntityEvent)event;
            Entity amount = event.getEntity();
            if (amount instanceof LivingEntity) {
                Player pAttacker;
                victim = (LivingEntity)amount;
                Entity attacker = attackEvent2.getDamager();
                if (attacker instanceof Player && Powerup.hasPowerup(pAttacker = (Player)attacker, PowerupType.QUAD_DAMAGE)) {
                    event.setDamage(event.getDamage() * 3.0);
                }
                if (event.getEntity() != attackEvent2.getDamager()) {
                    float health = (float)(victim.getHealth() - event.getDamage());
                    attacker.playSound(Sound.sound((Key)Key.key((String)"quake.feedback.hit"), (Sound.Source)Sound.Source.NEUTRAL, (float)1.0f, (float)((float)Math.round((1.0f + health / 66.0f) * 6.0f) / 6.0f)));
                }
            }
        }
        if ((victim = event.getEntity()) instanceof Player && Powerup.hasPowerup(player = (Player)victim, PowerupType.PROTECTION)) {
            assert (userState != null);
            DamageData damageData = userState.lastDamage;
            if (event.getCause() == EntityDamageEvent.DamageCause.LAVA || event.getCause() == EntityDamageEvent.DamageCause.DROWNING || damageData != null && (damageData.getCause() == DamageCause.ROCKET_SPLASH || damageData.getCause() == DamageCause.BFG_SPLASH || damageData.getCause() == DamageCause.PLASMA_SPLASH)) {
                player.playSound((Entity)player, "quake.items.powerups.protection.protect", 0.5f, 1.0f);
                event.setCancelled(true);
                return;
            }
            event.setDamage(event.getDamage() / 2.0);
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
            event.setDamage(1000.0);
        }
        if (event.getEntity().getType() != EntityType.PLAYER || event.getEntity().getType() == EntityType.PLAYER && event.getCause() == EntityDamageEvent.DamageCause.FALL && event.getEntity().getFallDistance() < 10.0f) {
            return;
        }
        player = (Player)event.getEntity();
        assert (userState != null);
        event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, 0.0);
        double finalDamage = event.getDamage();
        if (userState.armor > 0) {
            double damageToArmor = (event.getDamage() - (finalDamage /= 3.0)) * 5.0;
            userState.armor -= (int)damageToArmor;
            if (userState.armor < 0) {
                finalDamage += (double)Math.abs(userState.armor) / 5.0;
                userState.armor = 0;
            }
            event.setDamage(finalDamage);
        }
        if ((finalMaxHealth = player.getHealth() - finalDamage) < 20.0) {
            finalMaxHealth = 20.0;
        }
        Objects.requireNonNull(player.getAttribute(Attribute.MAX_HEALTH)).setBaseValue(finalMaxHealth);
        if (player.getHealth() - finalDamage <= 0.0) {
            Entity entity;
            EntityDamageByEntityEvent attackEvent3;
            DamageData lastDamage = userState.lastDamage;
            if (userState.currentMatch != null && lastDamage != null) {
                userState.currentMatch.onDeath(player, lastDamage.getAttacker(), lastDamage.getCause());
            } else if (userState.currentMatch != null && event instanceof EntityDamageByEntityEvent) {
                attackEvent3 = (EntityDamageByEntityEvent)event;
                userState.currentMatch.onDeath(player, attackEvent3.getDamager(), DamageCause.UNKNOWN);
            } else if (userState.currentMatch != null) {
                DamageCause qCause = switch (event.getCause()) {
                    case EntityDamageEvent.DamageCause.FALL -> DamageCause.FALLING;
                    case EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.VOID -> DamageCause.TRIGGER_HURT;
                    case EntityDamageEvent.DamageCause.MELTING, EntityDamageEvent.DamageCause.LAVA, EntityDamageEvent.DamageCause.HOT_FLOOR -> DamageCause.LAVA;
                    case EntityDamageEvent.DamageCause.DROWNING -> DamageCause.WATER;
                    case EntityDamageEvent.DamageCause.SUICIDE -> DamageCause.SUICIDE;
                    case EntityDamageEvent.DamageCause.FALLING_BLOCK, EntityDamageEvent.DamageCause.CRAMMING, EntityDamageEvent.DamageCause.FLY_INTO_WALL -> DamageCause.CRUSH;
                    default -> DamageCause.UNKNOWN;
                };
                userState.currentMatch.onDeath(player, null, qCause);
            }
            if (event instanceof EntityDamageByEntityEvent && (entity = (attackEvent3 = (EntityDamageByEntityEvent)event).getDamager()) instanceof Player) {
                Player attacker = (Player)entity;
                QuakeUserState attackerState = QuakePlugin.INSTANCE.userStates.get(attacker);
                if (userState.lastDamage.getCause() == DamageCause.GAUNTLET) {
                    attackerState.awardMedal(MedalType.HUMILIATION);
                }
            }
        }
        userState.lastDamage = null;
    }

    @EventHandler
    public void onArmorChange(PlayerArmorChangeEvent event) {
        if (Stream.of(Material.LEATHER_BOOTS, Material.LEATHER_LEGGINGS, Material.LEATHER_CHESTPLATE).allMatch(material -> event.getOldItem().getType() != material)) {
            return;
        }
        Damageable oldMeta = (Damageable)event.getOldItem().getItemMeta();
        Damageable newMeta = (Damageable)event.getNewItem().getItemMeta();
        if (newMeta == null) {
            return;
        }
        if (oldMeta.getDamage() >= newMeta.getDamage()) {
            return;
        }
        newMeta.setDamage(oldMeta.getDamage());
        ItemStack newItem = event.getNewItem();
        newItem.setItemMeta((ItemMeta)newMeta);
        switch (event.getSlotType()) {
            case HEAD: {
                event.getPlayer().getInventory().setHelmet(newItem);
                break;
            }
            case CHEST: {
                event.getPlayer().getInventory().setChestplate(newItem);
                break;
            }
            case LEGS: {
                event.getPlayer().getInventory().setLeggings(newItem);
                break;
            }
            case FEET: {
                event.getPlayer().getInventory().setBoots(newItem);
            }
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onRegen(EntityRegainHealthEvent event) {
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        QuakeUserState state = QuakePlugin.INSTANCE.userStates.get((Player)event.getEntity());
        state.startHealthDecreaser();
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        if (userState.currentMatch == null) {
            event.setRespawnLocation(QuakePlugin.LOBBY);
            return;
        }
        Location spawnPoint = userState.prepareRespawn();
        event.setRespawnLocation(spawnPoint);
        MiscUtil.teleEffect(spawnPoint, false);
        if (userState.currentMatch.isTeamMatch()) {
            Match.setArmor(player, userState.currentMatch.getTeamOfPlayer(player));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getPlayer();
        ItemStack handItem = player.getInventory().getItemInMainHand().clone();
        ItemMeta itemMeta = handItem.getItemMeta();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        userState.armor = 0;
        if (itemMeta != null && itemMeta.hasCustomModelData() && handItem.getType() == Material.CARROT_ON_A_STICK) {
            int modelData = itemMeta.getCustomModelData();
            WeaponUserState weaponState = userState.weaponState;
            PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
            pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "ammo"), PersistentDataType.INTEGER, (Object)weaponState.ammo[modelData]);
            handItem.setItemMeta(itemMeta);
        }
        Powerup.dropPowerups(player);
        List drops = e.getDrops();
        drops.clear();
        Item worldItem = player.getWorld().dropItem(player.getLocation(), handItem);
        worldItem.setPickupDelay(5);
        if (userState.currentMatch != null) {
            e.deathMessage((Component)Component.empty());
        }
    }

    public static void sortGun(ItemStack gunItem, Player player) {
        int modelData = gunItem.getItemMeta().getCustomModelData();
        PlayerInventory inv = player.getInventory();
        WeaponUserState weaponState = QuakePlugin.INSTANCE.userStates.get((Object)player).weaponState;
        Optional<ItemStack> foundGun = Arrays.stream(inv.getContents()).filter(Objects::nonNull).filter(invItem -> invItem.getItemMeta().hasCustomModelData() && invItem.getItemMeta().getCustomModelData() == modelData).findAny();
        PersistentDataContainer pdc = gunItem.getItemMeta().getPersistentDataContainer();
        Integer ammo = (Integer)pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "ammo"), PersistentDataType.INTEGER);
        if (foundGun.isPresent()) {
            if (ammo != null) {
                int n = modelData;
                weaponState.ammo[n] = weaponState.ammo[n] + ammo;
            } else if (weaponState.ammo[modelData] < WeaponUtil.DEFAULT_AMMO[modelData]) {
                weaponState.ammo[modelData] = WeaponUtil.DEFAULT_AMMO[modelData];
            } else {
                int n = modelData;
                weaponState.ammo[n] = weaponState.ammo[n] + 1;
            }
        } else {
            if (ammo != null && ammo > WeaponUtil.DEFAULT_AMMO[modelData]) {
                int n = modelData;
                weaponState.ammo[n] = weaponState.ammo[n] + ammo;
            } else if (weaponState.ammo[modelData] < WeaponUtil.DEFAULT_AMMO[modelData]) {
                weaponState.ammo[modelData] = WeaponUtil.DEFAULT_AMMO[modelData];
            } else {
                int n = modelData;
                weaponState.ammo[n] = weaponState.ammo[n] + 1;
            }
            inv.setItem(modelData, gunItem);
            inv.setHeldItemSlot(modelData);
        }
        if (weaponState.ammo[modelData] > 200) {
            weaponState.ammo[modelData] = 200;
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        LivingEntity entity = event.getEntity();
        if (!item.getItemMeta().hasCustomModelData() || item.getType() != Material.CARROT_ON_A_STICK || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CombatListener.sortGun(item, player);
        event.getItem().remove();
        player.playSound((Entity)entity, "quake.weapons.pickup", 0.5f, 1.0f);
        Hud.pickupMessage(player, item.getItemMeta().displayName());
        event.setCancelled(true);
    }

    @EventHandler
    public void onHandSwap(PlayerSwapHandItemsEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        player.sendMessage(TranslationManager.t("error.offhand", player, new TagResolver[0]));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getSlot() != 40) {
            return;
        }
        Player player = (Player)event.getView().getPlayer();
        event.getView().getPlayer().sendMessage(TranslationManager.t("error.offhand", player, new TagResolver[0]));
        ItemStack cursorItem = event.getCursor().clone();
        event.setCancelled(true);
        event.getView().getPlayer().getInventory().addItem(new ItemStack[]{cursorItem});
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent event) {
        boolean sprinting = event.isSprinting();
        Player player = event.getPlayer();
        player.setWalkSpeed(sprinting ? QuakePlugin.INSTANCE.config.player.walkSpeed / 1.3f : QuakePlugin.INSTANCE.config.player.walkSpeed);
    }
}

