/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.events.listeners;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.misc.Chatroom;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ChatListener
implements Listener {
    @EventHandler
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        String messageText = PlainTextComponentSerializer.plainText().serialize(event.message());
        Chatroom targetChatroom = userState.currentChat;
        String processedMessage = messageText;
        if (!messageText.isEmpty()) {
            char firstChar = messageText.charAt(0);
            if (messageText.length() > 1 && messageText.charAt(1) == firstChar) {
                if (firstChar == '@' || firstChar == '#' || firstChar == '$') {
                    processedMessage = messageText.substring(1);
                }
            } else if (firstChar == '@') {
                targetChatroom = Chatroom.TEAM;
                processedMessage = messageText.substring(1);
            } else if (firstChar == '#') {
                targetChatroom = Chatroom.MATCH;
                processedMessage = messageText.substring(1);
            } else if (firstChar == '$') {
                targetChatroom = Chatroom.GLOBAL;
                processedMessage = messageText.substring(1);
            }
        }
        if (userState.currentMatch == null && (targetChatroom == Chatroom.MATCH || targetChatroom == Chatroom.TEAM)) {
            player.sendMessage(TranslationManager.t("error.chat.switchNoMatch.title", player, new TagResolver[]{Placeholder.component((String)"chatroom", (ComponentLike)TranslationManager.t("error.chat.switchNoMatch." + targetChatroom.name().toLowerCase() + "Adj", player, new TagResolver[0]).color(TextColor.color((int)targetChatroom.getColor())))}));
            event.setCancelled(true);
            return;
        }
        if (userState.currentMatch != null && userState.currentMatch.allowedTeams().stream().allMatch(team -> team == Team.FREE) && targetChatroom == Chatroom.TEAM) {
            player.sendMessage(TranslationManager.t("error.match.notTeam", player, new TagResolver[0]));
            event.setCancelled(true);
            return;
        }
        event.message((Component)Component.text((String)processedMessage));
        switch (targetChatroom) {
            case GLOBAL: {
                this.chatGlobal(event);
                break;
            }
            case MATCH: {
                this.chatMatch(event);
                break;
            }
            case TEAM: {
                this.chatTeam(event);
            }
        }
    }

    public void chatGlobal(AsyncChatEvent event) {
        event.renderer((source, sourceDisplayName, message, viewer) -> {
            Player viewerPlayer = viewer instanceof Player ? (Player)viewer : event.getPlayer();
            return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Chatroom.GLOBAL.getPrefix(viewerPlayer.locale()), MiniMessage.miniMessage().deserialize(" <b><color:#7f7f7f><source_display_name></color></b> <message>", new TagResolver[]{Placeholder.component((String)"source_display_name", (ComponentLike)sourceDisplayName), Placeholder.component((String)"message", (ComponentLike)message)})});
        });
    }

    public void chatMatch(AsyncChatEvent event) {
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(event.getPlayer());
        event.viewers().clear();
        event.viewers().add(Audience.audience((Audience[])new Audience[]{userState.currentMatch}));
        event.renderer((source, sourceDisplayName, message, viewer) -> {
            Player viewerPlayer = viewer instanceof Player ? (Player)viewer : event.getPlayer();
            return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Chatroom.MATCH.getPrefix(viewerPlayer.locale()), MiniMessage.miniMessage().deserialize(" <b><color:#7f7f7f><source_display_name></color></b> <message>", new TagResolver[]{Placeholder.component((String)"source_display_name", (ComponentLike)sourceDisplayName), Placeholder.component((String)"message", (ComponentLike)message)})});
        });
    }

    public void chatTeam(AsyncChatEvent event) {
        Player player = event.getPlayer();
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        event.viewers().clear();
        event.viewers().add(Audience.audience((Audience[])new Audience[]{userState.currentMatch.getTeamAudience(userState.currentMatch.getTeamOfPlayer(player))}));
        event.renderer((source, sourceDisplayName, message, viewer) -> {
            Player viewerPlayer = viewer instanceof Player ? (Player)viewer : event.getPlayer();
            return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Chatroom.TEAM.getPrefix(viewerPlayer.locale()), MiniMessage.miniMessage().deserialize(" <b><color:#7f7f7f><source_display_name></color></b> <message>", new TagResolver[]{Placeholder.component((String)"source_display_name", (ComponentLike)sourceDisplayName), Placeholder.component((String)"message", (ComponentLike)message)})});
        });
    }
}

