/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.commands;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.events.listeners.MapperToolListener;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.pickups.AmmoSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.ArmorSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.CTFFlag;
import com.github.polyzium.quakechasm.game.entities.pickups.HealthSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.PowerupSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.WeaponSpawner;
import com.github.polyzium.quakechasm.game.entities.triggers.Jumppad;
import com.github.polyzium.quakechasm.game.entities.triggers.Portal;
import com.github.polyzium.quakechasm.game.mapper.PortalTool;
import com.github.polyzium.quakechasm.game.mapper.SpawnerTool;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.factory.CTFMatchFactory;
import com.github.polyzium.quakechasm.matchmaking.factory.DebugMatchFactory;
import com.github.polyzium.quakechasm.matchmaking.factory.FFAMatchFactory;
import com.github.polyzium.quakechasm.matchmaking.factory.MatchFactory;
import com.github.polyzium.quakechasm.matchmaking.factory.TDMMatchFactory;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.map.Spawnpoint;
import com.github.polyzium.quakechasm.matchmaking.matches.FFAMatch;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchManager;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchMode;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchPrivacy;
import com.github.polyzium.quakechasm.misc.Chatroom;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.ListArgument;
import dev.jorel.commandapi.arguments.ListArgumentBuilder;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public abstract class Commands {
    public static Component getDeprecationMessage() {
        return MiniMessage.miniMessage().deserialize((Object)"<red>This command is deprecated in favor of the <underlined><blue><click:run_command:/quake map toolkit><hover:show_text:'Click to get the toolkit'>Mapper Toolkit.</hover></click></blue></underlined>");
    }

    public static void initQuakeCommand() {
        CommandAPICommand jumppadCmd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("jumppad").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("power")})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, Math.floor(loc.y()), Math.floor(loc.z()) + 0.5);
            new Jumppad(loc, player.getEyeLocation().getDirection().multiply(((Double)args.get("power")).doubleValue()));
            player.sendMessage(TranslationManager.t("command.entity.jumppad.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("visualize").executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Entity nearestJumppad = QEntityUtil.nearestEntity(player.getLocation(), 3.0, entity -> entity.getType() == EntityType.MARKER && QEntityUtil.getEntityType(entity).equals("jumppad"));
            if (nearestJumppad == null) {
                player.sendMessage(TranslationManager.t("error.entity.jumppad.noNearby", player, new TagResolver[0]));
                return;
            }
            for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
                if (!(trigger instanceof Jumppad)) continue;
                Jumppad jumppad = (Jumppad)trigger;
                if (trigger.getEntity() != nearestJumppad) continue;
                ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(trigger.getLocation(), jumppad.getLaunchVec());
                Location prevLoc = null;
                for (int trajectoryIndex = 0; trajectoryIndex < trajectory.size(); ++trajectoryIndex) {
                    Vector vector = trajectory.get(trajectoryIndex);
                    World world = trigger.getLocation().getWorld();
                    Location loc = vector.toLocation(world);
                    if (prevLoc == null) {
                        world.spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, Color.fromRGB((int)30719), 60));
                    } else {
                        int finalTrajectoryIndex = trajectoryIndex;
                        WeaponUtil.spawnParticlesLine(prevLoc, loc, 8.0, particleLocation -> loc.getWorld().spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(particleLocation, Color.fromRGB((int)30719), 40 + finalTrajectoryIndex), true));
                    }
                    prevLoc = loc;
                }
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("try").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("power")})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            double power = (Double)args.get("power");
            Location jpLoc = player.getLocation();
            Vector launchVector = player.getEyeLocation().getDirection().multiply(power);
            ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(jpLoc, launchVector);
            Location prevLoc = null;
            for (int trajectoryIndex = 0; trajectoryIndex < trajectory.size(); ++trajectoryIndex) {
                Vector vector = trajectory.get(trajectoryIndex);
                World world = player.getLocation().getWorld();
                Location loc = vector.toLocation(world);
                if (prevLoc == null) {
                    world.spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, Color.fromRGB((int)65280), 60));
                } else {
                    int finalTrajectoryIndex = trajectoryIndex;
                    WeaponUtil.spawnParticlesLine(prevLoc, loc, 8.0, particleLocation -> loc.getWorld().spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(particleLocation, Color.fromRGB((int)30719), 40 + finalTrajectoryIndex), true));
                }
                prevLoc = loc;
            }
            Vector landPos = trajectory.get(trajectory.size() - 1).clone();
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("Landing position is <click:run_command:/teleport %f %f %f><hover:show_text:'Click to teleport'><green>%.2f %.2f %.2f</green>", landPos.getX(), landPos.getY() + 1.0, landPos.getZ(), landPos.getX(), landPos.getY(), landPos.getZ())).appendNewline().append(MiniMessage.miniMessage().deserialize((Object)String.format("<click:run_command:/quake entity jumppad fromTry %d %d %d %f %f %f><hover:show_text:'Click here to create a jumppad based on the results.'><green>[Create]</green>", jpLoc.getBlockX(), jpLoc.getBlockY(), jpLoc.getBlockZ(), launchVector.getX(), launchVector.getY(), launchVector.getZ()))));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("fromTry").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("jpLocation"), new LocationArgument("launchVector")})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Location jpLocation = (Location)args.get("jpLocation");
            Vector launchVector = ((Location)args.get("launchVector")).toVector().clone();
            jpLocation.set(Math.floor(jpLocation.x()) + 0.5, Math.floor(jpLocation.y()), Math.floor(jpLocation.z()) + 0.5);
            new Jumppad(jpLocation, launchVector);
            player.sendMessage(TranslationManager.t("command.entity.jumppad.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", jpLocation.x(), jpLocation.y(), jpLocation.z()))}));
        })));
        CommandAPICommand portalCmd = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("portal").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
            if (state.portalLoc == null) {
                state.portalLoc = player.getLocation();
                player.sendMessage(TranslationManager.t("command.entity.portal.createInitiated", player, new TagResolver[0]));
                return;
            }
            Location ploc = player.getLocation();
            new Portal(state.portalLoc, ploc);
            player.sendMessage(TranslationManager.t("command.entity.portal.created", player, new TagResolver[]{Placeholder.unparsed((String)"location1", (String)String.format("%.1f %.1f %.1f", state.portalLoc.x(), state.portalLoc.y(), state.portalLoc.z())), Placeholder.unparsed((String)"location2", (String)String.format("%.1f %.1f %.1f", ploc.x(), ploc.y(), ploc.z()))}));
            state.portalLoc = null;
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("cancel").executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            QuakeUserState state = QuakePlugin.INSTANCE.userStates.get(player);
            if (state.portalLoc == null) {
                player.sendMessage(TranslationManager.t("command.generic.cancelledAlready", player, new TagResolver[0]));
                return;
            }
            state.portalLoc = null;
            player.sendMessage(TranslationManager.t("command.entity.portal.createCanceled", player, new TagResolver[0]));
        })));
        CommandAPICommand healthSpawnerCmd = (CommandAPICommand)new CommandAPICommand("healthspawner").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("type").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"small", "medium", "large", "mega"}))})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, loc.y() + 1.0, Math.floor(loc.z()) + 0.5);
            int health = 0;
            switch ((String)args.get("type")) {
                case "small": {
                    health = 1;
                    break;
                }
                case "medium": {
                    health = 5;
                    break;
                }
                case "large": {
                    health = 10;
                    break;
                }
                case "mega": {
                    health = 20;
                    break;
                }
                default: {
                    player.sendMessage(TranslationManager.t("error.healthSpawner.wrongType", player, new TagResolver[0]));
                    return;
                }
            }
            new HealthSpawner(health, player.getWorld(), loc);
            player.sendMessage(TranslationManager.t("command.entity.healthSpawner.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand ammoSpawnerCmd = (CommandAPICommand)new CommandAPICommand("ammospawner").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("ammo_type").includeSuggestions(ArgumentSuggestions.strings((String[])AmmoSpawner.ALIASES))})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, loc.y() + 1.0, Math.floor(loc.z()) + 0.5);
            int ammoType = Arrays.asList(AmmoSpawner.ALIASES).indexOf(args.get("ammo_type"));
            if (ammoType >= WeaponUtil.WEAPONS_NUM) {
                player.sendMessage(TranslationManager.t("command.ammoSpawner.wrongType", player, new TagResolver[]{Placeholder.unparsed((String)"types", (String)String.join((CharSequence)",", AmmoSpawner.ALIASES))}));
                return;
            }
            new AmmoSpawner(ammoType, player.getWorld(), loc);
            player.sendMessage(TranslationManager.t("command.entity.ammoSpawner.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand armorSpawnerCmd = (CommandAPICommand)new CommandAPICommand("armorspawner").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("type").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"shard", "light", "heavy"}))})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, loc.y() + 1.0, Math.floor(loc.z()) + 0.5);
            int armor = 0;
            switch ((String)args.get("type")) {
                case "shard": {
                    armor = 5;
                    break;
                }
                case "light": {
                    armor = 50;
                    break;
                }
                case "heavy": {
                    armor = 100;
                    break;
                }
                default: {
                    player.sendMessage(TranslationManager.t("error.armorSpawner.wrongType", player, new TagResolver[0]));
                    return;
                }
            }
            new ArmorSpawner(armor, player.getWorld(), loc);
            player.sendMessage(TranslationManager.t("command.entity.armorSpawner.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand powerupSpawnerCmd = (CommandAPICommand)new CommandAPICommand("powerupspawner").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("type").includeSuggestions(ArgumentSuggestions.strings((String[])MiscUtil.getEnumNamesLowercase(PowerupType.class)))})).executesPlayer((player, args) -> {
            PowerupType type;
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, loc.y() + 1.0, Math.floor(loc.z()) + 0.5);
            try {
                type = PowerupType.valueOf(((String)args.get("type")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(TranslationManager.t("error.powerupSpawner.wrongType", player, new TagResolver[]{Placeholder.unparsed((String)"types", (String)Strings.join((String[])MiscUtil.getEnumNamesLowercase(PowerupType.class), (String)", "))}));
                return;
            }
            new PowerupSpawner(type, player.getWorld(), loc, false, 30);
            player.sendMessage(TranslationManager.t("command.entity.powerupSpawner.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand ctfFlagCmd = (CommandAPICommand)new CommandAPICommand("ctfflag").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("team").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"red", "blue"}))})).executesPlayer((player, args) -> {
            Team team;
            player.sendMessage(Commands.getDeprecationMessage());
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, loc.y() + 1.0, Math.floor(loc.z()) + 0.5);
            try {
                team = Team.valueOf(((String)args.get("team")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(TranslationManager.t("error.ctfFlag.wrongTeam", player, new TagResolver[0]));
                return;
            }
            new CTFFlag(team, false, null, loc);
            player.sendMessage(TranslationManager.t("command.entity.ctfFlag.created", player, new TagResolver[]{Placeholder.unparsed((String)"team", (String)team.name()), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand weaponSpawnerCmd = (CommandAPICommand)new CommandAPICommand("weaponspawner").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("weapon").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"machinegun", "shotgun", "rocket_launcher", "lightning_gun", "railgun", "plasma_gun", "bfg"}))})).executesPlayer((player, args) -> {
            player.sendMessage(Commands.getDeprecationMessage());
            int weaponIndex = switch ((String)args.get("weapon")) {
                case "machinegun" -> 0;
                case "shotgun" -> 1;
                case "rocket_launcher" -> 2;
                case "lightning_gun" -> 3;
                case "railgun" -> 4;
                case "plasma_gun" -> 5;
                case "bfg" -> 6;
                default -> throw new IllegalStateException("Weapon out of range");
            };
            Location loc = player.getLocation();
            loc.set(Math.floor(loc.x()) + 0.5, Math.floor(loc.y()) + 1.0, Math.floor(loc.z()) + 0.5);
            new WeaponSpawner(weaponIndex, player.getWorld(), loc);
            player.sendMessage(TranslationManager.t("command.entity.weaponSpawner.created", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}));
        })));
        CommandAPICommand reloadCmd = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reload").withPermission("quake.admin")).executes((sender, args) -> QuakePlugin.INSTANCE.reload(), new ExecutorType[0]);
        CommandAPICommand giveCmd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("give").withPermission("quake.admin")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("what").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"ammo", "quad", "protection", "regeneration"}))})).executesPlayer((player, args) -> {
            String giveWhat = (String)args.get("what");
            assert (giveWhat != null);
            switch (giveWhat) {
                case "ammo": {
                    int[] ammo = QuakePlugin.INSTANCE.userStates.get((Object)player).weaponState.ammo;
                    for (int i = 0; i < WeaponUtil.WEAPONS_NUM; ++i) {
                        ammo[i] = 999;
                    }
                    break;
                }
                case "quad": {
                    PowerupSpawner.doPowerup(player, PowerupType.QUAD_DAMAGE, 30);
                    break;
                }
                case "protection": {
                    PowerupSpawner.doPowerup(player, PowerupType.PROTECTION, 30);
                    break;
                }
                case "regeneration": {
                    PowerupSpawner.doPowerup(player, PowerupType.REGENERATION, 30);
                    break;
                }
                default: {
                    player.sendMessage(TranslationManager.t("error.give.invalidOption", player, new TagResolver[]{Placeholder.unparsed((String)"option", (String)giveWhat)}));
                }
            }
        });
        ListArgument recommendedModesArg = new ListArgumentBuilder("recommendedModes").withList(List.of(MatchMode.values())).withMapper(mode -> mode.name().toLowerCase()).buildGreedy();
        CommandAPICommand mapCmd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("map").withPermission("quake.mapper")).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withArguments((AbstractArgument[])new Argument[]{new StringArgument("name"), new TextArgument("displayName"), new IntegerArgument("neededPlayers"), recommendedModesArg})).executesPlayer((player, args) -> {
            BoundingBox bukkitSelection;
            World world = player.getWorld();
            try {
                WorldEditPlugin worldEditPlugin = (WorldEditPlugin)Bukkit.getPluginManager().getPlugin("WorldEdit");
                if (worldEditPlugin == null) {
                    player.sendMessage(TranslationManager.t("error.worldEdit", player, new TagResolver[0]));
                    return;
                }
                Region selection = worldEditPlugin.getSession(player).getSelection(BukkitAdapter.adapt((World)world));
                BlockVector3 pos1 = selection.getBoundingBox().getPos1();
                BlockVector3 pos2 = selection.getBoundingBox().getPos2();
                Location bukkitPos1 = BukkitAdapter.adapt((World)world, (BlockVector3)pos1);
                Location bukkitPos2 = BukkitAdapter.adapt((World)world, (BlockVector3)pos2);
                bukkitSelection = BoundingBox.of((Location)bukkitPos1, (Location)bukkitPos2);
            }
            catch (IncompleteRegionException e) {
                player.sendMessage(TranslationManager.t("error.map.regionNotSelected", player, new TagResolver[0]));
                return;
            }
            ArrayList<Spawnpoint> spawnPoints = QuakePlugin.scanSpawnpointsIn(player.getWorld(), bukkitSelection);
            List recommendedModes = (List)args.get("recommendedModes");
            String name = (String)args.get("name");
            String displayName = (String)args.get("displayName");
            Integer neededPlayers = (Integer)args.get("neededPlayers");
            assert (recommendedModes != null);
            assert (neededPlayers != null);
            QMap qMap = new QMap(name, displayName, world, bukkitSelection, new ArrayList<Spawnpoint>(spawnPoints), new ArrayList<MatchMode>(recommendedModes), neededPlayers);
            if (QuakePlugin.INSTANCE.maps == null) {
                QuakePlugin.INSTANCE.maps = new ArrayList(8);
            }
            if (QuakePlugin.INSTANCE.getMap(name) != null) {
                player.sendMessage(TranslationManager.t("error.duplicateMap", player, new TagResolver[0]));
                return;
            }
            for (Entity entity : player.getWorld().getNearbyEntities(qMap.bounds)) {
                for (Spawnpoint spawnPoint : spawnPoints) {
                    if (entity.getType() != EntityType.ARMOR_STAND || !entity.getLocation().equals((Object)spawnPoint.pos)) continue;
                    entity.remove();
                }
            }
            QuakePlugin.INSTANCE.maps.add(qMap);
            for (Spawnpoint spawnPoint : spawnPoints) {
                world.spawnParticle(Particle.INSTANT_EFFECT, spawnPoint.pos, 64, 0.5, 0.5, 0.5);
                world.setBlockData(spawnPoint.pos, Material.AIR.createBlockData());
            }
            player.sendMessage(TranslationManager.t("command.map.created", player, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)displayName)}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withPermission("quake.admin")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("mapName")})).executesPlayer((player, args) -> {
            String name = (String)args.get("mapName");
            QMap map = QuakePlugin.INSTANCE.getMap(name);
            if (map == null) {
                player.sendMessage(TranslationManager.t("error.noSuchMap", player, new TagResolver[0]));
                return;
            }
            for (Spawnpoint spawnPoint : map.spawnPoints) {
                QuakePlugin.placeSpawnpoint(spawnPoint);
                map.world.spawnParticle(Particle.DUST, spawnPoint.pos, 64, 0.5, 0.5, 0.5, (Object)new Particle.DustOptions(Color.fromRGB((int)0xFF0000), 2.0f));
            }
            QuakePlugin.INSTANCE.maps.remove(map);
            player.sendMessage(TranslationManager.t("command.map.removed", player, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)name)}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").executes((sender, args) -> {
            if (QuakePlugin.INSTANCE.maps.isEmpty()) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    sender.sendMessage(TranslationManager.t("command.map.list.empty", player, new TagResolver[0]));
                } else {
                    sender.sendMessage(TranslationManager.t("command.map.list.empty", TranslationManager.FALLBACK, new TagResolver[0]));
                }
                return;
            }
            for (QMap map : QuakePlugin.INSTANCE.maps) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    sender.sendMessage(TranslationManager.t("command.map.list.entry", player, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)map.name), Placeholder.unparsed((String)"world_name", (String)map.world.getName()), Placeholder.unparsed((String)"location", (String)map.bounds.getMin().toString())}));
                    continue;
                }
                sender.sendMessage(TranslationManager.t("command.map.list.entry", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)map.name), Placeholder.unparsed((String)"world_name", (String)map.world.getName()), Placeholder.unparsed((String)"location", (String)map.bounds.getMin().toString())}));
            }
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("select").withArguments((AbstractArgument[])new Argument[]{new StringArgument("mapName")})).executesPlayer((player, args) -> {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)Bukkit.getPluginManager().getPlugin("WorldEdit");
            if (worldEditPlugin == null) {
                player.sendMessage(TranslationManager.t("error.worldEdit", player, new TagResolver[0]));
                return;
            }
            String name = (String)args.get("mapName");
            QMap map = QuakePlugin.INSTANCE.getMap(name);
            if (map == null) {
                player.sendMessage(TranslationManager.t("error.noSuchMap", player, new TagResolver[0]));
                return;
            }
            player.performCommand(String.format("/pos1 %s,%s,%s", map.bounds.getMin().getBlockX(), map.bounds.getMin().getBlockY(), map.bounds.getMin().getBlockZ()));
            player.performCommand(String.format("/pos2 %s,%s,%s", map.bounds.getMax().getBlockX(), map.bounds.getMax().getBlockY(), map.bounds.getMax().getBlockZ()));
            player.sendMessage(TranslationManager.t("command.map.selectResult", player, new TagResolver[0]));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)new CommandAPICommand("toolkit").executesPlayer((player, args) -> {
            int i;
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createEntityTool()});
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createJumppadTool()});
            player.getInventory().addItem(new ItemStack[]{PortalTool.createPortalTool()});
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createSpawnpointTool(Team.RED)});
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createSpawnpointTool(Team.BLUE)});
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createSpawnpointTool(Team.FREE)});
            player.getInventory().addItem(new ItemStack[]{MapperToolListener.createSpawnpointTool(Team.SPECTATOR)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createRedFlagTool()});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createBlueFlagTool()});
            for (i = 0; i < 7; ++i) {
                player.getInventory().addItem(new ItemStack[]{SpawnerTool.createWeaponSpawnerTool(i)});
            }
            for (i = 0; i < 7; ++i) {
                player.getInventory().addItem(new ItemStack[]{SpawnerTool.createAmmoSpawnerTool(i)});
            }
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createHealthSpawnerTool(1)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createHealthSpawnerTool(5)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createHealthSpawnerTool(10)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createHealthSpawnerTool(20)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createArmorSpawnerTool(5)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createArmorSpawnerTool(50)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createArmorSpawnerTool(100)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createPowerupSpawnerTool(PowerupType.QUAD_DAMAGE)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createPowerupSpawnerTool(PowerupType.REGENERATION)});
            player.getInventory().addItem(new ItemStack[]{SpawnerTool.createPowerupSpawnerTool(PowerupType.PROTECTION)});
            player.sendMessage(TranslationManager.t("command.map.toolkit.added", player, new TagResolver[0]));
        })));
        StringArgument matchModeArg = (StringArgument)new StringArgument("mode").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"debug", "ffa", "tdm", "ctf"}));
        IntegerArgument needPlayersArg = new IntegerArgument("needPlayers");
        CommandAPICommand matchCmd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("match").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("create").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{matchModeArg, needPlayersArg, (Argument)new StringArgument("mapName").includeSuggestions(ArgumentSuggestions.strings(info -> (String[])QuakePlugin.INSTANCE.maps.stream().map(map -> map.name).toArray(String[]::new))), (Argument)((Argument)new StringArgument("privacy").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"public", "password", "invite_only"}))).setOptional(true), (Argument)new StringArgument("password").setOptional(true)})).executesPlayer((player, args) -> {
            MatchFactory matchFactory;
            MatchPrivacy privacy;
            String mode = (String)args.get("mode");
            String mapName = (String)args.get("mapName");
            Integer needPlayers = (Integer)args.get("needPlayers");
            String privacyStr = (String)args.getOrDefault("privacy", () -> "public");
            String password = (String)args.getOrDefault("password", () -> null);
            QMap map = QuakePlugin.INSTANCE.getMap(mapName);
            if (map == null) {
                player.sendMessage(TranslationManager.t("error.noSuchMap", player, new TagResolver[0]));
                return;
            }
            for (Match match : QuakePlugin.INSTANCE.matchManager.matches) {
                if (!match.getMap().name.equals(mapName)) continue;
                player.sendMessage(TranslationManager.t("error.match.mapOccupied", player, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)mapName)}));
                return;
            }
            try {
                privacy = MatchPrivacy.valueOf(privacyStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(TranslationManager.t("match.privacy.invalid", player, new TagResolver[0]));
                return;
            }
            if (privacy == MatchPrivacy.PASSWORD && (password == null || password.isEmpty())) {
                player.sendMessage(TranslationManager.t("match.privacy.passwordRequired", player, new TagResolver[0]));
                return;
            }
            switch (mode) {
                case "debug": {
                    MatchFactory matchFactory2 = new DebugMatchFactory();
                    break;
                }
                case "ffa": {
                    MatchFactory matchFactory2 = new FFAMatchFactory();
                    break;
                }
                case "tdm": {
                    MatchFactory matchFactory2 = new TDMMatchFactory();
                    break;
                }
                case "ctf": {
                    MatchFactory matchFactory2 = new CTFMatchFactory();
                    break;
                }
                default: {
                    MatchFactory matchFactory2 = matchFactory = null;
                }
            }
            if (matchFactory == null) {
                player.sendMessage(TranslationManager.t("error.invalidMode", player, new TagResolver[]{Placeholder.unparsed((String)"mode", (String)mode)}));
                return;
            }
            MatchManager matchManager = QuakePlugin.INSTANCE.matchManager;
            Match match = matchManager.newMatch(matchFactory, map, player.getUniqueId(), privacy, password);
            if (match == null) {
                player.sendMessage(TranslationManager.t("error.generic", player, new TagResolver[0]));
                return;
            }
            match.setNeedPlayers(needPlayers);
            List<Match> visibleMatches = matchManager.getVisibleMatches(player);
            int displayIndex = visibleMatches.indexOf(match);
            player.sendMessage(TranslationManager.t("command.match.created", player.locale(), new TagResolver[]{Placeholder.unparsed((String)"match_type", (String)TranslationManager.tLegacy(matchFactory.getNameKey(), player.locale())), Placeholder.unparsed((String)"index", (String)String.valueOf(displayIndex))}));
            if (privacy == MatchPrivacy.PASSWORD) {
                player.sendMessage(TranslationManager.t("match.privacy.passwordProtected", player, new TagResolver[0]));
            } else if (privacy == MatchPrivacy.INVITE_ONLY) {
                player.sendMessage(TranslationManager.t("match.privacy.inviteOnly", player, new TagResolver[0]));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("join").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("index"), (Argument)new StringArgument("password").setOptional(true)})).executesPlayer((player, args) -> {
            MatchManager matchManager = QuakePlugin.INSTANCE.matchManager;
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch != null) {
                player.sendMessage(TranslationManager.t("error.match.already", player, new TagResolver[0]));
                return;
            }
            int index = (Integer)args.get("index");
            String password = (String)args.getOrDefault("password", () -> null);
            Match match = matchManager.getVisibleMatch(player, index);
            if (match == null) {
                player.sendMessage(TranslationManager.t("error.noSuchMatch", player, new TagResolver[0]));
                return;
            }
            if (!match.canJoin(player, password)) {
                if (match.getPrivacy() == MatchPrivacy.PASSWORD) {
                    player.sendMessage(TranslationManager.t("match.privacy.incorrectPassword", player, new TagResolver[0]));
                } else if (match.getPrivacy() == MatchPrivacy.INVITE_ONLY) {
                    player.sendMessage(TranslationManager.t("match.privacy.inviteRequired", player, new TagResolver[0]));
                } else {
                    player.sendMessage(TranslationManager.t("match.privacy.cannotJoin", player, new TagResolver[0]));
                }
                return;
            }
            match.join(player, null);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("leave").withPermission("quake.player")).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("error.match.notInMatch", player, new TagResolver[0]));
                return;
            }
            userState.currentMatch.leave(player);
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{(Argument)new LiteralArgument("--all").setOptional(true)})).executes((sender, args) -> {
            boolean showAll;
            MatchManager matchManager = QuakePlugin.INSTANCE.matchManager;
            Player player = sender instanceof Player ? (Player)sender : null;
            boolean bl = showAll = args.get("--all") != null && (player == null || player.hasPermission("quake.admin"));
            List<Match> matchesToShow = showAll ? matchManager.matches : (player != null ? matchManager.getVisibleMatches(player) : matchManager.matches.stream().filter(m -> m.getPrivacy() != MatchPrivacy.INVITE_ONLY).toList());
            if (matchesToShow.isEmpty()) {
                if (player != null) {
                    sender.sendMessage(TranslationManager.t("error.noMatches", player, new TagResolver[0]));
                } else {
                    sender.sendMessage(TranslationManager.t("error.noMatches", TranslationManager.FALLBACK, new TagResolver[0]));
                }
                return;
            }
            for (int i = 0; i < matchesToShow.size(); ++i) {
                Match match = matchesToShow.get(i);
                Locale locale = sender instanceof Player ? ((Player)sender).locale() : TranslationManager.FALLBACK;
                Component privacyIcon = switch (match.getPrivacy()) {
                    default -> throw new MatchException(null, null);
                    case MatchPrivacy.PUBLIC -> TranslationManager.t("match.list.privacy.public", locale, new TagResolver[0]);
                    case MatchPrivacy.PASSWORD -> TranslationManager.t("match.list.privacy.password", locale, new TagResolver[0]);
                    case MatchPrivacy.INVITE_ONLY -> TranslationManager.t("match.list.privacy.inviteOnly", locale, new TagResolver[0]);
                };
                Component ownerInfo = match.getOwnerId() != null ? TranslationManager.t("match.list.owner", locale, new TagResolver[]{Placeholder.unparsed((String)"owner_name", (String)Bukkit.getOfflinePlayer((UUID)match.getOwnerId()).getName())}) : TranslationManager.t("match.list.matchmaking", locale, new TagResolver[0]);
                String matchTypeTranslated = TranslationManager.tLegacy(match.getNameKey(), locale);
                Component joinButton = TranslationManager.t("match.list.joinButton", locale, new TagResolver[]{Placeholder.parsed((String)"index", (String)String.valueOf(i))});
                Component matchEntry = TranslationManager.t("match.list.entry", locale, new TagResolver[]{Placeholder.unparsed((String)"index", (String)String.valueOf(i)), Placeholder.component((String)"privacy_icon", (ComponentLike)privacyIcon), Placeholder.unparsed((String)"match_type", (String)matchTypeTranslated), Placeholder.unparsed((String)"map_name", (String)match.getMap().displayName), Placeholder.unparsed((String)"player_count", (String)String.valueOf(match.getPlayers().size())), Placeholder.component((String)"owner_info", (ComponentLike)ownerInfo)}).append(joinButton);
                sender.sendMessage(matchEntry);
            }
        }, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("invite").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player")})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.invitePlayers", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            Player invitee = (Player)args.get("player");
            if (invitee == null) {
                player.sendMessage(TranslationManager.t("match.manage.playerNotFound", player, new TagResolver[0]));
                return;
            }
            if (match.getPlayers().contains(invitee)) {
                player.sendMessage(TranslationManager.t("match.manage.playerAlreadyInMatch", player, new TagResolver[0]));
                return;
            }
            match.invitePlayer(invitee.getUniqueId());
            player.sendMessage(TranslationManager.t("match.manage.invited", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)invitee.getName())}));
            invitee.sendMessage(TranslationManager.t("match.manage.inviteReceived", invitee, new TagResolver[]{Placeholder.unparsed((String)"inviter_name", (String)player.getName())}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("uninvite").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player")})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.uninvitePlayers", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            Player uninvitee = (Player)args.get("player");
            if (uninvitee == null) {
                player.sendMessage(TranslationManager.t("match.manage.playerNotFound", player, new TagResolver[0]));
                return;
            }
            match.uninvitePlayer(uninvitee.getUniqueId());
            player.sendMessage(TranslationManager.t("match.manage.uninvited", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)uninvitee.getName())}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("invites").withPermission("quake.player")).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.viewInvites", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            Set<UUID> invitedPlayers = match.getInvitedPlayers();
            if (invitedPlayers.isEmpty()) {
                player.sendMessage(TranslationManager.t("match.manage.noInvites", player, new TagResolver[0]));
                return;
            }
            player.sendMessage(TranslationManager.t("match.manage.invitesTitle", player, new TagResolver[0]));
            for (UUID uuid : invitedPlayers) {
                String playerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                player.sendMessage(TranslationManager.t("match.manage.inviteEntry", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)playerName)}));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("kick").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("player")})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.kickPlayers", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            Player kickee = (Player)args.get("player");
            if (kickee == null) {
                player.sendMessage(TranslationManager.t("match.manage.playerNotFound", player, new TagResolver[0]));
                return;
            }
            if (!match.getPlayers().contains(kickee)) {
                player.sendMessage(TranslationManager.t("match.manage.playerNotInMatch", player, new TagResolver[0]));
                return;
            }
            if (kickee.equals((Object)player)) {
                player.sendMessage(TranslationManager.t("match.manage.cannotKickSelf", player, new TagResolver[0]));
                return;
            }
            match.leave(kickee);
            player.sendMessage(TranslationManager.t("match.manage.kicked", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)kickee.getName())}));
            kickee.sendMessage(TranslationManager.t("match.manage.kickedBy", kickee, new TagResolver[]{Placeholder.unparsed((String)"kicker_name", (String)player.getName())}));
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("password").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("new_password")})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.changePassword", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            String newPassword = (String)args.get("new_password");
            if (newPassword.equals("--remove")) {
                match.setPassword(null);
                if (match.getPrivacy() == MatchPrivacy.PASSWORD) {
                    match.setPrivacy(MatchPrivacy.PUBLIC);
                }
                player.sendMessage(TranslationManager.t("match.manage.passwordRemoved", player, new TagResolver[0]));
            } else {
                match.setPassword(newPassword);
                match.setPrivacy(MatchPrivacy.PASSWORD);
                player.sendMessage(TranslationManager.t("match.manage.passwordUpdated", player, new TagResolver[0]));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("info").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{(Argument)new IntegerArgument("index").setOptional(true)})).executesPlayer((player, args) -> {
            Match match;
            MatchManager matchManager = QuakePlugin.INSTANCE.matchManager;
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            Integer indexArg = (Integer)args.getOrDefault("index", () -> null);
            if (indexArg == null) {
                if (userState.currentMatch == null) {
                    player.sendMessage(TranslationManager.t("match.info.notInMatchUseIndex", player, new TagResolver[0]));
                    return;
                }
                match = userState.currentMatch;
            } else {
                match = matchManager.getVisibleMatch(player, indexArg);
                if (match == null) {
                    player.sendMessage(TranslationManager.t("error.noSuchMatch", player, new TagResolver[0]));
                    return;
                }
            }
            player.sendMessage(TranslationManager.t("match.info.title", player, new TagResolver[0]));
            String matchTypeTranslated = TranslationManager.tLegacy(match.getNameKey(), player.locale());
            player.sendMessage(TranslationManager.t("match.info.type", player, new TagResolver[]{Placeholder.unparsed((String)"match_type", (String)matchTypeTranslated)}));
            player.sendMessage(TranslationManager.t("match.info.map", player, new TagResolver[]{Placeholder.unparsed((String)"map_name", (String)match.getMap().displayName)}));
            player.sendMessage(TranslationManager.t("match.info.privacy", player, new TagResolver[]{Placeholder.unparsed((String)"privacy", (String)match.getPrivacy().name())}));
            player.sendMessage(TranslationManager.t("match.info.players", player, new TagResolver[]{Placeholder.unparsed((String)"player_count", (String)String.valueOf(match.getPlayers().size()))}));
            if (match.getOwnerId() != null) {
                String ownerName = Bukkit.getOfflinePlayer((UUID)match.getOwnerId()).getName();
                player.sendMessage(TranslationManager.t("match.info.owner", player, new TagResolver[]{Placeholder.unparsed((String)"owner_name", (String)ownerName)}));
            } else {
                player.sendMessage(TranslationManager.t("match.info.matchmaking", player, new TagResolver[0]));
            }
            Map<String, Object> properties = match.getManageableProperties();
            if (!properties.isEmpty()) {
                player.sendMessage(TranslationManager.t("match.info.settingsTitle", player, new TagResolver[0]));
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    player.sendMessage(TranslationManager.t("match.manage.propertyEntry", player, new TagResolver[]{Placeholder.unparsed((String)"property", (String)entry.getKey()), Placeholder.unparsed((String)"value", (String)String.valueOf(entry.getValue()))}));
                }
            }
            if (match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.canManage", player, new TagResolver[0]));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("privacy").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("privacy_level").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"public", "password", "invite_only"}))})).executesPlayer((player, args) -> {
            MatchPrivacy newPrivacy;
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.changePrivacy", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            String privacyStr = (String)args.get("privacy_level");
            try {
                newPrivacy = MatchPrivacy.valueOf(privacyStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(TranslationManager.t("match.privacy.invalid", player, new TagResolver[0]));
                return;
            }
            MatchPrivacy oldPrivacy = match.getPrivacy();
            match.setPrivacy(newPrivacy);
            player.sendMessage(TranslationManager.t("match.privacy.changed", player, new TagResolver[]{Placeholder.unparsed((String)"old_privacy", (String)oldPrivacy.name()), Placeholder.unparsed((String)"new_privacy", (String)newPrivacy.name())}));
            if (newPrivacy == MatchPrivacy.PASSWORD && !match.isPasswordProtected()) {
                player.sendMessage(TranslationManager.t("match.privacy.passwordWarning", player, new TagResolver[0]));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("property").includeSuggestions(ArgumentSuggestions.strings(info -> {
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
                if (userState.currentMatch != null) {
                    return (String[])userState.currentMatch.getManageableProperties().keySet().toArray(String[]::new);
                }
            }
            return new String[]{"fraglimit", "capturelimit", "needPlayers"};
        })), new IntegerArgument("value")})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.setProperties", player))}));
                return;
            }
            Match match = userState.currentMatch;
            if (!match.canManage(player)) {
                player.sendMessage(TranslationManager.t("match.manage.noPermission", player, new TagResolver[0]));
                return;
            }
            String property = (String)args.get("property");
            int value = (Integer)args.get("value");
            try {
                match.setManageableProperty(property, value);
                match.sendMessage(TranslationManager.t("match.manage.propertyChanged", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"property", (String)property), Placeholder.unparsed((String)"value", (String)String.valueOf(value))}));
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("not found or not manageable")) {
                    player.sendMessage(TranslationManager.t("match.manage.propertyNotFound", player, new TagResolver[]{Placeholder.unparsed((String)"property", (String)property)}));
                }
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)("<red>" + e.getMessage() + "</red>")));
            }
        })))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("get").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{(Argument)((Argument)new StringArgument("property").includeSuggestions(ArgumentSuggestions.strings(info -> {
            Object patt0$temp = info.sender();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
                if (userState.currentMatch != null) {
                    return (String[])userState.currentMatch.getManageableProperties().keySet().toArray(String[]::new);
                }
            }
            return new String[]{"fraglimit", "capturelimit", "needPlayers"};
        }))).setOptional(true)})).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            if (userState.currentMatch == null) {
                player.sendMessage(TranslationManager.t("match.manage.notInMatch.title", player, new TagResolver[]{Placeholder.unparsed((String)"action", (String)TranslationManager.tLegacy("match.manage.notInMatch.getProperties", player))}));
                return;
            }
            Match match = userState.currentMatch;
            String property = (String)args.getOrDefault("property", () -> null);
            if (property == null) {
                Map<String, Object> properties = match.getManageableProperties();
                if (properties.isEmpty()) {
                    player.sendMessage(TranslationManager.t("match.manage.noProperties", player, new TagResolver[0]));
                    return;
                }
                player.sendMessage(TranslationManager.t("match.manage.propertiesTitle", player, new TagResolver[0]));
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    player.sendMessage(TranslationManager.t("match.manage.propertyEntry", player, new TagResolver[]{Placeholder.unparsed((String)"property", (String)entry.getKey()), Placeholder.unparsed((String)"value", (String)String.valueOf(entry.getValue()))}));
                }
            } else {
                try {
                    Object value = match.getManageableProperties().get(property);
                    if (value == null) {
                        player.sendMessage(TranslationManager.t("match.manage.propertyNotFound", player, new TagResolver[]{Placeholder.unparsed((String)"property", (String)property)}));
                    }
                    player.sendMessage(TranslationManager.t("match.manage.propertyEntry", player, new TagResolver[]{Placeholder.unparsed((String)"property", (String)property), Placeholder.unparsed((String)"value", (String)String.valueOf(value))}));
                }
                catch (Exception e) {
                    player.sendMessage((Component)Component.text((String)("<red>Error getting property: " + e.getMessage() + "</red>")));
                }
            }
        })));
        CommandAPICommand entityCmd = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("entity").withPermission("quake.mapper")).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{weaponSpawnerCmd, healthSpawnerCmd, ammoSpawnerCmd, armorSpawnerCmd, powerupSpawnerCmd, ctfFlagCmd, jumppadCmd, portalCmd});
        CommandAPICommand chatCmd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("chat").withPermission("quake.player")).withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("chatroom", MiscUtil.getEnumNamesLowercase(Chatroom.class))})).executesPlayer((player, args) -> {
            Chatroom chatroom;
            try {
                chatroom = Chatroom.valueOf(((String)args.get("chatroom")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(TranslationManager.t("error.chatroom.invalid", player, new TagResolver[0]));
                player.sendMessage((Component)Component.text((String)("\u00a7c" + e.getMessage())));
                return;
            }
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            userState.switchChat(chatroom);
        });
        CommandAPICommand test = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withPermission("quake.admin")).executesPlayer((player, args) -> {
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            ((FFAMatch)userState.currentMatch).fraglimit = 200;
        });
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("quake").withAliases(new String[]{"quakechasm"})).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{entityCmd, reloadCmd, giveCmd, mapCmd, matchCmd, chatCmd, test})).register();
    }
}

