/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.combat.DamageData;
import com.github.polyzium.quakechasm.game.combat.MedalType;
import com.github.polyzium.quakechasm.game.combat.WeaponUserState;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.triggers.Jumppad;
import com.github.polyzium.quakechasm.game.mapper.PortalTool;
import com.github.polyzium.quakechasm.hud.Hud;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.misc.Chatroom;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class QuakeUserState {
    private Player player;
    public WeaponUserState weaponState;
    public Location portalLoc = null;
    public BukkitRunnable healthDecreaser;
    public BukkitRunnable armorDecreaser;
    public int armor = 0;
    public ArrayList<Powerup> activePowerups = new ArrayList(3);
    public Hud hud;
    public Match currentMatch;
    public DamageData lastDamage;
    public Chatroom currentChat = Chatroom.GLOBAL;
    public int strafeJumpTicks = 0;
    public HashMap<MedalType, Integer> medals = new HashMap();
    public long lastKillTime = 0L;
    public int consecutiveRailgunHits = 0;
    public boolean lastKillWasMidair = false;
    private MedalType currentlyDisplayedMedal = null;
    private BossBar currentMedalBossbar = null;
    private BukkitRunnable currentMedalTimer = null;
    private Queue<MedalType> medalQueue = new LinkedList<MedalType>();
    public Trigger movingEntity = null;
    public boolean holdingEntityTool = false;
    public Location jumppadPlacementLoc = null;
    public Jumppad editingJumppad = null;
    public boolean settingLandingPos = false;
    public double jumppadPowerMultiplier = 1.0;
    public PortalTool.PortalToolData portalToolData = new PortalTool.PortalToolData();

    public QuakeUserState(Player player) {
        this.player = player;
        this.weaponState = new WeaponUserState();
        this.hud = new Hud(this);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void reset() {
        this.weaponState = new WeaponUserState();
        this.armor = 0;
        for (Powerup activePowerup : this.activePowerups) {
            activePowerup.timer.cancel();
        }
        this.activePowerups.clear();
        this.hud.powerupBoard.update();
        this.player.setHealth(20.0);
        this.player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
        this.player.getInventory().clear();
        this.medals.clear();
        this.lastKillTime = 0L;
        this.consecutiveRailgunHits = 0;
        this.lastKillWasMidair = false;
        if (this.currentMedalBossbar != null) {
            this.player.hideBossBar(this.currentMedalBossbar);
            this.currentMedalBossbar = null;
        }
        if (this.currentMedalTimer != null) {
            this.currentMedalTimer.cancel();
            this.currentMedalTimer = null;
        }
        this.currentlyDisplayedMedal = null;
        this.medalQueue.clear();
    }

    public void initForMatch() {
        this.reset();
        this.initRespawn();
    }

    public void initRespawn() {
        Arrays.fill(this.weaponState.ammo, 0);
        ItemStack machinegun = new ItemStack(Material.CARROT_ON_A_STICK);
        ItemMeta mgMeta = machinegun.getItemMeta();
        mgMeta.setCustomModelData(Integer.valueOf(0));
        mgMeta.displayName(TranslationManager.t("pickup.weapon.machinegun", this.player, new TagResolver[0]).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.byBoolean((boolean)false)));
        machinegun.setItemMeta(mgMeta);
        this.weaponState.ammo[0] = WeaponUtil.DEFAULT_AMMO[0];
        this.player.getInventory().addItem(new ItemStack[]{machinegun});
        this.player.getInventory().setHeldItemSlot(0);
        this.player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(25.0);
        this.player.setHealth(25.0);
        this.startHealthDecreaser();
    }

    public Location prepareRespawn() {
        this.initRespawn();
        return this.currentMatch.getMap().getRandomSpawnpoint(this.currentMatch.getTeamOfPlayer(this.player));
    }

    public void respawn() {
        Location spawnpoint = this.prepareRespawn();
        this.player.teleport(spawnpoint);
        MiscUtil.teleEffect(spawnpoint, false);
        if (this.currentMatch.isTeamMatch()) {
            Match.setArmor(this.player, this.currentMatch.getTeamOfPlayer(this.player));
        }
    }

    public void switchChat(Chatroom chatroom) {
        if (this.currentMatch == null && (chatroom == Chatroom.MATCH || chatroom == Chatroom.TEAM)) {
            this.player.sendMessage(TranslationManager.t("error.chat.switchNoMatch.title", this.player, new TagResolver[]{Placeholder.component((String)"chatroom", (ComponentLike)TranslationManager.t("error.chat.switchNoMatch." + chatroom.name().toLowerCase() + "Adj", this.player, new TagResolver[0]).color(TextColor.color((int)chatroom.getColor())))}));
            return;
        }
        if (this.currentMatch != null && this.currentMatch.allowedTeams().stream().allMatch(team -> team == Team.FREE) && chatroom == Chatroom.TEAM) {
            this.player.sendMessage(TranslationManager.t("error.match.notTeam", this.player, new TagResolver[0]));
            return;
        }
        this.currentChat = chatroom;
        this.player.sendMessage(TranslationManager.t("command.chat.switch.title", this.player, new TagResolver[]{Placeholder.component((String)"chatroom", (ComponentLike)TranslationManager.t("command.chat.switch." + this.currentChat.name().toLowerCase() + "Adj", this.player, new TagResolver[0]).color(TextColor.color((int)this.currentChat.getColor())))}));
    }

    public void startArmorDecreaser() {
        if (this.armorDecreaser != null) {
            return;
        }
        this.armorDecreaser = new BukkitRunnable(){

            public void run() {
                if (QuakeUserState.this.armor <= 100) {
                    this.cancel();
                    QuakeUserState.this.armorDecreaser = null;
                    return;
                }
                --QuakeUserState.this.armor;
            }
        };
        this.armorDecreaser.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 20L, 20L);
    }

    public void startHealthDecreaser() {
        if (this.healthDecreaser != null) {
            return;
        }
        this.healthDecreaser = new BukkitRunnable(){

            public void run() {
                try {
                    if (Powerup.hasPowerup(QuakeUserState.this.player, PowerupType.REGENERATION)) {
                        return;
                    }
                }
                catch (NullPointerException e) {
                    this.cancel();
                }
                double currentHealth = QuakeUserState.this.player.getHealth();
                if (currentHealth <= 20.0) {
                    QuakeUserState.this.player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
                    this.cancel();
                    QuakeUserState.this.healthDecreaser = null;
                    return;
                }
                float newHealth = (float)Math.round(currentHealth * 5.0 - 1.0) / 5.0f;
                QuakeUserState.this.player.setHealth((double)newHealth);
                QuakeUserState.this.player.getAttribute(Attribute.MAX_HEALTH).setBaseValue((double)newHealth);
            }
        };
        this.healthDecreaser.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 20L, 20L);
    }

    public void awardMedal(MedalType medalType) {
        int count = this.medals.getOrDefault((Object)medalType, 0) + 1;
        this.medals.put(medalType, count);
        String medalText = TranslationManager.tLegacy(medalType.getTranslationKey(), this.player) + " x" + count;
        this.player.sendMessage(TranslationManager.t("game.medal.awarded", this.player, new TagResolver[]{Placeholder.unparsed((String)"medal_text", (String)medalText)}).color(TextColor.color((int)16766720)));
        if (this.currentlyDisplayedMedal == medalType) {
            this.updateCurrentMedalDisplay(medalType, count);
            this.resetMedalTimer();
        } else if (this.currentlyDisplayedMedal != null) {
            if (!this.medalQueue.contains((Object)medalType)) {
                this.medalQueue.offer(medalType);
            }
        } else {
            this.showMedalBossbar(medalType, count);
        }
    }

    private void showMedalBossbar(MedalType medalType, int count) {
        this.currentlyDisplayedMedal = medalType;
        Component bossbarTitle = count >= 10 ? Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((char)medalType.getIcon()), Component.text((int)count).color(TextColor.color((int)0xFFFFFF))}).font(Key.key((String)"minecraft:hud_bossbar")) : Component.text((String)Character.toString(medalType.getIcon()).repeat(count)).font(Key.key((String)"minecraft:hud_bossbar"));
        this.currentMedalBossbar = BossBar.bossBar((Component)bossbarTitle, (float)0.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        this.player.showBossBar(this.currentMedalBossbar);
        this.currentMedalTimer = new BukkitRunnable(){

            public void run() {
                QuakeUserState.this.player.hideBossBar(QuakeUserState.this.currentMedalBossbar);
                QuakeUserState.this.currentMedalBossbar = null;
                QuakeUserState.this.currentlyDisplayedMedal = null;
                QuakeUserState.this.currentMedalTimer = null;
                if (!QuakeUserState.this.medalQueue.isEmpty()) {
                    MedalType nextMedal = QuakeUserState.this.medalQueue.poll();
                    int nextCount = QuakeUserState.this.medals.getOrDefault((Object)nextMedal, 0);
                    QuakeUserState.this.showMedalBossbar(nextMedal, nextCount);
                }
            }
        };
        this.currentMedalTimer.runTaskLater((Plugin)QuakePlugin.INSTANCE, 60L);
    }

    private void updateCurrentMedalDisplay(MedalType medalType, int count) {
        if (this.currentMedalBossbar != null) {
            Component bossbarTitle = count >= 10 ? Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((char)medalType.getIcon()), Component.text((int)count).color(TextColor.color((int)0xFFFFFF))}).font(Key.key((String)"minecraft:hud_bossbar")) : Component.text((String)Character.toString(medalType.getIcon()).repeat(count)).font(Key.key((String)"minecraft:hud_bossbar"));
            this.currentMedalBossbar.name(bossbarTitle);
        }
    }

    private void resetMedalTimer() {
        if (this.currentMedalTimer != null) {
            this.currentMedalTimer.cancel();
            this.currentMedalTimer = new BukkitRunnable(){

                public void run() {
                    QuakeUserState.this.player.hideBossBar(QuakeUserState.this.currentMedalBossbar);
                    QuakeUserState.this.currentMedalBossbar = null;
                    QuakeUserState.this.currentlyDisplayedMedal = null;
                    QuakeUserState.this.currentMedalTimer = null;
                    if (!QuakeUserState.this.medalQueue.isEmpty()) {
                        MedalType nextMedal = QuakeUserState.this.medalQueue.poll();
                        int nextCount = QuakeUserState.this.medals.getOrDefault((Object)nextMedal, 0);
                        QuakeUserState.this.showMedalBossbar(nextMedal, nextCount);
                    }
                }
            };
            this.currentMedalTimer.runTaskLater((Plugin)QuakePlugin.INSTANCE, 60L);
        }
    }

    public void checkExcellentMedal() {
        long currentTime = System.currentTimeMillis();
        if (this.lastKillTime != 0L && currentTime - this.lastKillTime <= 2000L) {
            this.awardMedal(MedalType.EXCELLENT);
        }
        this.lastKillTime = currentTime;
    }

    public void checkImpressiveMedal() {
        if (this.consecutiveRailgunHits >= 2) {
            this.awardMedal(MedalType.IMPRESSIVE);
        }
    }
}

