/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm;

import com.github.polyzium.quakechasm.PluginConfig;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.commands.Commands;
import com.github.polyzium.quakechasm.events.listeners.ChatListener;
import com.github.polyzium.quakechasm.events.listeners.CombatListener;
import com.github.polyzium.quakechasm.events.listeners.MapperToolListener;
import com.github.polyzium.quakechasm.events.listeners.MiscListener;
import com.github.polyzium.quakechasm.events.listeners.TriggerListener;
import com.github.polyzium.quakechasm.game.entities.DisplayPickup;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.pickups.AmmoSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.ArmorSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.CTFFlag;
import com.github.polyzium.quakechasm.game.entities.pickups.HealthSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.PowerupSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.game.entities.pickups.WeaponSpawner;
import com.github.polyzium.quakechasm.game.entities.triggers.Jumppad;
import com.github.polyzium.quakechasm.game.entities.triggers.Portal;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.map.Spawnpoint;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchManager;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import com.google.gson.reflect.TypeToken;
import dev.jorel.commandapi.CommandAPI;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;

public class QuakePlugin
extends JavaPlugin {
    public static QuakePlugin INSTANCE;
    public static Location LOBBY;
    public final ArrayList<Trigger> triggers = new ArrayList();
    public Map<Player, QuakeUserState> userStates;
    private float rotatorAngle;
    public ArrayList<QMap> maps;
    public MatchManager matchManager;
    public TranslationManager translationManager;
    public PluginConfig config;

    public void startRotatingPickups() {
        this.rotatorAngle = 0.0f;
        BukkitRunnable rotator = new BukkitRunnable(){

            public void run() {
                QuakePlugin.this.rotatorAngle = (float)((double)QuakePlugin.this.rotatorAngle + 1.5707963267948966);
                for (Trigger trigger : QuakePlugin.this.triggers) {
                    if (!(trigger instanceof DisplayPickup)) continue;
                    ItemDisplay pickupDisplay = ((DisplayPickup)trigger).getDisplay();
                    if (pickupDisplay.isDead() && pickupDisplay.isEmpty()) {
                        QuakePlugin.this.triggers.remove(trigger);
                        return;
                    }
                    pickupDisplay.setInterpolationDelay(-1);
                    pickupDisplay.setTransformationMatrix(new Matrix4f((Matrix4dc)new Matrix4d(Math.cos(QuakePlugin.this.rotatorAngle), 0.0, Math.sin(QuakePlugin.this.rotatorAngle), 0.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(QuakePlugin.this.rotatorAngle), 0.0, Math.cos(QuakePlugin.this.rotatorAngle), 0.0, 0.0, 0.0, 0.0, 1.0)));
                }
            }
        };
        rotator.runTaskTimer((Plugin)this, 0L, 20L);
    }

    public void startHudUpdater() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : QuakePlugin.this.userStates.keySet()) {
                    QuakeUserState userState = QuakePlugin.this.userStates.get(player);
                    userState.hud.draw(userState);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 1L);
    }

    public void loadTrigger(Entity entity) {
        String entityType;
        for (Trigger trigger : this.triggers) {
            if (entity != trigger.getEntity()) continue;
            INSTANCE.getLogger().warning("Attempted to add same trigger twice!");
            return;
        }
        switch (entityType = QEntityUtil.getEntityType(entity)) {
            case "weapon_spawner": {
                new WeaponSpawner((ItemDisplay)entity);
                break;
            }
            case "item_spawner": {
                this.getLogger().warning("ItemSpawner is deprecated, converting to WeaponSpawner");
                WeaponSpawner.convert((ItemDisplay)entity);
                break;
            }
            case "health_spawner": {
                new HealthSpawner((ItemDisplay)entity);
                break;
            }
            case "armor_spawner": {
                new ArmorSpawner((ItemDisplay)entity);
                break;
            }
            case "ammo_spawner": {
                new AmmoSpawner((ItemDisplay)entity);
                break;
            }
            case "powerup_spawner": {
                new PowerupSpawner((ItemDisplay)entity);
                break;
            }
            case "ctf_flag": {
                new CTFFlag((ItemDisplay)entity);
                break;
            }
            case "jumppad": {
                new Jumppad((Marker)entity);
                break;
            }
            case "portal": {
                new Portal((Marker)entity);
                break;
            }
            default: {
                this.getLogger().warning("Unknown entity type " + entityType + ", ignoring.");
            }
        }
    }

    public void loadTriggers() {
        this.triggers.clear();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                String entityType = QEntityUtil.getEntityType(entity);
                if (entityType == null) continue;
                this.loadTrigger(entity);
            }
        }
    }

    public void initPlayer(Player player) {
        player.setWalkSpeed(this.config.player.walkSpeed);
        player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
        this.userStates.put(player, new QuakeUserState(player));
    }

    public void instantiateStates() {
        this.userStates = new HashMap<Player, QuakeUserState>(32);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.initPlayer(player);
        }
    }

    public static ArrayList<Spawnpoint> scanSpawnpointsIn(World world, BoundingBox bounds) {
        ArrayList<Spawnpoint> spawnpoints = new ArrayList<Spawnpoint>();
        for (Entity entity : world.getNearbyEntities(bounds)) {
            Team allowedTeam;
            ArmorStand armorStand;
            EntityEquipment equipment;
            ItemStack chestplate;
            if (!(entity instanceof ArmorStand) || (chestplate = (equipment = (armorStand = (ArmorStand)entity).getEquipment()).getChestplate()).getType() != Material.LEATHER_CHESTPLATE) continue;
            LeatherArmorMeta chestplateMeta = (LeatherArmorMeta)chestplate.getItemMeta();
            switch (chestplateMeta.getColor().asRGB()) {
                case 11546150: {
                    Team team = Team.RED;
                    break;
                }
                case 3949738: {
                    Team team = Team.BLUE;
                    break;
                }
                case 16701501: {
                    Team team = Team.FREE;
                    break;
                }
                case 8991416: {
                    Team team = Team.SPECTATOR;
                    break;
                }
                default: {
                    Team team = allowedTeam = null;
                }
            }
            if (allowedTeam == null) continue;
            spawnpoints.add(new Spawnpoint(armorStand.getLocation(), new ArrayList<Team>(List.of(allowedTeam))));
        }
        return spawnpoints;
    }

    public static void placeSpawnpoint(Spawnpoint spawnpoint) {
        Location location = spawnpoint.pos;
        Team team = spawnpoint.allowedTeams.get(0);
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        armorStand.setGravity(false);
        ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta chestplateMeta = (LeatherArmorMeta)chestplate.getItemMeta();
        int chestplateColor = switch (team) {
            default -> throw new MatchException(null, null);
            case Team.RED -> 11546150;
            case Team.BLUE -> 3949738;
            case Team.FREE -> 16701501;
            case Team.SPECTATOR -> 8991416;
        };
        chestplateMeta.setColor(Color.fromRGB((int)chestplateColor));
        chestplate.setItemMeta((ItemMeta)chestplateMeta);
        EntityEquipment equipment = armorStand.getEquipment();
        equipment.setChestplate(chestplate);
    }

    public QMap getMap(String name) {
        for (QMap map : this.maps) {
            if (!map.name.equals(name)) continue;
            return map;
        }
        return null;
    }

    public void saveMaps() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdir()) {
            this.getLogger().severe("Unable to create data folder " + String.valueOf(dataFolder) + ". Maps won't be saved.");
            return;
        }
        File mapFile = new File(dataFolder, "maps.json");
        try {
            if (!mapFile.exists() && !mapFile.createNewFile()) {
                this.getLogger().severe("Unable to create map file " + String.valueOf(mapFile) + ". Maps won't be saved.");
                return;
            }
        }
        catch (IOException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Unable to create map file " + String.valueOf(mapFile) + ". Maps won't be saved.");
            return;
        }
        String json = MiscUtil.getEnhancedGson().toJson(this.maps);
        try {
            FileWriter writer = new FileWriter(mapFile);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Unable to create map file " + String.valueOf(mapFile) + ". Maps won't be saved.");
            return;
        }
    }

    public void loadMaps() {
        ArrayList maps;
        this.maps = new ArrayList(8);
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists()) {
            this.getLogger().severe("Data folder doesn't exist, maps won't be loaded.");
            return;
        }
        File mapFile = new File(dataFolder, "maps.json");
        if (!mapFile.exists()) {
            this.getLogger().severe("Map file doesn't exist, maps won't be loaded.");
            return;
        }
        try {
            FileReader reader = new FileReader(mapFile);
            maps = (ArrayList)MiscUtil.getEnhancedGson().fromJson((Reader)reader, new TypeToken<ArrayList<QMap>>(this){}.getType());
        }
        catch (IOException e) {
            this.getLogger().severe(e.getMessage());
            this.getLogger().severe("Unable to read map data from " + String.valueOf(mapFile) + ". Maps won't be loaded.");
            return;
        }
        this.maps = maps;
    }

    public void init(boolean isReload) {
        this.getLogger().info("Quakechasm initializing");
        INSTANCE = this;
        this.getLogger().info("Loading configuration");
        try {
            this.config = PluginConfig.load();
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to load configuration: " + e.getMessage());
            throw new RuntimeException(e);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new MiscListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TriggerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MapperToolListener(), (Plugin)this);
        this.getLogger().info("Initializing lobby world");
        World lobbyWorld = new WorldCreator(this.config.lobby.world).createWorld();
        LOBBY = new Location(lobbyWorld, this.config.lobby.x, this.config.lobby.y, this.config.lobby.z, this.config.lobby.yaw, this.config.lobby.pitch);
        this.getLogger().info("Initializing match manager");
        this.matchManager = new MatchManager();
        this.getLogger().info("Initializing translation manager");
        try {
            this.translationManager = new TranslationManager();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLogger().info("Instantiating states for current players");
        this.instantiateStates();
        this.getLogger().info("Loading maps");
        this.loadMaps();
        this.getLogger().info("Loading triggers");
        this.loadTriggers();
        this.startRotatingPickups();
        this.startHudUpdater();
        if (!isReload) {
            Commands.initQuakeCommand();
        }
    }

    public void halt(boolean isReload) {
        this.getLogger().info("Quakechasm is shutting down");
        if (!isReload) {
            CommandAPI.unregister((String)"quake");
        }
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("Respawning all empty spawners");
        for (Trigger trigger : this.triggers) {
            if (!(trigger instanceof Spawner)) continue;
            ((Spawner)trigger).respawn();
        }
        this.getLogger().info("Untracking triggers");
        this.triggers.clear();
        this.getLogger().info("Saving maps");
        if (this.maps != null) {
            this.saveMaps();
            this.maps.clear();
        } else {
            this.getLogger().warning("Maps list is null, skipping save");
        }
        this.getLogger().info("Quakechasm disabled. Goodbye!");
    }

    public void onEnable() {
        this.init(false);
    }

    public void onDisable() {
        this.halt(false);
    }

    public void reload() {
        this.halt(true);
        this.init(true);
        Bukkit.getServer().broadcast(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"[Quakechasm] ").color(TextColor.color((int)0xFF0000)), TranslationManager.t("plugin.reload", TranslationManager.FALLBACK, new TagResolver[0])}));
    }
}

