/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;

public class PluginConfig {
    public static PluginConfig INSTANCE = null;
    @SerializedName(value="locale")
    public LocaleConfig locale = new LocaleConfig();
    @SerializedName(value="lobby")
    public LobbyConfig lobby = new LobbyConfig();
    @SerializedName(value="player")
    public PlayerConfig player = new PlayerConfig();

    public static PluginConfig load() throws IOException {
        File dataFolder = QuakePlugin.INSTANCE.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdir()) {
            QuakePlugin.INSTANCE.getLogger().severe("Unable to create data folder " + String.valueOf(dataFolder));
            throw new IOException("Unable to create data folder");
        }
        File configFile = new File(dataFolder, "config.json");
        if (!configFile.exists()) {
            QuakePlugin.INSTANCE.getLogger().info("Config file not found, copying default from JAR resources");
            try (InputStream defaultConfig = QuakePlugin.INSTANCE.getResource("config.json");){
                if (defaultConfig == null) {
                    QuakePlugin.INSTANCE.getLogger().severe("Default config.json not found in JAR resources");
                    throw new IOException("Default config.json not found in JAR resources");
                }
                Files.copy(defaultConfig, configFile.toPath(), new CopyOption[0]);
                QuakePlugin.INSTANCE.getLogger().info("Default config.json copied to " + configFile.getPath());
            }
        }
        try (FileReader reader = new FileReader(configFile);){
            Gson gson = new Gson();
            PluginConfig config = (PluginConfig)gson.fromJson((Reader)reader, PluginConfig.class);
            if (config.locale == null) {
                config.locale = new LocaleConfig();
            }
            if (config.lobby == null) {
                config.lobby = new LobbyConfig();
            }
            if (config.player == null) {
                config.player = new PlayerConfig();
            }
            INSTANCE = config;
            QuakePlugin.INSTANCE.getLogger().info("Configuration loaded successfully");
            PluginConfig pluginConfig = config;
            return pluginConfig;
        }
    }

    public static class LocaleConfig {
        @SerializedName(value="fallback")
        public String fallback = "en_US";

        public Locale getFallbackLocale() {
            String[] parts = this.fallback.split("_");
            if (parts.length == 2) {
                return new Locale(parts[0], parts[1]);
            }
            return new Locale(parts[0]);
        }
    }

    public static class LobbyConfig {
        @SerializedName(value="world")
        public String world = "world";
        @SerializedName(value="x")
        public double x = 0.0;
        @SerializedName(value="y")
        public double y = 64.0;
        @SerializedName(value="z")
        public double z = 0.0;
        @SerializedName(value="yaw")
        public float yaw = 0.0f;
        @SerializedName(value="pitch")
        public float pitch = 0.0f;
    }

    public static class PlayerConfig {
        @SerializedName(value="walkSpeed")
        public float walkSpeed = 0.4f;
    }
}

