/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.gson.JsonObject;
import me.onlyjordon.swiftdisguise.libs.gson.JsonParser;

public class UUIDFetcher {
    private static final Cache<String, UUID> cache = CacheBuilder.newBuilder().weakKeys().weakValues().build();

    public static CompletableFuture<UUID> fetchUUID(String playerName) {
        UUID id = cache.getIfPresent(playerName.toLowerCase());
        if (id != null) {
            return CompletableFuture.completedFuture(id);
        }
        CompletableFuture<UUID> future = CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                if (connection.getResponseCode() == 400) {
                    return UUID.randomUUID();
                }
                InputStream inputStream = connection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                JsonElement element = new JsonParser().parse(bufferedReader);
                JsonObject object = element.getAsJsonObject();
                String idString = object.get("id").getAsString();
                UUID uuid = UUIDFetcher.stringToUUID(idString);
                cache.put(playerName.toLowerCase(), uuid);
                return uuid;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        return future;
    }

    private static UUID stringToUUID(String uuidAsString) {
        String[] parts = new String[]{"0x" + uuidAsString.substring(0, 8), "0x" + uuidAsString.substring(8, 12), "0x" + uuidAsString.substring(12, 16), "0x" + uuidAsString.substring(16, 20), "0x" + uuidAsString.substring(20, 32)};
        long mostSigBits = Long.decode(parts[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(parts[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(parts[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(parts[2]).longValue(), leastSigBits |= Long.decode(parts[4]).longValue());
    }
}

