/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.nms;

import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.TextureProperty;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.UserProfile;
import me.onlyjordon.swiftdisguise.nms.NMSUtils;
import me.onlyjordon.swiftdisguise.utils.Skin;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CrossVersionPlayerHelper {
    private static final Class<?> craftPlayer;
    private static final Class<?> craftEntity;
    private static final Class<?> craftWorld;
    private static final Class<?> playerClass;
    private static final Class<?> entityClass;
    private static final Class<?> gameProfileClass;
    private static final Field getPing;
    private static final Field gameProfileField;
    private static final Method getPlayerHandle;
    private static final Method getEntityHandle;
    private static final Method getServerHandle;
    private static final Method getWorldHandle;
    private static final Constructor<?> gameProfileConstructor;
    private static final Field propertiesField;
    private static final Class<?> propertyClass;
    private static final Constructor<?> propertyConstcutor;
    private static final Class<?> craftServerClass;
    private static final Class<?> playerListClass;
    private static final Field playersByName;
    private static final Method skinTextureValueMethod;
    private static final Method skinTextureSignatureMethod;
    private static final Class<?> serverPlayerClass;

    public static Class<?> getCraftPlayerClass() {
        return craftPlayer;
    }

    public static int getPing(Player player) {
        try {
            return (Integer)getPing.get(CrossVersionPlayerHelper.getHandle(player));
        }
        catch (IllegalAccessException | NullPointerException e) {
            try {
                return (Integer)player.getClass().getDeclaredMethod("getPing", new Class[0]).invoke((Object)player, new Object[0]);
            }
            catch (Exception e1) {
                throw new RuntimeException("Couldn't get player ping!", e1);
            }
        }
    }

    public static Class<?> getServerPlayerClass() {
        return serverPlayerClass;
    }

    public static Object getHandle(Player player) {
        try {
            return getPlayerHandle.invoke((Object)player, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getHandle(Entity entity) {
        try {
            return getEntityHandle.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getHandle(Server server) {
        try {
            return getServerHandle.invoke((Object)server, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getHandle(World world) {
        try {
            return getWorldHandle.invoke((Object)world, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getCraftWorld() {
        return craftWorld;
    }

    public static Method getWorldHandleMethod() {
        return getWorldHandle;
    }

    public static Skin skinFromBukkitPlayer(Player player) {
        try {
            Object profile = gameProfileField.get(CrossVersionPlayerHelper.getHandle(player));
            Multimap properties = (Multimap)propertiesField.get(profile);
            Collection textures = properties.get("textures");
            if (textures == null || textures.isEmpty()) {
                return null;
            }
            Object texture = textures.iterator().next();
            String value = (String)skinTextureValueMethod.invoke(texture, new Object[0]);
            String signature = (String)skinTextureSignatureMethod.invoke(texture, new Object[0]);
            return new Skin(value, signature);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setGameProfile(Player player, UserProfile profile) {
        try {
            Object serverPlayer = CrossVersionPlayerHelper.getHandle(player);
            Object newGameProfile = gameProfileConstructor.newInstance(profile.getUUID(), profile.getName());
            Multimap propertyMap = (Multimap)propertiesField.get(newGameProfile);
            for (TextureProperty textureProperty : profile.getTextureProperties()) {
                Object property = propertyConstcutor.newInstance("textures", textureProperty.getValue(), textureProperty.getSignature());
                propertyMap.put("textures", property);
            }
            gameProfileField.set(serverPlayer, newGameProfile);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void updateNameOnServer(String name, Player player) {
        try {
            Object server = CrossVersionPlayerHelper.getHandle(player.getServer());
            Map map = (Map)playersByName.get(server);
            map.remove(player.getName().toLowerCase(Locale.ROOT));
            map.put(name.toLowerCase(Locale.ROOT), CrossVersionPlayerHelper.getHandle(player));
            playersByName.set(server, map);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateAllNamesOnServer() {
        try {
            Object server = CrossVersionPlayerHelper.getHandle(Bukkit.getServer());
            Map map = (Map)playersByName.get(server);
            map.clear();
            Bukkit.getOnlinePlayers().forEach(p -> CrossVersionPlayerHelper.updateNameOnServer(p.getName(), p));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void absMoveTo(Entity entity, double x, double y, double z, float yaw, float pitch) {
        Object handle = CrossVersionPlayerHelper.getHandle(entity);
        Method teleport = CrossVersionPlayerHelper.tryMultipleMethods(entityClass, new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE}, "a", "teleport");
        try {
            teleport.invoke(handle, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void absMoveTo(Entity entity, Location loc) {
        CrossVersionPlayerHelper.absMoveTo(entity, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public static int getSkinLayersIndex(ServerVersion version) {
        if (version.isOlderThan(ServerVersion.V_1_9)) {
            return 10;
        }
        if (version.isOlderThan(ServerVersion.V_1_10)) {
            return 12;
        }
        if (version.isOlderThan(ServerVersion.V_1_13)) {
            return 13;
        }
        if (version.isOlderThan(ServerVersion.V_1_15)) {
            return 15;
        }
        if (version.isOlderThan(ServerVersion.V_1_17)) {
            return 16;
        }
        return 17;
    }

    protected static Method tryMultipleMethods(Class<?> clazz, Class<?>[] args2, Consumer<Method> check, String ... possibleMethodNames) {
        for (String methodName : possibleMethodNames) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, args2);
                check.accept(method);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected static Method tryMultipleMethods(Class<?> clazz, Class<?>[] args2, String ... possibleMethodNames) {
        return CrossVersionPlayerHelper.tryMultipleMethods(clazz, args2, (Method method) -> {}, possibleMethodNames);
    }

    protected static Field tryMultipleFields(Class<?> clazz, Consumer<Field> check, String ... possibleFieldNames) {
        for (String methodName : possibleFieldNames) {
            try {
                Field field = clazz.getDeclaredField(methodName);
                check.accept(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    protected static Field tryMultipleFields(Class<?> clazz, String ... possibleFieldNames) {
        return CrossVersionPlayerHelper.tryMultipleFields(clazz, (Field method) -> {}, possibleFieldNames);
    }

    protected static Class<?> tryMultipleClasses(String ... possibleClassNames) {
        for (String className : possibleClassNames) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected static Constructor<?> tryMultipleConstructors(Class<?>[] classes, Class<?> ... args2) {
        for (Class<?> clazz : classes) {
            try {
                return clazz.getConstructor(args2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    static {
        try {
            Method skinTextureSignatureMethod1;
            Method skinTextureValueMethod1;
            Class<?> playerListClass1;
            Field getPing1;
            Class<?> entityClass1;
            Class<?> playerClass1;
            craftPlayer = Class.forName("org.bukkit.craftbukkit." + NMSUtils.getMinecraftPackage() + ".entity.CraftPlayer");
            try {
                playerClass1 = Class.forName("net.minecraft.world.entity.player.EntityHuman");
            }
            catch (Exception e) {
                playerClass1 = Class.forName("net.minecraft.server." + NMSUtils.getMinecraftPackage() + ".EntityHuman");
            }
            playerClass = playerClass1;
            craftEntity = Class.forName("org.bukkit.craftbukkit." + NMSUtils.getMinecraftPackage() + ".entity.CraftEntity");
            try {
                entityClass1 = Class.forName("net.minecraft.world.entity.Entity");
            }
            catch (Exception e) {
                entityClass1 = Class.forName("net.minecraft.server." + NMSUtils.getMinecraftPackage() + ".Entity");
            }
            entityClass = entityClass1;
            craftWorld = Class.forName("org.bukkit.craftbukkit." + NMSUtils.getMinecraftPackage() + ".CraftWorld");
            try {
                getPing1 = Class.forName("net.minecraft.server." + NMSUtils.getMinecraftPackage() + ".EntityPlayer").getDeclaredField("ping");
            }
            catch (Exception e) {
                getPing1 = null;
            }
            getPing = getPing1;
            if (getPing != null) {
                getPing.setAccessible(true);
            }
            getPlayerHandle = craftPlayer.getDeclaredMethod("getHandle", new Class[0]);
            getEntityHandle = craftEntity.getDeclaredMethod("getHandle", new Class[0]);
            getWorldHandle = craftWorld.getDeclaredMethod("getHandle", new Class[0]);
            getPlayerHandle.setAccessible(true);
            serverPlayerClass = getPlayerHandle.getReturnType();
            gameProfileField = CrossVersionPlayerHelper.tryMultipleFields(playerClass, "cq", "cr", "bH");
            if (gameProfileField == null) {
                throw new NullPointerException("gameProfile field not found");
            }
            Class<?> gpClass = gameProfileField.getType();
            if (gpClass == null) {
                throw new NullPointerException("GameProfile class not found");
            }
            Constructor<?> gpConstructor = gpClass.getConstructor(UUID.class, String.class);
            gameProfileField.setAccessible(true);
            craftServerClass = Class.forName("org.bukkit.craftbukkit." + NMSUtils.getMinecraftPackage() + ".CraftServer");
            getServerHandle = craftServerClass.getDeclaredMethod("getHandle", new Class[0]);
            getServerHandle.setAccessible(true);
            gameProfileClass = gpClass;
            gameProfileConstructor = gpConstructor;
            propertiesField = gameProfileClass.getDeclaredField("properties");
            propertiesField.setAccessible(true);
            propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            propertyConstcutor = propertyClass.getConstructor(String.class, String.class, String.class);
            try {
                playerListClass1 = Class.forName("net.minecraft.server.players.PlayerList");
            }
            catch (Exception e) {
                playerListClass1 = Class.forName("net.minecraft.server." + NMSUtils.getMinecraftPackage() + ".PlayerList");
            }
            playerListClass = playerListClass1;
            playersByName = playerListClass.getDeclaredField("playersByName");
            playersByName.setAccessible(true);
            try {
                skinTextureValueMethod1 = propertyClass.getDeclaredMethod("getValue", new Class[0]);
                skinTextureSignatureMethod1 = propertyClass.getDeclaredMethod("getSignature", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                skinTextureValueMethod1 = propertyClass.getDeclaredMethod("value", new Class[0]);
                skinTextureSignatureMethod1 = propertyClass.getDeclaredMethod("signature", new Class[0]);
            }
            skinTextureValueMethod = skinTextureValueMethod1;
            skinTextureValueMethod.setAccessible(true);
            skinTextureSignatureMethod = skinTextureSignatureMethod1;
            skinTextureSignatureMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

