/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketSendEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerTags
extends PacketWrapper<WrapperPlayServerTags> {
    private Map<String, List<Tag>> tags;

    public WrapperPlayServerTags(PacketSendEvent event) {
        super(event);
    }

    @Override
    public void read() {
        int count = this.readVarInt();
        this.tags = new HashMap<String, List<Tag>>(count);
        for (int tagIter = 0; tagIter < count; ++tagIter) {
            String resourceName = this.readString();
            int elements = this.readVarInt();
            ArrayList<Tag> tagList = new ArrayList<Tag>(elements);
            for (int valueIter = 0; valueIter < elements; ++valueIter) {
                String tagName = this.readString();
                int tagElements = this.readVarInt();
                ArrayList<Integer> tagValues = new ArrayList<Integer>(tagElements);
                for (int tagValueIter = 0; tagValueIter < tagElements; ++tagValueIter) {
                    tagValues.add(this.readVarInt());
                }
                tagList.add(new Tag(tagName, tagValues));
            }
            this.tags.put(resourceName, tagList);
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.tags.size());
        for (Map.Entry<String, List<Tag>> entry : this.tags.entrySet()) {
            this.writeString(entry.getKey());
            this.writeVarInt(entry.getValue().size());
            for (Tag tag : entry.getValue()) {
                this.writeString(tag.getName());
                this.writeVarInt(tag.getValues().size());
                for (Integer value : tag.getValues()) {
                    this.writeVarInt(value);
                }
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerTags wrapper) {
        this.tags = wrapper.tags;
    }

    public Map<String, List<Tag>> getTags() {
        return this.tags;
    }

    public void setTags(HashMap<String, List<Tag>> tags) {
        this.tags = tags;
    }

    public static class Tag {
        private String name;
        private List<Integer> values;

        public Tag(String name, List<Integer> values2) {
            this.name = name;
            this.values = values2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Integer> getValues() {
            return this.values;
        }

        public void setValues(List<Integer> values2) {
            this.values = values2;
        }
    }
}

