/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server;

import java.util.ArrayList;
import java.util.List;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketSendEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.packettype.PacketType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.Particle;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.type.ParticleType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.resources.ResourceLocation;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.Vector3d;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.Vector3f;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.Vector3i;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3d position;
    private float strength;
    private List<Vector3i> records;
    private Vector3f playerMotion;
    private Particle smallExplosionParticles;
    private Particle largeExplosionParticles;
    private BlockInteraction blockInteraction;
    private ResourceLocation explosionSoundKey;
    @Nullable
    private Float explosionSoundRange;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        this(position, strength, records, playerMotion, new Particle(ParticleTypes.EXPLOSION), new Particle(ParticleTypes.EXPLOSION_EMITTER), BlockInteraction.DESTROY_BLOCKS, new ResourceLocation("minecraft:entity.generic.explode"), null);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle smallExplosionParticles, Particle largeExplosionParticles, BlockInteraction blockInteraction, ResourceLocation explosionSoundKey, @Nullable Float explosionSoundRange) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.records = records;
        this.playerMotion = playerMotion;
        this.smallExplosionParticles = smallExplosionParticles;
        this.largeExplosionParticles = largeExplosionParticles;
        this.blockInteraction = blockInteraction;
        this.explosionSoundKey = explosionSoundKey;
        this.explosionSoundRange = explosionSoundRange;
    }

    @Override
    public void read() {
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? new Vector3d(this.readDouble(), this.readDouble(), this.readDouble()) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        this.strength = this.readFloat();
        int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.records = new ArrayList<Vector3i>(recordsLength);
        Vector3i floor = this.toFloor(this.position);
        for (int i = 0; i < recordsLength; ++i) {
            int chunkPosX = this.readByte() + floor.getX();
            int chunkPosY = this.readByte() + floor.getY();
            int chunkPosZ = this.readByte() + floor.getZ();
            this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
        }
        float motX = this.readFloat();
        float motY = this.readFloat();
        float motZ = this.readFloat();
        this.playerMotion = new Vector3f(motX, motY, motZ);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.blockInteraction = BlockInteraction.values()[this.readVarInt()];
            ParticleType smallPartType = ParticleTypes.getById(this.serverVersion.toClientVersion(), this.readVarInt());
            ParticleData smallPartData = smallPartType.readDataFunction().apply(this);
            this.smallExplosionParticles = new Particle(smallPartType, smallPartData);
            ParticleType largePartType = ParticleTypes.getById(this.serverVersion.toClientVersion(), this.readVarInt());
            ParticleData largePartData = largePartType.readDataFunction().apply(this);
            this.largeExplosionParticles = new Particle(largePartType, largePartData);
            this.explosionSoundKey = this.readIdentifier();
            this.explosionSoundRange = (Float)this.readOptional(PacketWrapper::readFloat);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            this.writeDouble(this.position.getX());
            this.writeDouble(this.position.getY());
            this.writeDouble(this.position.getZ());
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        this.writeFloat(this.strength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.records.size());
        } else {
            this.writeInt(this.records.size());
        }
        Vector3i floor = this.toFloor(this.position);
        for (Vector3i record : this.records) {
            this.writeByte(record.x - floor.getX());
            this.writeByte(record.y - floor.getY());
            this.writeByte(record.z - floor.getZ());
        }
        this.writeFloat(this.playerMotion.x);
        this.writeFloat(this.playerMotion.y);
        this.writeFloat(this.playerMotion.z);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.writeVarInt(this.blockInteraction.ordinal());
            this.writeVarInt(this.smallExplosionParticles.getType().getId(this.serverVersion.toClientVersion()));
            this.smallExplosionParticles.getType().writeDataFunction().accept(this, this.smallExplosionParticles.getData());
            this.writeVarInt(this.largeExplosionParticles.getType().getId(this.serverVersion.toClientVersion()));
            this.largeExplosionParticles.getType().writeDataFunction().accept(this, this.largeExplosionParticles.getData());
            this.writeIdentifier(this.explosionSoundKey);
            this.writeOptional(this.explosionSoundRange, PacketWrapper::writeFloat);
        }
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.records = wrapper.records;
        this.playerMotion = wrapper.playerMotion;
        this.smallExplosionParticles = wrapper.smallExplosionParticles;
        this.largeExplosionParticles = wrapper.largeExplosionParticles;
        this.blockInteraction = wrapper.blockInteraction;
        this.explosionSoundKey = wrapper.explosionSoundKey;
        this.explosionSoundRange = wrapper.explosionSoundRange;
    }

    private Vector3i toFloor(Vector3d position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    public Vector3f getPlayerMotion() {
        return this.playerMotion;
    }

    public void setPlayerMotion(Vector3f playerMotion) {
        this.playerMotion = playerMotion;
    }

    public Particle getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public void setSmallExplosionParticles(Particle smallExplosionParticles) {
        this.smallExplosionParticles = smallExplosionParticles;
    }

    public Particle getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public void setLargeExplosionParticles(Particle largeExplosionParticles) {
        this.largeExplosionParticles = largeExplosionParticles;
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public void setBlockInteraction(BlockInteraction blockInteraction) {
        this.blockInteraction = blockInteraction;
    }

    public ResourceLocation getExplosionSoundKey() {
        return this.explosionSoundKey;
    }

    public void setExplosionSoundKey(ResourceLocation explosionSoundKey) {
        this.explosionSoundKey = explosionSoundKey;
    }

    @Nullable
    public Float getExplosionSoundRange() {
        return this.explosionSoundRange;
    }

    public void setExplosionSoundRange(@Nullable Float explosionSoundRange) {
        this.explosionSoundRange = explosionSoundRange;
    }

    public static enum BlockInteraction {
        KEEP_BLOCKS,
        DESTROY_BLOCKS,
        DECAY_DESTROYED_BLOCKS,
        TRIGGER_BLOCKS;

    }
}

