/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server;

import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketSendEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.packettype.PacketType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerCraftRecipeResponse
extends PacketWrapper<WrapperPlayServerCraftRecipeResponse> {
    private int windowId;
    private int recipeLegacy;
    @Nullable
    private String recipeModern;

    public WrapperPlayServerCraftRecipeResponse(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, int recipeLegacy) {
        super(PacketType.Play.Server.CRAFT_RECIPE_RESPONSE);
        this.windowId = windowId;
        this.recipeLegacy = recipeLegacy;
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, @Nullable String recipeModern) {
        super(PacketType.Play.Server.CRAFT_RECIPE_RESPONSE);
        this.windowId = windowId;
        this.recipeModern = recipeModern;
    }

    @Override
    public void read() {
        this.windowId = this.readByte();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.recipeModern = this.readString();
        } else {
            this.recipeLegacy = this.readVarInt();
        }
    }

    @Override
    public void write() {
        this.writeByte(this.windowId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeString(this.recipeModern);
        } else {
            this.writeVarInt(this.recipeLegacy);
        }
    }

    @Override
    public void copy(WrapperPlayServerCraftRecipeResponse wrapper) {
        this.windowId = wrapper.windowId;
        this.recipeLegacy = wrapper.recipeLegacy;
        this.recipeModern = wrapper.recipeModern;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public void setWindowId(int windowId) {
        this.windowId = windowId;
    }

    public <T> T getRecipe() {
        return (T)(this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? this.recipeModern : Integer.valueOf(this.recipeLegacy));
    }

    public <T> void setRecipe(T recipe) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.recipeModern = (String)recipe;
        } else {
            this.recipeLegacy = (Integer)recipe;
        }
    }
}

