/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.updatechecker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import me.onlyjordon.swiftdisguise.libs.gson.JsonObject;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.NamedTextColor;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.ColorUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.PEVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.AdventureSerializer;

public class UpdateChecker {
    public String checkLatestReleasedVersion() {
        try {
            URLConnection connection = new URL("https://api.github.com/repos/retrooper/packetevents/releases/latest").openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String jsonResponse = reader.readLine();
            reader.close();
            JsonObject jsonObject = AdventureSerializer.getGsonSerializer().serializer().fromJson(jsonResponse, JsonObject.class);
            return jsonObject.get("name").getAsString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse packetevents version!", e);
        }
    }

    public UpdateCheckerStatus checkForUpdate() {
        PEVersion newVersion;
        PEVersion localVersion = PacketEvents.getAPI().getVersion();
        try {
            newVersion = new PEVersion(this.checkLatestReleasedVersion());
        }
        catch (Exception ex) {
            PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. " + (ex.getCause() != null ? ex.getCause().getClass().getName() + ": " + ex.getCause().getMessage() : ex.getMessage()));
            return UpdateCheckerStatus.FAILED;
        }
        if (localVersion.isOlderThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().warn("There is an update available for packetevents! Your build: (" + ColorUtil.toString(NamedTextColor.YELLOW) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest released build: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.OUTDATED;
        }
        if (localVersion.isNewerThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are on a dev or pre released build of packetevents. Your build: (" + ColorUtil.toString(NamedTextColor.AQUA) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest released build: (" + ColorUtil.toString(NamedTextColor.DARK_AQUA) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.PRE_RELEASE;
        }
        if (localVersion.equals(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are on the latest released version of packetevents. Your build: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.UP_TO_DATE;
        }
        PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. Your build: (" + localVersion + ")");
        return UpdateCheckerStatus.FAILED;
    }

    public void handleUpdateCheck() {
        Thread thread2 = new Thread(() -> {
            PacketEvents.getAPI().getLogManager().info("Checking for updates, please wait...");
            UpdateCheckerStatus status = this.checkForUpdate();
            int waitTimeInSeconds = 5;
            int maxRetryCount = 3;
            for (int retries = 0; retries < maxRetryCount && status == UpdateCheckerStatus.FAILED; ++retries) {
                PacketEvents.getAPI().getLogManager().warn("Checking for updates again in " + waitTimeInSeconds + " seconds...");
                try {
                    Thread.sleep((long)waitTimeInSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTimeInSeconds *= 2;
                status = this.checkForUpdate();
                if (retries != maxRetryCount - 1) continue;
                PacketEvents.getAPI().getLogManager().severe("Failed to check for updates after " + maxRetryCount + " times.");
                break;
            }
        }, "packetevents-update-check-thread");
        thread2.start();
    }

    public static enum UpdateCheckerStatus {
        OUTDATED,
        PRE_RELEASE,
        UP_TO_DATE,
        FAILED;

    }
}

