/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Reflection {
    public static Field[] getFields(Class<?> cls) {
        Field[] declaredFields;
        if (cls == null) {
            return new Field[0];
        }
        for (Field f : declaredFields = cls.getDeclaredFields()) {
            f.setAccessible(true);
        }
        return declaredFields;
    }

    public static Field getField(Class<?> cls, String name) {
        if (cls == null) {
            return null;
        }
        try {
            Field field = cls.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = cls.getField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e1) {
                if (cls.getSuperclass() != null) {
                    return Reflection.getField(cls.getSuperclass(), name);
                }
                return null;
            }
        }
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index, boolean ignoreStatic) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || ignoreStatic && Modifier.isStatic(f.getModifiers()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, int index) {
        if (cls == null) {
            return null;
        }
        try {
            return Reflection.getFields(cls)[index];
        }
        catch (Exception ex) {
            if (cls.getSuperclass() != null) {
                return Reflection.getFields(cls.getSuperclass())[index];
            }
            return null;
        }
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        try {
            Method m4 = cls.getDeclaredMethod(name, params);
            m4.setAccessible(true);
            return m4;
        }
        catch (NoSuchMethodException e) {
            try {
                Method m5 = cls.getMethod(name, params);
                m5.setAccessible(true);
                return m5;
            }
            catch (NoSuchMethodException e1) {
                if (cls.getSuperclass() != null) {
                    return Reflection.getMethod(cls.getSuperclass(), name, params);
                }
                return null;
            }
        }
    }

    public static Method getMethod(Class<?> cls, int index, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m4 : cls.getDeclaredMethods()) {
            if (params != null && !Arrays.equals(m4.getParameterTypes(), params) || index != currentIndex++) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), index, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m4 : cls.getDeclaredMethods()) {
            if (!Arrays.equals(m4.getParameterTypes(), params) || returning != null && !m4.getReturnType().equals(returning) || index != currentIndex++) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), null, index, params);
        }
        return null;
    }

    public static Method getMethodExact(Class<?> cls, String name, Class<?> returning, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        for (Method m4 : cls.getDeclaredMethods()) {
            if (!m4.getName().equals(name) || !Arrays.equals(m4.getParameterTypes(), params) || returning != null && !m4.getReturnType().equals(returning)) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethodExact(cls.getSuperclass(), name, null, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m4 : cls.getDeclaredMethods()) {
            if (!m4.getName().equals(name) || index != currentIndex++) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), name, index);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m4 : cls.getDeclaredMethods()) {
            if (returning != null && !m4.getReturnType().equals(returning) || index != currentIndex++) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), returning, index);
        }
        return null;
    }

    public static Method getMethodCheckContainsString(Class<?> cls, String nameContainsThisStr, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        for (Method m4 : cls.getDeclaredMethods()) {
            if (!m4.getName().contains(nameContainsThisStr) || returning != null && !m4.getReturnType().equals(returning)) continue;
            m4.setAccessible(true);
            return m4;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethodCheckContainsString(cls.getSuperclass(), nameContainsThisStr, returning);
        }
        return null;
    }

    public static List<Method> getMethods(Class<?> cls, String name, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m4 : cls.getDeclaredMethods()) {
            if (!m4.getName().equals(name) || returning != null && !m4.getReturnType().equals(returning)) continue;
            m4.setAccessible(true);
            methods.add(m4);
        }
        if (cls.getSuperclass() != null) {
            methods.addAll(Reflection.getMethods(cls.getSuperclass(), name, returning));
        }
        return methods;
    }

    @Nullable
    public static Class<?> getClassByNameWithoutException(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> cls, int index) {
        if (cls == null) {
            return null;
        }
        Constructor<?> constructor = cls.getDeclaredConstructors()[index];
        constructor.setAccessible(true);
        return constructor;
    }

    public static Constructor<?> getConstructor(Class<?> cls, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        try {
            Constructor<?> c = cls.getDeclaredConstructor(params);
            c.setAccessible(true);
            return c;
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<?> c = cls.getConstructor(params);
                c.setAccessible(true);
                return c;
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
    }
}

