/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import java.io.IOException;
import me.onlyjordon.swiftdisguise.libs.gson.JsonParseException;
import me.onlyjordon.swiftdisguise.libs.gson.JsonSyntaxException;
import me.onlyjordon.swiftdisguise.libs.gson.TypeAdapter;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonReader;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonWriter;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.NamedTextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public class TextColorWrapper {
    @Nullable
    final TextColor color;
    @Nullable
    final TextDecoration decoration;
    final boolean reset;

    TextColorWrapper(@Nullable TextColor color, @Nullable TextDecoration decoration, boolean reset) {
        this.color = color;
        this.decoration = decoration;
        this.reset = reset;
    }

    static final class Serializer
    extends TypeAdapter<TextColorWrapper> {
        static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(JsonWriter out, TextColorWrapper value) {
            throw new JsonSyntaxException("Cannot write TextColorWrapper instances");
        }

        @Override
        public TextColorWrapper read(JsonReader in) throws IOException {
            boolean reset;
            String input = in.nextString();
            TextColor color = this.colorFromString(input);
            TextDecoration decoration = TextDecoration.NAMES.value(input);
            boolean bl = reset = decoration == null && input.equals("reset");
            if (color == null && decoration == null && !reset) {
                throw new JsonParseException("Don't know how to parse " + input + " at " + in.getPath());
            }
            return new TextColorWrapper(color, decoration, reset);
        }

        TextColor colorFromString(String value) {
            if (value.startsWith("#")) {
                return TextColor.fromHexString(value);
            }
            return NamedTextColor.NAMES.value(value);
        }
    }
}

