/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import me.onlyjordon.swiftdisguise.libs.gson.Gson;
import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.gson.JsonObject;
import me.onlyjordon.swiftdisguise.libs.gson.JsonParseException;
import me.onlyjordon.swiftdisguise.libs.gson.JsonPrimitive;
import me.onlyjordon.swiftdisguise.libs.gson.JsonSyntaxException;
import me.onlyjordon.swiftdisguise.libs.gson.TypeAdapter;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonReader;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonToken;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonWriter;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.key.Key;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.ClickEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.HoverEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.Style;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextDecoration;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.util.Codec;
import me.onlyjordon.swiftdisguise.libs.kyori.examination.Examinable;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.HoverSerializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.TextColorWrapper;
import org.jetbrains.annotations.Nullable;

public class StyleSerializerExtended
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";
    private final boolean emitLegacyHover;
    private final Gson gson;
    private final HoverSerializer hoverSerializer;

    static TypeAdapter<Style> create(boolean emitLegacyHover, Gson gson) {
        return new StyleSerializerExtended(emitLegacyHover, gson).nullSafe();
    }

    private StyleSerializerExtended(boolean emitLegacyHover, Gson gson) {
        this.emitLegacyHover = emitLegacyHover;
        this.gson = gson;
        this.hoverSerializer = new HoverSerializer();
    }

    @Override
    public Style read(JsonReader in) throws IOException {
        in.beginObject();
        Style.Builder style = Style.style();
        while (in.hasNext()) {
            String fieldName = in.nextName();
            if (fieldName.equals(FONT)) {
                style.font((Key)this.gson.fromJson(in, (Type)((Object)Key.class)));
                continue;
            }
            if (fieldName.equals(COLOR)) {
                TextColorWrapper color = (TextColorWrapper)this.gson.fromJson(in, (Type)((Object)TextColorWrapper.class));
                if (color.color != null) {
                    style.color(color.color);
                    continue;
                }
                if (color.decoration == null) continue;
                style.decoration(color.decoration, TextDecoration.State.TRUE);
                continue;
            }
            if (TextDecoration.NAMES.keys().contains(fieldName)) {
                style.decoration(TextDecoration.NAMES.value(fieldName), this.readBoolean(in));
                continue;
            }
            if (fieldName.equals(INSERTION)) {
                style.insertion(in.nextString());
                continue;
            }
            if (fieldName.equals(CLICK_EVENT)) {
                in.beginObject();
                ClickEvent.Action action = null;
                String value = null;
                while (in.hasNext()) {
                    String clickEventField = in.nextName();
                    if (clickEventField.equals("action")) {
                        action = (ClickEvent.Action)((Object)this.gson.fromJson(in, (Type)((Object)ClickEvent.Action.class)));
                        continue;
                    }
                    if (clickEventField.equals("value")) {
                        value = in.peek() == JsonToken.NULL ? null : in.nextString();
                        continue;
                    }
                    in.skipValue();
                }
                if (action != null && action.readable() && value != null) {
                    style.clickEvent(ClickEvent.clickEvent(action, value));
                }
                in.endObject();
                continue;
            }
            if (fieldName.equals(HOVER_EVENT)) {
                JsonElement rawValue;
                JsonPrimitive serializedAction;
                JsonObject hoverEventObject = (JsonObject)this.gson.fromJson(in, (Type)((Object)JsonObject.class));
                if (hoverEventObject == null || (serializedAction = hoverEventObject.getAsJsonPrimitive("action")) == null) continue;
                boolean legacy = false;
                if (hoverEventObject.has(HOVER_EVENT_CONTENTS)) {
                    rawValue = hoverEventObject.get(HOVER_EVENT_CONTENTS);
                } else if (hoverEventObject.has("value")) {
                    rawValue = hoverEventObject.get("value");
                    legacy = true;
                } else {
                    rawValue = null;
                }
                if (rawValue == null) continue;
                HoverEvent.Action<Examinable> action = null;
                Examinable value = null;
                switch (serializedAction.getAsString()) {
                    case "show_text": {
                        action = HoverEvent.Action.SHOW_TEXT;
                        value = this.gson.fromJson(rawValue, Component.class);
                        break;
                    }
                    case "show_item": {
                        action = HoverEvent.Action.SHOW_ITEM;
                        value = this.hoverSerializer.deserializeShowItem(HoverSerializer.GsonLike.fromGson(this.gson), rawValue, legacy);
                        break;
                    }
                    case "show_entity": {
                        action = HoverEvent.Action.SHOW_ENTITY;
                        value = this.hoverSerializer.deserializeShowEntity(HoverSerializer.GsonLike.fromGson(this.gson), rawValue, this.decoder(), legacy);
                        break;
                    }
                    case "show_achievement": {
                        action = HoverEvent.Action.SHOW_TEXT;
                        value = this.hoverSerializer.deserializeShowAchievement(rawValue);
                    }
                }
                if (value == null) continue;
                style.hoverEvent(HoverEvent.hoverEvent(action, value));
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return style.build();
    }

    private boolean readBoolean(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.BOOLEAN) {
            return in.nextBoolean();
        }
        if (peek == JsonToken.STRING || peek == JsonToken.NUMBER) {
            return Boolean.parseBoolean(in.nextString());
        }
        throw new JsonParseException("Token of type " + (Object)((Object)peek) + " cannot be interpreted as a boolean");
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder() {
        return string -> this.gson.fromJson((String)string, Component.class);
    }

    private Codec.Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, (Type)((Object)Component.class));
    }

    @Override
    public void write(JsonWriter out, Style value) throws IOException {
        Key font;
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        out.beginObject();
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = value.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            String name = TextDecoration.NAMES.key(decoration);
            assert (name != null);
            out.name(name);
            out.value(state == TextDecoration.State.TRUE);
        }
        @Nullable TextColor color = value.color();
        if (color != null) {
            out.name(COLOR);
            this.gson.toJson((Object)color, (Type)((Object)TextColor.class), out);
        }
        if ((insertion = value.insertion()) != null) {
            out.name(INSERTION);
            out.value(insertion);
        }
        if ((clickEvent = value.clickEvent()) != null) {
            out.name(CLICK_EVENT);
            out.beginObject();
            out.name("action");
            this.gson.toJson((Object)clickEvent.action(), (Type)((Object)ClickEvent.Action.class), out);
            out.name("value");
            out.value(clickEvent.value());
            out.endObject();
        }
        if ((hoverEvent = value.hoverEvent()) != null) {
            out.name(HOVER_EVENT);
            out.beginObject();
            out.name("action");
            HoverEvent.Action<?> action = hoverEvent.action();
            this.gson.toJson((Object)action, (Type)((Object)HoverEvent.Action.class), out);
            if (this.emitLegacyHover) {
                out.name("value");
                this.serializeLegacyHoverEvent(hoverEvent, out);
            } else if (!action.toString().equals("show_achievement")) {
                out.name(HOVER_EVENT_CONTENTS);
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    this.gson.toJson(hoverEvent.value(), (Type)((Object)HoverEvent.ShowItem.class), out);
                } else if (action == HoverEvent.Action.SHOW_ENTITY) {
                    this.gson.toJson(hoverEvent.value(), (Type)((Object)HoverEvent.ShowEntity.class), out);
                } else if (action == HoverEvent.Action.SHOW_TEXT) {
                    this.gson.toJson(hoverEvent.value(), (Type)((Object)Component.class), out);
                } else {
                    throw new JsonParseException("Don't know how to serialize " + hoverEvent.value());
                }
            }
            out.endObject();
        }
        if ((font = value.font()) != null) {
            out.name(FONT);
            this.gson.toJson((Object)font, (Type)((Object)Key.class), out);
        }
        out.endObject();
    }

    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter out) throws IOException {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            this.gson.toJson(hoverEvent.value(), (Type)((Object)Component.class), out);
            return;
        }
        if (hoverEvent.action().toString().equals("show_achievement")) {
            this.gson.toJson(hoverEvent.value(), (Type)((Object)String.class), out);
            return;
        }
        Component serialized = null;
        try {
            if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                serialized = this.hoverSerializer.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder());
            } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                serialized = this.hoverSerializer.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
            }
        }
        catch (IOException ex) {
            throw new JsonSyntaxException(ex);
        }
        if (serialized != null) {
            this.gson.toJson((Object)serialized, (Type)((Object)Component.class), out);
        } else {
            out.nullValue();
        }
    }

    static {
        EnumSet<TextDecoration> knownDecorations = EnumSet.allOf(TextDecoration.class);
        for (TextDecoration decoration : DECORATIONS) {
            knownDecorations.remove(decoration);
        }
        if (!knownDecorations.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + knownDecorations);
        }
    }
}

