/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import java.util.UUID;
import me.onlyjordon.swiftdisguise.libs.gson.Gson;
import me.onlyjordon.swiftdisguise.libs.gson.TypeAdapter;
import me.onlyjordon.swiftdisguise.libs.gson.TypeAdapterFactory;
import me.onlyjordon.swiftdisguise.libs.gson.reflect.TypeToken;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.key.Key;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.BlockNBTComponent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.TranslationArgument;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.ClickEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.HoverEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.Style;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextDecoration;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.AdventureReflectionUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.StyleSerializerExtended;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.TextColorWrapper;

public class SerializerFactory
implements TypeAdapterFactory {
    private final boolean downsampleColors;
    private final boolean emitLegacyHover;

    SerializerFactory(boolean downsampleColors, boolean emitLegacyHover) {
        this.downsampleColors = downsampleColors;
        this.emitLegacyHover = emitLegacyHover;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (Component.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.COMPONENT_SERIALIZER_CREATE.apply(gson);
        }
        if (Key.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.KEY_SERIALIZER_INSTANCE;
        }
        if (Style.class.isAssignableFrom(rawType)) {
            return StyleSerializerExtended.create(this.emitLegacyHover, gson);
        }
        if (ClickEvent.Action.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.CLICK_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.Action.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.HOVER_EVENT_ACTION_SERIALIZER_INSTANCE;
        }
        if (HoverEvent.ShowItem.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.SHOW_ITEM_SERIALIZER_CREATE.apply(gson);
        }
        if (HoverEvent.ShowEntity.class.isAssignableFrom(rawType)) {
            return (TypeAdapter)AdventureReflectionUtil.SHOW_ENTITY_SERIALIZER_CREATE.apply(gson);
        }
        if (TextColorWrapper.class.isAssignableFrom(rawType)) {
            return TextColorWrapper.Serializer.INSTANCE;
        }
        if (TextColor.class.isAssignableFrom(rawType)) {
            return this.downsampleColors ? AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE : AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_INSTANCE;
        }
        if (TextDecoration.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.TEXT_DECORATION_SERIALIZER_INSTANCE;
        }
        if (BlockNBTComponent.Pos.class.isAssignableFrom(rawType)) {
            return AdventureReflectionUtil.BLOCK_NBT_POS_SERIALIZER_INSTANCE;
        }
        if (AdventureReflectionUtil.IS_4_15_0_OR_NEWER) {
            if (UUID.class.isAssignableFrom(rawType)) {
                return AdventureReflectionUtil.UUID_SERIALIZER_INSTANCE;
            }
            if (TranslationArgument.class.isAssignableFrom(rawType)) {
                return (TypeAdapter)AdventureReflectionUtil.TRANSLATION_ARGUMENT_SERIALIZER_CREATE.apply(gson);
            }
        }
        return null;
    }
}

