/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.EnumSet;
import me.onlyjordon.swiftdisguise.libs.gson.JsonDeserializationContext;
import me.onlyjordon.swiftdisguise.libs.gson.JsonDeserializer;
import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.gson.JsonNull;
import me.onlyjordon.swiftdisguise.libs.gson.JsonObject;
import me.onlyjordon.swiftdisguise.libs.gson.JsonParseException;
import me.onlyjordon.swiftdisguise.libs.gson.JsonPrimitive;
import me.onlyjordon.swiftdisguise.libs.gson.JsonSerializationContext;
import me.onlyjordon.swiftdisguise.libs.gson.JsonSerializer;
import me.onlyjordon.swiftdisguise.libs.gson.JsonSyntaxException;
import me.onlyjordon.swiftdisguise.libs.gson.internal.Streams;
import me.onlyjordon.swiftdisguise.libs.gson.stream.JsonReader;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.key.Key;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.ClickEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.HoverEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.Style;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextDecoration;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.util.Codec;
import me.onlyjordon.swiftdisguise.libs.kyori.examination.Examinable;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.HoverSerializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.TextColorWrapper;

public class Legacy_StyleSerializerExtended
implements JsonDeserializer<Style>,
JsonSerializer<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";
    private final boolean emitLegacyHover;
    private final HoverSerializer hoverSerializer;

    Legacy_StyleSerializerExtended(boolean emitLegacyHover) {
        this.emitLegacyHover = emitLegacyHover;
        this.hoverSerializer = new HoverSerializer();
    }

    @Override
    public Style deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        return this.deserialize(object, context);
    }

    private Style deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive serializedAction;
        JsonObject jsonObject;
        ClickEvent.Action action;
        JsonObject jsonObject2;
        Style.Builder style = Style.style();
        if (json.has(FONT)) {
            style.font((Key)context.deserialize(json.get(FONT), (Type)((Object)Key.class)));
        }
        if (json.has(COLOR)) {
            TextColorWrapper textColorWrapper = (TextColorWrapper)context.deserialize(json.get(COLOR), (Type)((Object)TextColorWrapper.class));
            if (textColorWrapper.color != null) {
                style.color(textColorWrapper.color);
            } else if (textColorWrapper.decoration != null) {
                style.decoration(textColorWrapper.decoration, true);
            }
        }
        for (TextDecoration decoration : DECORATIONS) {
            String value = TextDecoration.NAMES.key(decoration);
            if (!json.has(value)) continue;
            style.decoration(decoration, json.get(value).getAsBoolean());
        }
        if (json.has(INSERTION)) {
            style.insertion(json.get(INSERTION).getAsString());
        }
        if (json.has(CLICK_EVENT) && (jsonObject2 = json.getAsJsonObject(CLICK_EVENT)) != null && (action = Legacy_StyleSerializerExtended.optionallyDeserialize(jsonObject2.getAsJsonPrimitive("action"), context, ClickEvent.Action.class)) != null && action.readable()) {
            String value;
            JsonPrimitive rawValue = jsonObject2.getAsJsonPrimitive("value");
            String string = value = rawValue == null ? null : rawValue.getAsString();
            if (value != null) {
                style.clickEvent(ClickEvent.clickEvent(action, value));
            }
        }
        if (json.has(HOVER_EVENT) && (jsonObject = json.getAsJsonObject(HOVER_EVENT)) != null && (serializedAction = jsonObject.getAsJsonPrimitive("action")) != null) {
            JsonElement rawValue;
            boolean legacy;
            if (jsonObject.has(HOVER_EVENT_CONTENTS)) {
                legacy = false;
                rawValue = jsonObject.get(HOVER_EVENT_CONTENTS);
            } else if (jsonObject.has("value")) {
                rawValue = jsonObject.get("value");
                legacy = true;
            } else {
                legacy = false;
                rawValue = null;
            }
            if (rawValue != null) {
                HoverEvent.Action<Examinable> action2 = null;
                Examinable value = null;
                switch (serializedAction.getAsString()) {
                    case "show_text": {
                        action2 = HoverEvent.Action.SHOW_TEXT;
                        value = (Examinable)context.deserialize(rawValue, (Type)((Object)Component.class));
                        break;
                    }
                    case "show_item": {
                        action2 = HoverEvent.Action.SHOW_ITEM;
                        value = this.tryIgnoring(() -> this.hoverSerializer.deserializeShowItem(context::deserialize, rawValue, legacy));
                        break;
                    }
                    case "show_entity": {
                        action2 = HoverEvent.Action.SHOW_ENTITY;
                        value = this.tryIgnoring(() -> this.hoverSerializer.deserializeShowEntity(context::deserialize, rawValue, this.decoder(context), legacy));
                        break;
                    }
                    case "show_achievement": {
                        action2 = HoverEvent.Action.SHOW_TEXT;
                        value = this.tryIgnoring(() -> this.hoverSerializer.deserializeShowAchievement(rawValue));
                    }
                }
                if (value != null) {
                    style.hoverEvent(HoverEvent.hoverEvent(action2, value));
                }
            }
        }
        if (json.has(FONT)) {
            style.font((Key)context.deserialize(json.get(FONT), (Type)((Object)Key.class)));
        }
        return style.build();
    }

    private <T> T tryIgnoring(ExceptionalFunction<T> function) {
        try {
            return function.invoke();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static <T> T optionallyDeserialize(JsonElement json, JsonDeserializationContext context, Class<T> type) {
        return json == null ? null : (T)context.deserialize(json, type);
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder(JsonDeserializationContext ctx) {
        return string -> {
            JsonReader reader = new JsonReader(new StringReader((String)string));
            return (Component)ctx.deserialize(Streams.parse(reader), (Type)((Object)Component.class));
        };
    }

    @Override
    public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
        Key font;
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        JsonObject json = new JsonObject();
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = src.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            String name = TextDecoration.NAMES.key(decoration);
            assert (name != null);
            json.addProperty(name, state == TextDecoration.State.TRUE);
        }
        TextColor color = src.color();
        if (color != null) {
            json.add(COLOR, context.serialize(color));
        }
        if ((insertion = src.insertion()) != null) {
            json.addProperty(INSERTION, insertion);
        }
        if ((clickEvent = src.clickEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize((Object)clickEvent.action()));
            eventJson.addProperty("value", clickEvent.value());
            json.add(CLICK_EVENT, eventJson);
        }
        if ((hoverEvent = src.hoverEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize(hoverEvent.action()));
            JsonElement modernContents = context.serialize(hoverEvent.value());
            eventJson.add(HOVER_EVENT_CONTENTS, modernContents);
            if (this.emitLegacyHover) {
                eventJson.add("value", this.serializeLegacyHoverEvent(hoverEvent, modernContents, context));
            }
            json.add(HOVER_EVENT, eventJson);
        }
        if ((font = src.font()) != null) {
            json.add(FONT, context.serialize(font));
        }
        return json;
    }

    private JsonElement serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonElement modernContents, JsonSerializationContext context) {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            return modernContents;
        }
        Component serialized = null;
        try {
            if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                serialized = this.hoverSerializer.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder(context));
            } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                serialized = this.hoverSerializer.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
            }
        }
        catch (IOException var6) {
            throw new JsonSyntaxException(var6);
        }
        return serialized == null ? JsonNull.INSTANCE : context.serialize(serialized);
    }

    private Codec.Encoder<Component, String, RuntimeException> encoder(JsonSerializationContext ctx) {
        return component -> ctx.serialize(component).toString();
    }

    static {
        EnumSet<TextDecoration> knownDecorations = EnumSet.allOf(TextDecoration.class);
        for (TextDecoration decoration : DECORATIONS) {
            knownDecorations.remove(decoration);
        }
        if (!knownDecorations.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + knownDecorations);
        }
    }

    @FunctionalInterface
    static interface ExceptionalFunction<T> {
        public T invoke() throws IOException;
    }
}

