/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import java.lang.reflect.Type;
import java.util.function.UnaryOperator;
import me.onlyjordon.swiftdisguise.libs.gson.Gson;
import me.onlyjordon.swiftdisguise.libs.gson.GsonBuilder;
import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.gson.JsonParseException;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.key.Key;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.BlockNBTComponent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.ClickEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.event.HoverEvent;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.Style;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextColor;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.TextDecoration;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.AdventureReflectionUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.Legacy_StyleSerializerExtended;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.SerializerFactory;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.TextColorWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GsonComponentSerializerExtended
implements GsonComponentSerializer {
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator = AdventureReflectionUtil.IS_LEGACY_ADVENTURE ? builder -> {
        builder.registerTypeHierarchyAdapter(Key.class, AdventureReflectionUtil.KEY_SERIALIZER_INSTANCE);
        builder.registerTypeHierarchyAdapter(Component.class, AdventureReflectionUtil.COMPONENT_SERIALIZER_CREATE.apply(null));
        builder.registerTypeHierarchyAdapter(Style.class, new Legacy_StyleSerializerExtended(emitLegacyHover));
        builder.registerTypeAdapter((Type)((Object)ClickEvent.Action.class), AdventureReflectionUtil.CLICK_EVENT_ACTION_SERIALIZER_INSTANCE);
        builder.registerTypeAdapter((Type)((Object)HoverEvent.Action.class), AdventureReflectionUtil.HOVER_EVENT_ACTION_SERIALIZER_INSTANCE);
        builder.registerTypeAdapter((Type)((Object)HoverEvent.ShowItem.class), AdventureReflectionUtil.SHOW_ITEM_SERIALIZER_CREATE.apply(null));
        builder.registerTypeAdapter((Type)((Object)HoverEvent.ShowEntity.class), AdventureReflectionUtil.SHOW_ENTITY_SERIALIZER_CREATE.apply(null));
        builder.registerTypeAdapter((Type)((Object)TextColorWrapper.class), TextColorWrapper.Serializer.INSTANCE);
        builder.registerTypeHierarchyAdapter(TextColor.class, downsampleColor ? AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_DOWNSAMPLE_COLOR_INSTANCE : AdventureReflectionUtil.TEXT_COLOR_SERIALIZER_INSTANCE);
        builder.registerTypeAdapter((Type)((Object)TextDecoration.class), AdventureReflectionUtil.TEXT_DECORATION_SERIALIZER_INSTANCE);
        builder.registerTypeHierarchyAdapter(BlockNBTComponent.Pos.class, AdventureReflectionUtil.BLOCK_NBT_POS_SERIALIZER_INSTANCE);
        return builder;
    } : builder -> {
        builder.registerTypeAdapterFactory(new SerializerFactory(downsampleColor, emitLegacyHover));
        return builder;
    };

    public GsonComponentSerializerExtended(boolean downsampleColor, boolean emitLegacyHover) {
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    @NotNull
    public Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        Component component = this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw new JsonParseException("Don't know how to turn " + string + " into a Component");
        }
        return component;
    }

    @Override
    @Nullable
    public Component deserializeOr(@Nullable String input, @Nullable Component fallback) {
        if (input == null) {
            return fallback;
        }
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            return fallback;
        }
        return component;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return this.serializer().toJson(component);
    }

    @Override
    @NotNull
    public Component deserializeFromTree(@NotNull JsonElement input) {
        Component component = this.serializer().fromJson(input, Component.class);
        if (component == null) {
            throw new JsonParseException("Don't know how to turn " + input + " into a Component");
        }
        return component;
    }

    @Override
    @NotNull
    public JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree(component);
    }

    @Override
    @NotNull
    public GsonComponentSerializer.Builder toBuilder() {
        throw new UnsupportedOperationException("Builder pattern is not supported.");
    }
}

