/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure;

import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBT;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.AdventureNBTSerializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.GsonComponentSerializerExtended;

public class AdventureSerializer {
    private static GsonComponentSerializer GSON;
    private static LegacyComponentSerializer LEGACY;
    private static AdventureNBTSerializer NBT;

    public static GsonComponentSerializer getGsonSerializer() {
        if (GSON == null) {
            ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
            GSON = new GsonComponentSerializerExtended(version.isOlderThan(ServerVersion.V_1_16) || PacketEvents.getAPI().getSettings().shouldDownsampleColors(), version.isOlderThanOrEquals(ServerVersion.V_1_12_2));
        }
        return GSON;
    }

    @Deprecated
    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        return AdventureSerializer.getLegacySerializer();
    }

    public static LegacyComponentSerializer getLegacySerializer() {
        if (LEGACY == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder();
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
                builder = builder.hexColors();
            }
            LEGACY = builder.build();
        }
        return LEGACY;
    }

    public static AdventureNBTSerializer getNBTSerializer() {
        if (NBT == null) {
            NBT = new AdventureNBTSerializer(PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16) || PacketEvents.getAPI().getSettings().shouldDownsampleColors());
        }
        return NBT;
    }

    public static String asVanilla(Component component) {
        return AdventureSerializer.getLegacySerializer().serialize(component);
    }

    public static Component fromLegacyFormat(String legacyMessage) {
        return AdventureSerializer.getLegacySerializer().deserializeOrNull(legacyMessage);
    }

    public static String toLegacyFormat(Component component) {
        return (String)AdventureSerializer.getLegacySerializer().serializeOrNull(component);
    }

    public static Component parseComponent(String json) {
        return AdventureSerializer.getGsonSerializer().deserializeOrNull(json);
    }

    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.getGsonSerializer().deserializeFromTree(json);
    }

    public static String toJson(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serializeOrNull(component);
    }

    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.getGsonSerializer().serializeToTree(component);
    }

    public static Component fromNbt(NBT nbt) {
        return AdventureSerializer.getNBTSerializer().deserialize(nbt);
    }

    public static NBT toNbt(Component component) {
        return AdventureSerializer.getNBTSerializer().serialize(component);
    }
}

