/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.MapMaker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.netty.buffer.ByteBufHelper;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.type.ParticleType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.TextureProperty;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.reflection.Reflection;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.reflection.ReflectionObject;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.Nullable;

public final class SpigotReflectionUtil {
    private static final String MODIFIED_PACKAGE_NAME;
    public static final String LEGACY_NMS_PACKAGE;
    public static final String OBC_PACKAGE;
    public static ServerVersion VERSION;
    public static boolean V_1_19_OR_HIGHER;
    public static boolean V_1_17_OR_HIGHER;
    public static boolean V_1_12_OR_HIGHER;
    public static Class<?> MINECRAFT_SERVER_CLASS;
    public static Class<?> NMS_PACKET_DATA_SERIALIZER_CLASS;
    public static Class<?> NMS_ITEM_STACK_CLASS;
    public static Class<?> NMS_IMATERIAL_CLASS;
    public static Class<?> NMS_ENTITY_CLASS;
    public static Class<?> ENTITY_PLAYER_CLASS;
    public static Class<?> BOUNDING_BOX_CLASS;
    public static Class<?> NMS_MINECRAFT_KEY_CLASS;
    public static Class<?> ENTITY_HUMAN_CLASS;
    public static Class<?> PLAYER_CONNECTION_CLASS;
    public static Class<?> SERVER_COMMON_PACKETLISTENER_IMPL_CLASS;
    public static Class<?> SERVER_CONNECTION_CLASS;
    public static Class<?> NETWORK_MANAGER_CLASS;
    public static Class<?> NMS_ENUM_PARTICLE_CLASS;
    public static Class<?> MOB_EFFECT_LIST_CLASS;
    public static Class<?> NMS_ITEM_CLASS;
    public static Class<?> DEDICATED_SERVER_CLASS;
    public static Class<?> NMS_WORLD_CLASS;
    public static Class<?> WORLD_SERVER_CLASS;
    public static Class<?> ENUM_PROTOCOL_DIRECTION_CLASS;
    public static Class<?> GAME_PROFILE_CLASS;
    public static Class<?> CRAFT_WORLD_CLASS;
    public static Class<?> CRAFT_SERVER_CLASS;
    public static Class<?> CRAFT_PLAYER_CLASS;
    public static Class<?> CRAFT_ENTITY_CLASS;
    public static Class<?> CRAFT_ITEM_STACK_CLASS;
    public static Class<?> CRAFT_PARTICLE_CLASS;
    public static Class<?> LEVEL_ENTITY_GETTER_CLASS;
    public static Class<?> PERSISTENT_ENTITY_SECTION_MANAGER_CLASS;
    public static Class<?> PAPER_ENTITY_LOOKUP_CLASS;
    public static Class<?> CRAFT_MAGIC_NUMBERS_CLASS;
    public static Class<?> IBLOCK_DATA_CLASS;
    public static Class<?> BLOCK_CLASS;
    public static Class<?> CRAFT_BLOCK_DATA_CLASS;
    public static Class<?> PROPERTY_MAP_CLASS;
    public static Class<?> DIMENSION_MANAGER_CLASS;
    public static Class<?> MOJANG_CODEC_CLASS;
    public static Class<?> MOJANG_ENCODER_CLASS;
    public static Class<?> DATA_RESULT_CLASS;
    public static Class<?> DYNAMIC_OPS_NBT_CLASS;
    public static Class<?> NMS_NBT_COMPOUND_CLASS;
    public static Class<?> NBT_COMPRESSION_STREAM_TOOLS_CLASS;
    public static Class<?> CHANNEL_CLASS;
    public static Class<?> BYTE_BUF_CLASS;
    public static Class<?> BYTE_TO_MESSAGE_DECODER;
    public static Class<?> MESSAGE_TO_BYTE_ENCODER;
    public static Field ENTITY_PLAYER_PING_FIELD;
    public static Field ENTITY_BOUNDING_BOX_FIELD;
    public static Field BYTE_BUF_IN_PACKET_DATA_SERIALIZER;
    public static Field DIMENSION_CODEC_FIELD;
    public static Field DYNAMIC_OPS_NBT_INSTANCE_FIELD;
    public static Field CRAFT_PARTICLE_PARTICLES_FIELD;
    public static Field NMS_MK_KEY_FIELD;
    public static Field LEGACY_NMS_PARTICLE_KEY_FIELD;
    public static Field LEGACY_NMS_KEY_TO_NMS_PARTICLE;
    public static Method IS_DEBUGGING;
    public static Method GET_CRAFT_PLAYER_HANDLE_METHOD;
    public static Method GET_CRAFT_ENTITY_HANDLE_METHOD;
    public static Method GET_CRAFT_WORLD_HANDLE_METHOD;
    public static Method GET_MOB_EFFECT_LIST_ID_METHOD;
    public static Method GET_MOB_EFFECT_LIST_BY_ID_METHOD;
    public static Method GET_ITEM_ID_METHOD;
    public static Method GET_ITEM_BY_ID_METHOD;
    public static Method GET_BUKKIT_ENTITY_METHOD;
    public static Method GET_LEVEL_ENTITY_GETTER_ITERABLE_METHOD;
    public static Method GET_ENTITY_BY_ID_LEVEL_ENTITY_GETTER_METHOD;
    public static Method GET_ENTITY_BY_ID_METHOD;
    public static Method CRAFT_ITEM_STACK_AS_BUKKIT_COPY;
    public static Method CRAFT_ITEM_STACK_AS_NMS_COPY;
    public static Method BUKKIT_PARTICLE_TO_NMS_ENUM_PARTICLE;
    public static Method NMS_ENUM_PARTICLE_TO_BUKKIT_PARTICLE;
    public static Method READ_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD;
    public static Method WRITE_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD;
    public static Method GET_COMBINED_ID;
    public static Method GET_BY_COMBINED_ID;
    public static Method GET_CRAFT_BLOCK_DATA_FROM_IBLOCKDATA;
    public static Method PROPERTY_MAP_GET_METHOD;
    public static Method GET_DIMENSION_MANAGER;
    public static Method GET_DIMENSION_ID;
    public static Method GET_DIMENSION_KEY;
    public static Method CODEC_ENCODE_METHOD;
    public static Method DATA_RESULT_GET_METHOD;
    public static Method READ_NBT_FROM_STREAM_METHOD;
    public static Method WRITE_NBT_TO_STREAM_METHOD;
    private static Constructor<?> NMS_ITEM_STACK_CONSTRUCTOR;
    private static Constructor<?> NMS_PACKET_DATA_SERIALIZER_CONSTRUCTOR;
    private static Constructor<?> NMS_MINECRAFT_KEY_CONSTRUCTOR;
    private static Object MINECRAFT_SERVER_INSTANCE;
    private static Object MINECRAFT_SERVER_CONNECTION_INSTANCE;
    private static boolean PAPER_ENTITY_LOOKUP_EXISTS;
    public static Map<Integer, Entity> ENTITY_ID_CACHE;

    private static void initConstructors() {
        Class<?> itemClass = NMS_IMATERIAL_CLASS != null ? NMS_IMATERIAL_CLASS : NMS_ITEM_CLASS;
        try {
            NMS_ITEM_STACK_CONSTRUCTOR = NMS_ITEM_STACK_CLASS.getConstructor(itemClass, Integer.TYPE);
            NMS_PACKET_DATA_SERIALIZER_CONSTRUCTOR = NMS_PACKET_DATA_SERIALIZER_CLASS.getConstructor(BYTE_BUF_CLASS);
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                NMS_MINECRAFT_KEY_CONSTRUCTOR = NMS_MINECRAFT_KEY_CLASS.getConstructor(String.class, String.class);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static void initMethods() {
        String entityIdMethodName;
        IS_DEBUGGING = Reflection.getMethod(MINECRAFT_SERVER_CLASS, "isDebugging", 0);
        GET_BUKKIT_ENTITY_METHOD = Reflection.getMethod(NMS_ENTITY_CLASS, CRAFT_ENTITY_CLASS, 0);
        GET_CRAFT_PLAYER_HANDLE_METHOD = Reflection.getMethod(CRAFT_PLAYER_CLASS, "getHandle", 0);
        GET_CRAFT_ENTITY_HANDLE_METHOD = Reflection.getMethod(CRAFT_ENTITY_CLASS, "getHandle", 0);
        GET_CRAFT_WORLD_HANDLE_METHOD = Reflection.getMethod(CRAFT_WORLD_CLASS, "getHandle", 0);
        GET_MOB_EFFECT_LIST_ID_METHOD = Reflection.getMethod(MOB_EFFECT_LIST_CLASS, V_1_19_OR_HIGHER ? "g" : "getId", 0);
        GET_MOB_EFFECT_LIST_BY_ID_METHOD = Reflection.getMethod(MOB_EFFECT_LIST_CLASS, V_1_19_OR_HIGHER ? "a" : "fromId", 0);
        GET_ITEM_ID_METHOD = Reflection.getMethod(NMS_ITEM_CLASS, V_1_19_OR_HIGHER ? "g" : "getId", 0);
        GET_ITEM_BY_ID_METHOD = Reflection.getMethod(NMS_ITEM_CLASS, NMS_ITEM_CLASS, 0);
        if (V_1_17_OR_HIGHER) {
            GET_LEVEL_ENTITY_GETTER_ITERABLE_METHOD = Reflection.getMethod(LEVEL_ENTITY_GETTER_CLASS, Iterable.class, 0);
            GET_ENTITY_BY_ID_LEVEL_ENTITY_GETTER_METHOD = Reflection.getMethod(LEVEL_ENTITY_GETTER_CLASS, "a", Integer.TYPE);
        }
        if (DIMENSION_MANAGER_CLASS != null) {
            if (PacketEvents.getAPI().getServerManager().getVersion() == ServerVersion.V_1_16 || PacketEvents.getAPI().getServerManager().getVersion() == ServerVersion.V_1_16_1) {
                GET_DIMENSION_KEY = Reflection.getMethod(NMS_WORLD_CLASS, "getTypeKey", 0);
            }
            GET_DIMENSION_MANAGER = Reflection.getMethod(NMS_WORLD_CLASS, DIMENSION_MANAGER_CLASS, 0);
            GET_DIMENSION_ID = Reflection.getMethod(DIMENSION_MANAGER_CLASS, Integer.TYPE, 0);
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            CODEC_ENCODE_METHOD = Reflection.getMethod(MOJANG_ENCODER_CLASS, "encodeStart", 0);
            DATA_RESULT_GET_METHOD = Reflection.getMethod(DATA_RESULT_CLASS, "result", 0);
        }
        if ((GET_ENTITY_BY_ID_METHOD = Reflection.getMethodExact(WORLD_SERVER_CLASS, entityIdMethodName = VERSION.isOlderThan(ServerVersion.V_1_9) ? "a" : (VERSION.isOlderThan(ServerVersion.V_1_17) ? "getEntity" : "b"), NMS_ENTITY_CLASS, Integer.TYPE)) == null) {
            GET_ENTITY_BY_ID_METHOD = Reflection.getMethodExact(WORLD_SERVER_CLASS, "getEntity", NMS_ENTITY_CLASS, Integer.TYPE);
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
            BUKKIT_PARTICLE_TO_NMS_ENUM_PARTICLE = Reflection.getMethod(CRAFT_PARTICLE_CLASS, "toNMS", NMS_ENUM_PARTICLE_CLASS);
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                Class<?> particleClass = Reflection.getClassByNameWithoutException("org.bukkit.Particle");
                NMS_ENUM_PARTICLE_TO_BUKKIT_PARTICLE = Reflection.getMethod(CRAFT_PARTICLE_CLASS, "toBukkit", particleClass);
            }
        }
        CRAFT_ITEM_STACK_AS_BUKKIT_COPY = Reflection.getMethod(CRAFT_ITEM_STACK_CLASS, "asBukkitCopy", 0);
        CRAFT_ITEM_STACK_AS_NMS_COPY = Reflection.getMethod(CRAFT_ITEM_STACK_CLASS, "asNMSCopy", org.bukkit.inventory.ItemStack.class);
        READ_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD = Reflection.getMethodExact(NMS_PACKET_DATA_SERIALIZER_CLASS, "k", NMS_ITEM_STACK_CLASS, new Class[0]);
        if (READ_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD == null) {
            READ_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD = Reflection.getMethod(NMS_PACKET_DATA_SERIALIZER_CLASS, NMS_ITEM_STACK_CLASS, 0);
        }
        if ((WRITE_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD = Reflection.getMethodExact(NMS_PACKET_DATA_SERIALIZER_CLASS, "a", NMS_PACKET_DATA_SERIALIZER_CLASS, NMS_ITEM_STACK_CLASS)) == null) {
            WRITE_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD = Reflection.getMethod(NMS_PACKET_DATA_SERIALIZER_CLASS, 0, NMS_ITEM_STACK_CLASS);
        }
        GET_COMBINED_ID = Reflection.getMethod(BLOCK_CLASS, IBLOCK_DATA_CLASS, 0, Integer.TYPE);
        GET_BY_COMBINED_ID = Reflection.getMethod(BLOCK_CLASS, IBLOCK_DATA_CLASS, 0, Integer.TYPE);
        if (CRAFT_BLOCK_DATA_CLASS != null) {
            GET_CRAFT_BLOCK_DATA_FROM_IBLOCKDATA = Reflection.getMethodExact(CRAFT_BLOCK_DATA_CLASS, "fromData", CRAFT_BLOCK_DATA_CLASS, IBLOCK_DATA_CLASS);
        }
        if ((READ_NBT_FROM_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, DataInputStream.class)) == null) {
            READ_NBT_FROM_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, DataInput.class);
        }
        WRITE_NBT_TO_STREAM_METHOD = Reflection.getMethod(NBT_COMPRESSION_STREAM_TOOLS_CLASS, 0, NMS_NBT_COMPOUND_CLASS, DataOutput.class);
    }

    private static void initFields() {
        ENTITY_BOUNDING_BOX_FIELD = Reflection.getField(NMS_ENTITY_CLASS, BOUNDING_BOX_CLASS, 0, true);
        ENTITY_PLAYER_PING_FIELD = Reflection.getField(ENTITY_PLAYER_CLASS, "ping");
        BYTE_BUF_IN_PACKET_DATA_SERIALIZER = Reflection.getField(NMS_PACKET_DATA_SERIALIZER_CLASS, BYTE_BUF_CLASS, 0, true);
        CRAFT_PARTICLE_PARTICLES_FIELD = Reflection.getField(CRAFT_PARTICLE_CLASS, "particles");
        NMS_MK_KEY_FIELD = Reflection.getField(NMS_MINECRAFT_KEY_CLASS, "key");
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
            LEGACY_NMS_PARTICLE_KEY_FIELD = Reflection.getField(NMS_ENUM_PARTICLE_CLASS, "X");
            LEGACY_NMS_KEY_TO_NMS_PARTICLE = Reflection.getField(NMS_ENUM_PARTICLE_CLASS, "ac");
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            DIMENSION_CODEC_FIELD = Reflection.getField(DIMENSION_MANAGER_CLASS, MOJANG_CODEC_CLASS, 0);
            DYNAMIC_OPS_NBT_INSTANCE_FIELD = Reflection.getField(DYNAMIC_OPS_NBT_CLASS, DYNAMIC_OPS_NBT_CLASS, 0);
        }
        PAPER_ENTITY_LOOKUP_EXISTS = Reflection.getField(WORLD_SERVER_CLASS, PAPER_ENTITY_LOOKUP_CLASS, 0) != null;
    }

    private static void initClasses() {
        MINECRAFT_SERVER_CLASS = SpigotReflectionUtil.getServerClass("server.MinecraftServer", "MinecraftServer");
        NMS_PACKET_DATA_SERIALIZER_CLASS = SpigotReflectionUtil.getServerClass("network.PacketDataSerializer", "PacketDataSerializer");
        NMS_ITEM_STACK_CLASS = SpigotReflectionUtil.getServerClass("world.item.ItemStack", "ItemStack");
        NMS_IMATERIAL_CLASS = SpigotReflectionUtil.getServerClass("world.level.IMaterial", "IMaterial");
        NMS_ENTITY_CLASS = SpigotReflectionUtil.getServerClass("world.entity.Entity", "Entity");
        ENTITY_PLAYER_CLASS = SpigotReflectionUtil.getServerClass("server.level.EntityPlayer", "EntityPlayer");
        BOUNDING_BOX_CLASS = SpigotReflectionUtil.getServerClass("world.phys.AxisAlignedBB", "AxisAlignedBB");
        NMS_MINECRAFT_KEY_CLASS = SpigotReflectionUtil.getServerClass("resources.MinecraftKey", "MinecraftKey");
        ENTITY_HUMAN_CLASS = SpigotReflectionUtil.getServerClass("world.entity.player.EntityHuman", "EntityHuman");
        PLAYER_CONNECTION_CLASS = SpigotReflectionUtil.getServerClass("server.network.PlayerConnection", "PlayerConnection");
        SERVER_COMMON_PACKETLISTENER_IMPL_CLASS = SpigotReflectionUtil.getServerClass("server.network.ServerCommonPacketListenerImpl", "ServerCommonPacketListenerImpl");
        SERVER_CONNECTION_CLASS = SpigotReflectionUtil.getServerClass("server.network.ServerConnection", "ServerConnection");
        NETWORK_MANAGER_CLASS = SpigotReflectionUtil.getServerClass("network.NetworkManager", "NetworkManager");
        MOB_EFFECT_LIST_CLASS = SpigotReflectionUtil.getServerClass("world.effect.MobEffectList", "MobEffectList");
        NMS_ITEM_CLASS = SpigotReflectionUtil.getServerClass("world.item.Item", "Item");
        DEDICATED_SERVER_CLASS = SpigotReflectionUtil.getServerClass("server.dedicated.DedicatedServer", "DedicatedServer");
        NMS_WORLD_CLASS = SpigotReflectionUtil.getServerClass("world.level.World", "World");
        WORLD_SERVER_CLASS = SpigotReflectionUtil.getServerClass("server.level.WorldServer", "WorldServer");
        ENUM_PROTOCOL_DIRECTION_CLASS = SpigotReflectionUtil.getServerClass("network.protocol.EnumProtocolDirection", "EnumProtocolDirection");
        if (V_1_17_OR_HIGHER) {
            LEVEL_ENTITY_GETTER_CLASS = SpigotReflectionUtil.getServerClass("world.level.entity.LevelEntityGetter", "");
            PERSISTENT_ENTITY_SECTION_MANAGER_CLASS = SpigotReflectionUtil.getServerClass("world.level.entity.PersistentEntitySectionManager", "");
            PAPER_ENTITY_LOOKUP_CLASS = Reflection.getClassByNameWithoutException("io.papermc.paper.chunk.system.entity.EntityLookup");
        }
        DIMENSION_MANAGER_CLASS = SpigotReflectionUtil.getServerClass("world.level.dimension.DimensionManager", "DimensionManager");
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            MOJANG_CODEC_CLASS = Reflection.getClassByNameWithoutException("com.mojang.serialization.Codec");
            MOJANG_ENCODER_CLASS = Reflection.getClassByNameWithoutException("com.mojang.serialization.Encoder");
            DATA_RESULT_CLASS = Reflection.getClassByNameWithoutException("com.mojang.serialization.DataResult");
            DYNAMIC_OPS_NBT_CLASS = SpigotReflectionUtil.getServerClass("nbt.DynamicOpsNBT", "DynamicOpsNBT");
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThanOrEquals(ServerVersion.V_1_12_2)) {
            NMS_ENUM_PARTICLE_CLASS = SpigotReflectionUtil.getServerClass(null, "EnumParticle");
        }
        CRAFT_MAGIC_NUMBERS_CLASS = SpigotReflectionUtil.getOBCClass("util.CraftMagicNumbers");
        IBLOCK_DATA_CLASS = SpigotReflectionUtil.getServerClass("world.level.block.state.IBlockData", "IBlockData");
        BLOCK_CLASS = SpigotReflectionUtil.getServerClass("world.level.block.Block", "Block");
        CRAFT_BLOCK_DATA_CLASS = SpigotReflectionUtil.getOBCClass("block.data.CraftBlockData");
        GAME_PROFILE_CLASS = Reflection.getClassByNameWithoutException("com.mojang.authlib.GameProfile");
        CRAFT_WORLD_CLASS = SpigotReflectionUtil.getOBCClass("CraftWorld");
        CRAFT_PLAYER_CLASS = SpigotReflectionUtil.getOBCClass("entity.CraftPlayer");
        CRAFT_SERVER_CLASS = SpigotReflectionUtil.getOBCClass("CraftServer");
        CRAFT_ENTITY_CLASS = SpigotReflectionUtil.getOBCClass("entity.CraftEntity");
        CRAFT_ITEM_STACK_CLASS = SpigotReflectionUtil.getOBCClass("inventory.CraftItemStack");
        CRAFT_PARTICLE_CLASS = SpigotReflectionUtil.getOBCClass("CraftParticle");
        CHANNEL_CLASS = SpigotReflectionUtil.getNettyClass("channel.Channel");
        BYTE_BUF_CLASS = SpigotReflectionUtil.getNettyClass("buffer.ByteBuf");
        BYTE_TO_MESSAGE_DECODER = SpigotReflectionUtil.getNettyClass("handler.codec.ByteToMessageDecoder");
        MESSAGE_TO_BYTE_ENCODER = SpigotReflectionUtil.getNettyClass("handler.codec.MessageToByteEncoder");
        NMS_NBT_COMPOUND_CLASS = SpigotReflectionUtil.getServerClass("nbt.NBTTagCompound", "NBTTagCompound");
        NBT_COMPRESSION_STREAM_TOOLS_CLASS = SpigotReflectionUtil.getServerClass("nbt.NBTCompressedStreamTools", "NBTCompressedStreamTools");
    }

    public static void init() {
        VERSION = PacketEvents.getAPI().getServerManager().getVersion();
        V_1_19_OR_HIGHER = VERSION.isNewerThanOrEquals(ServerVersion.V_1_19);
        V_1_17_OR_HIGHER = VERSION.isNewerThanOrEquals(ServerVersion.V_1_17);
        V_1_12_OR_HIGHER = VERSION.isNewerThanOrEquals(ServerVersion.V_1_12);
        SpigotReflectionUtil.initClasses();
        SpigotReflectionUtil.initFields();
        SpigotReflectionUtil.initMethods();
        SpigotReflectionUtil.initConstructors();
    }

    @Nullable
    public static Class<?> getServerClass(String modern, String legacy) {
        if (V_1_17_OR_HIGHER) {
            return Reflection.getClassByNameWithoutException("net.minecraft." + modern);
        }
        return Reflection.getClassByNameWithoutException(LEGACY_NMS_PACKAGE + legacy);
    }

    public static boolean isMinecraftServerInstanceDebugging() {
        Object minecraftServerInstance = SpigotReflectionUtil.getMinecraftServerInstance(Bukkit.getServer());
        if (minecraftServerInstance != null && IS_DEBUGGING != null) {
            try {
                return (Boolean)IS_DEBUGGING.invoke(minecraftServerInstance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                IS_DEBUGGING = null;
                return false;
            }
        }
        return false;
    }

    public static Object getMinecraftServerInstance(Server server) {
        if (MINECRAFT_SERVER_INSTANCE == null) {
            try {
                MINECRAFT_SERVER_INSTANCE = Reflection.getField(CRAFT_SERVER_CLASS, MINECRAFT_SERVER_CLASS, 0).get(server);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return MINECRAFT_SERVER_INSTANCE;
    }

    public static Object getMinecraftServerConnectionInstance() {
        if (MINECRAFT_SERVER_CONNECTION_INSTANCE == null) {
            try {
                MINECRAFT_SERVER_CONNECTION_INSTANCE = Reflection.getField(MINECRAFT_SERVER_CLASS, SERVER_CONNECTION_CLASS, 0).get(SpigotReflectionUtil.getMinecraftServerInstance(Bukkit.getServer()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return MINECRAFT_SERVER_CONNECTION_INSTANCE;
    }

    public static double getTPS() {
        return SpigotReflectionUtil.recentTPS()[0];
    }

    public static double[] recentTPS() {
        return new ReflectionObject(SpigotReflectionUtil.getMinecraftServerInstance(Bukkit.getServer()), MINECRAFT_SERVER_CLASS).readDoubleArray(0);
    }

    public static Class<?> getNMSClass(String name) throws ClassNotFoundException {
        return Class.forName(LEGACY_NMS_PACKAGE + name);
    }

    public static Class<?> getOBCClass(String name) {
        return Reflection.getClassByNameWithoutException(OBC_PACKAGE + name);
    }

    public static Class<?> getNettyClass(String name) {
        return Reflection.getClassByNameWithoutException("io.netty." + name);
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        Object craftEntity = null;
        try {
            craftEntity = GET_BUKKIT_ENTITY_METHOD.invoke(nmsEntity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return (Entity)craftEntity;
    }

    public static Object getNMSEntity(Entity entity) {
        Object craftEntity = CRAFT_ENTITY_CLASS.cast(entity);
        try {
            return GET_CRAFT_ENTITY_HANDLE_METHOD.invoke(craftEntity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getNMSAxisAlignedBoundingBox(Object nmsEntity) {
        try {
            return ENTITY_BOUNDING_BOX_FIELD.get(NMS_ENTITY_CLASS.cast(nmsEntity));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getCraftPlayer(Player player) {
        return CRAFT_PLAYER_CLASS.cast(player);
    }

    public static Object getEntityPlayer(Player player) {
        Object craftPlayer = SpigotReflectionUtil.getCraftPlayer(player);
        try {
            return GET_CRAFT_PLAYER_HANDLE_METHOD.invoke(craftPlayer, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerConnection(Player player) {
        Object entityPlayer = SpigotReflectionUtil.getEntityPlayer(player);
        if (entityPlayer == null) {
            return null;
        }
        ReflectionObject wrappedEntityPlayer = new ReflectionObject(entityPlayer, ENTITY_PLAYER_CLASS);
        return wrappedEntityPlayer.readObject(0, PLAYER_CONNECTION_CLASS);
    }

    public static Object getGameProfile(Player player) {
        Object entityPlayer = SpigotReflectionUtil.getEntityPlayer(player);
        ReflectionObject entityHumanWrapper = new ReflectionObject(entityPlayer, ENTITY_HUMAN_CLASS);
        return entityHumanWrapper.readObject(0, GAME_PROFILE_CLASS);
    }

    public static List<TextureProperty> getUserProfile(Player player) {
        if (PROPERTY_MAP_CLASS == null) {
            PROPERTY_MAP_CLASS = Reflection.getClassByNameWithoutException("com.mojang.authlib.properties.PropertyMap");
            PROPERTY_MAP_GET_METHOD = Reflection.getMethodExact(PROPERTY_MAP_CLASS, "get", Collection.class, Object.class);
        }
        Object nmsGameProfile = SpigotReflectionUtil.getGameProfile(player);
        ReflectionObject reflectGameProfile = new ReflectionObject(nmsGameProfile);
        Object nmsPropertyMap = reflectGameProfile.readObject(0, PROPERTY_MAP_CLASS);
        Collection nmsProperties = null;
        try {
            nmsProperties = (Collection)PROPERTY_MAP_GET_METHOD.invoke(nmsPropertyMap, "textures");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        ArrayList<TextureProperty> properties = new ArrayList<TextureProperty>();
        for (Object nmsProperty : nmsProperties) {
            ReflectionObject reflectProperty = new ReflectionObject(nmsProperty);
            String name = "textures";
            String value = reflectProperty.readString(1);
            String signature = reflectProperty.readString(2);
            TextureProperty textureProperty = new TextureProperty(name, value, signature);
            properties.add(textureProperty);
        }
        return properties;
    }

    public static Object getNetworkManager(Player player) {
        Object playerConnection = SpigotReflectionUtil.getPlayerConnection(player);
        if (playerConnection == null) {
            return null;
        }
        Class<?> playerConnectionClass = SERVER_COMMON_PACKETLISTENER_IMPL_CLASS != null ? SERVER_COMMON_PACKETLISTENER_IMPL_CLASS : PLAYER_CONNECTION_CLASS;
        ReflectionObject wrapper = new ReflectionObject(playerConnection, playerConnectionClass);
        try {
            return wrapper.readObject(0, NETWORK_MANAGER_CLASS);
        }
        catch (Exception ex) {
            try {
                playerConnection = wrapper.read(0, PLAYER_CONNECTION_CLASS);
                wrapper = new ReflectionObject(playerConnection, PLAYER_CONNECTION_CLASS);
                return wrapper.readObject(0, NETWORK_MANAGER_CLASS);
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static Object getChannel(Player player) {
        Object networkManager = SpigotReflectionUtil.getNetworkManager(player);
        if (networkManager == null) {
            return null;
        }
        ReflectionObject wrapper = new ReflectionObject(networkManager, NETWORK_MANAGER_CLASS);
        return wrapper.readObject(0, CHANNEL_CLASS);
    }

    @Deprecated
    public static int getPlayerPingLegacy(Player player) {
        if (V_1_17_OR_HIGHER) {
            return -1;
        }
        if (ENTITY_PLAYER_PING_FIELD != null) {
            Object entityPlayer = SpigotReflectionUtil.getEntityPlayer(player);
            try {
                return ENTITY_PLAYER_PING_FIELD.getInt(entityPlayer);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static List<Object> getNetworkManagers() {
        ReflectionObject serverConnectionWrapper = new ReflectionObject(SpigotReflectionUtil.getMinecraftServerConnectionInstance());
        int i = 0;
        while (true) {
            try {
                List list = serverConnectionWrapper.readObject(i, List.class);
                for (Object obj : list) {
                    if (!obj.getClass().isAssignableFrom(NETWORK_MANAGER_CLASS)) continue;
                    return list;
                }
            }
            catch (Exception ex) {
                break;
            }
            ++i;
        }
        return serverConnectionWrapper.readObject(1, List.class);
    }

    public static Object convertBukkitServerToNMSServer(Server server) {
        Object craftServer = CRAFT_SERVER_CLASS.cast(server);
        ReflectionObject wrapper = new ReflectionObject(craftServer);
        try {
            return wrapper.readObject(0, MINECRAFT_SERVER_CLASS);
        }
        catch (Exception ex) {
            wrapper.readObject(0, DEDICATED_SERVER_CLASS);
            return null;
        }
    }

    public static Object convertBukkitWorldToWorldServer(World world) {
        Object craftWorld = CRAFT_WORLD_CLASS.cast(world);
        try {
            return GET_CRAFT_WORLD_HANDLE_METHOD.invoke(craftWorld, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object convertWorldServerDimensionToNMSNbt(Object worldServer) {
        try {
            Object dimension = GET_DIMENSION_MANAGER.invoke(worldServer, new Object[0]);
            Object dynamicNbtOps = DYNAMIC_OPS_NBT_INSTANCE_FIELD.get(null);
            Object dataResult = CODEC_ENCODE_METHOD.invoke(DIMENSION_CODEC_FIELD.get(null), dynamicNbtOps, dimension);
            Optional optional = (Optional)DATA_RESULT_GET_METHOD.invoke(dataResult, new Object[0]);
            return optional.orElse(null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDimensionId(Object worldServer) {
        try {
            Object dimension = GET_DIMENSION_MANAGER.invoke(worldServer, new Object[0]);
            return (Integer)GET_DIMENSION_ID.invoke(dimension, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getDimensionKey(Object worldServer) {
        try {
            return GET_DIMENSION_KEY.invoke(worldServer, new Object[0]).toString();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String fromStringToJSON(String message) {
        if (message == null) {
            return null;
        }
        return "{\"text\": \"" + message + "\"}";
    }

    public static int generateEntityId() {
        Field field = Reflection.getField(NMS_ENTITY_CLASS, "entityCount");
        if (field == null) {
            field = Reflection.getField(NMS_ENTITY_CLASS, AtomicInteger.class, 0);
        }
        try {
            if (field.getType().equals(AtomicInteger.class)) {
                AtomicInteger atomicInteger = (AtomicInteger)field.get(null);
                return atomicInteger.incrementAndGet();
            }
            int id = field.getInt(null) + 1;
            field.set(null, id);
            return id;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to generate a new unique entity ID!");
        }
    }

    public static int getEffectId(Object nmsMobEffectList) {
        try {
            return (Integer)GET_MOB_EFFECT_LIST_ID_METHOD.invoke(null, nmsMobEffectList);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object getMobEffectListById(int effectID) {
        try {
            return GET_MOB_EFFECT_LIST_BY_ID_METHOD.invoke(null, effectID);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNMSItemId(Object nmsItem) {
        try {
            return (Integer)GET_ITEM_ID_METHOD.invoke(null, nmsItem);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object getNMSItemById(int id) {
        try {
            return GET_ITEM_BY_ID_METHOD.invoke(null, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createNMSItemStack(Object nmsItem, int count) {
        try {
            return NMS_ITEM_STACK_CONSTRUCTOR.newInstance(nmsItem, count);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemStack decodeBukkitItemStack(org.bukkit.inventory.ItemStack in) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        Object packetDataSerializer = SpigotReflectionUtil.createPacketDataSerializer(buffer);
        Object nmsItemStack = SpigotReflectionUtil.toNMSItemStack(in);
        SpigotReflectionUtil.writeNMSItemStackPacketDataSerializer(packetDataSerializer, nmsItemStack);
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        ItemStack stack = wrapper.readItemStack();
        ByteBufHelper.release(buffer);
        return stack;
    }

    public static org.bukkit.inventory.ItemStack encodeBukkitItemStack(ItemStack in) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        wrapper.writeItemStack(in);
        Object packetDataSerializer = SpigotReflectionUtil.createPacketDataSerializer(wrapper.getBuffer());
        Object nmsItemStack = SpigotReflectionUtil.readNMSItemStackPacketDataSerializer(packetDataSerializer);
        org.bukkit.inventory.ItemStack stack = SpigotReflectionUtil.toBukkitItemStack(nmsItemStack);
        ByteBufHelper.release(buffer);
        return stack;
    }

    public static int getBlockDataCombinedId(MaterialData materialData) {
        if (PacketEvents.getAPI().getServerManager().getVersion() == ServerVersion.V_1_7_10) {
            throw new IllegalStateException("This operation is not supported yet on 1.7.10!");
        }
        int combinedID = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? -1 : materialData.getItemType().getId() << 4 | materialData.getData();
        return combinedID;
    }

    public static MaterialData getBlockDataByCombinedId(int combinedID) {
        if (PacketEvents.getAPI().getServerManager().getVersion() == ServerVersion.V_1_7_10) {
            throw new IllegalStateException("This operation is not supported yet on 1.7.10!");
        }
        return null;
    }

    public static Object createNMSItemStack(int itemID, int count) {
        try {
            Object nmsItem = SpigotReflectionUtil.getNMSItemById(itemID);
            return NMS_ITEM_STACK_CONSTRUCTOR.newInstance(nmsItem, count);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createPacketDataSerializer(Object byteBuf) {
        try {
            return NMS_PACKET_DATA_SERIALIZER_CONSTRUCTOR.newInstance(byteBuf);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static org.bukkit.inventory.ItemStack toBukkitItemStack(Object nmsItemStack) {
        try {
            return (org.bukkit.inventory.ItemStack)CRAFT_ITEM_STACK_AS_BUKKIT_COPY.invoke(null, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object toNMSItemStack(org.bukkit.inventory.ItemStack itemStack) {
        try {
            return CRAFT_ITEM_STACK_AS_NMS_COPY.invoke(null, itemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object readNMSItemStackPacketDataSerializer(Object packetDataSerializer) {
        try {
            return READ_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD.invoke(packetDataSerializer, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object writeNMSItemStackPacketDataSerializer(Object packetDataSerializer, Object nmsItemStack) {
        try {
            return WRITE_ITEM_STACK_IN_PACKET_DATA_SERIALIZER_METHOD.invoke(packetDataSerializer, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NBTCompound fromMinecraftNBT(Object nbtCompound) {
        byte[] bytes;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             DataOutputStream stream = new DataOutputStream(byteStream);){
            SpigotReflectionUtil.writeNmsNbtToStream(nbtCompound, stream);
            bytes = byteStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Object buffer = UnpooledByteBufAllocationHelper.wrappedBuffer(bytes);
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        NBTCompound nbt = wrapper.readNBT();
        ByteBufHelper.release(buffer);
        return nbt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object toMinecraftNBT(NBTCompound nbtCompound) {
        Object buffer = UnpooledByteBufAllocationHelper.buffer();
        PacketWrapper<?> wrapper = PacketWrapper.createUniversalPacketWrapper(buffer);
        wrapper.writeNBT(nbtCompound);
        byte[] bytes = ByteBufHelper.copyBytes(buffer);
        ByteBufHelper.release(buffer);
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);){
            Object object;
            try (DataInputStream stream = new DataInputStream(byteStream);){
                object = SpigotReflectionUtil.readNmsNbtFromStream(stream);
            }
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNmsNbtToStream(Object compound, DataOutput out) {
        try {
            WRITE_NBT_TO_STREAM_METHOD.invoke(null, compound, out);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Object readNmsNbtFromStream(DataInputStream in) {
        try {
            return READ_NBT_FROM_STREAM_METHOD.invoke(null, in);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Entity getEntityByIdWithWorldUnsafe(World world, int id) {
        if (world == null) {
            return null;
        }
        Entity e = ENTITY_ID_CACHE.getOrDefault(id, null);
        if (e != null) {
            return e;
        }
        try {
            Object nmsEntity;
            Object worldServer = GET_CRAFT_WORLD_HANDLE_METHOD.invoke((Object)world, new Object[0]);
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17)) {
                Object levelEntityGetter;
                ReflectionObject reflectWorldServer = new ReflectionObject(worldServer);
                if (PAPER_ENTITY_LOOKUP_EXISTS) {
                    levelEntityGetter = reflectWorldServer.readObject(0, PAPER_ENTITY_LOOKUP_CLASS);
                } else {
                    Object entitySectionManager = reflectWorldServer.readObject(0, PERSISTENT_ENTITY_SECTION_MANAGER_CLASS);
                    ReflectionObject reflectEntitySectionManager = new ReflectionObject(entitySectionManager);
                    levelEntityGetter = reflectEntitySectionManager.readObject(0, LEVEL_ENTITY_GETTER_CLASS);
                }
                nmsEntity = GET_ENTITY_BY_ID_LEVEL_ENTITY_GETTER_METHOD.invoke(levelEntityGetter, id);
            } else {
                nmsEntity = GET_ENTITY_BY_ID_METHOD.invoke(worldServer, id);
            }
            if (nmsEntity == null) {
                return null;
            }
            e = SpigotReflectionUtil.getBukkitEntity(nmsEntity);
            ENTITY_ID_CACHE.put(id, e);
            return e;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static Entity getEntityById(@Nullable World origin, int id) {
        Entity e;
        if (origin != null && (e = SpigotReflectionUtil.getEntityByIdWithWorldUnsafe(origin, id)) != null) {
            return e;
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = SpigotReflectionUtil.getEntityByIdWithWorldUnsafe(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Entity getEntityById(int entityID) {
        return SpigotReflectionUtil.getEntityById(null, entityID);
    }

    public static List<Entity> getEntityList(World world) {
        if (V_1_17_OR_HIGHER) {
            Object levelEntityGetter;
            Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
            ReflectionObject wrappedWorldServer = new ReflectionObject(worldServer);
            if (PAPER_ENTITY_LOOKUP_EXISTS) {
                levelEntityGetter = wrappedWorldServer.readObject(0, PAPER_ENTITY_LOOKUP_CLASS);
            } else {
                Object persistentEntitySectionManager = wrappedWorldServer.readObject(0, PERSISTENT_ENTITY_SECTION_MANAGER_CLASS);
                ReflectionObject wrappedPersistentEntitySectionManager = new ReflectionObject(persistentEntitySectionManager);
                levelEntityGetter = wrappedPersistentEntitySectionManager.readObject(0, LEVEL_ENTITY_GETTER_CLASS);
            }
            Iterable nmsEntitiesIterable = null;
            try {
                nmsEntitiesIterable = (Iterable)GET_LEVEL_ENTITY_GETTER_ITERABLE_METHOD.invoke(levelEntityGetter, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            if (nmsEntitiesIterable != null) {
                for (Object nmsEntity : nmsEntitiesIterable) {
                    Entity bukkitEntity = SpigotReflectionUtil.getBukkitEntity(nmsEntity);
                    entityList.add(bukkitEntity);
                }
            }
            return entityList;
        }
        return world.getEntities();
    }

    public static ParticleType toPacketEventsParticle(Enum<?> particle) {
        try {
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                BiMap map = (BiMap)CRAFT_PARTICLE_PARTICLES_FIELD.get(null);
                if (particle.name().equals("BLOCK_DUST")) {
                    particle = Enum.valueOf(particle.getClass(), "BLOCK_CRACK");
                }
                Object minecraftKey = map.get(particle);
                return ParticleTypes.getByName(minecraftKey.toString());
            }
            Object nmsParticle = BUKKIT_PARTICLE_TO_NMS_ENUM_PARTICLE.invoke(null, particle);
            String key = (String)LEGACY_NMS_PARTICLE_KEY_FIELD.get(nmsParticle);
            Object minecraftKey = NMS_MINECRAFT_KEY_CONSTRUCTOR.newInstance("minecraft", key);
            return ParticleTypes.getByName(minecraftKey.toString());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Enum<?> fromPacketEventsParticle(ParticleType particle) {
        try {
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
                BiMap map = (BiMap)CRAFT_PARTICLE_PARTICLES_FIELD.get(null);
                Object minecraftKey = NMS_MINECRAFT_KEY_CONSTRUCTOR.newInstance(particle.getName().getNamespace(), particle.getName().getKey());
                Object bukkitParticle = map.inverse().get(minecraftKey);
                return (Enum)bukkitParticle;
            }
            Map keyToParticleMap = (Map)LEGACY_NMS_KEY_TO_NMS_PARTICLE.get(null);
            Object enumParticle = keyToParticleMap.get(particle.getName().getKey());
            Object bukkitParticle = NMS_ENUM_PARTICLE_TO_BUKKIT_PARTICLE.invoke(null, enumParticle);
            return (Enum)bukkitParticle;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        String temp;
        try {
            temp = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (Exception ex) {
            temp = "";
        }
        MODIFIED_PACKAGE_NAME = temp;
        LEGACY_NMS_PACKAGE = "net.minecraft.server." + MODIFIED_PACKAGE_NAME + ".";
        OBC_PACKAGE = "org.bukkit.craftbukkit." + MODIFIED_PACKAGE_NAME + ".";
        PAPER_ENTITY_LOOKUP_EXISTS = false;
        ENTITY_ID_CACHE = new MapMaker().weakValues().makeMap();
    }
}

