/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util;

import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.entity.type.EntityTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.type.ItemType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.type.ParticleType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.GameMode;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.potion.PotionType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.potion.PotionTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.Dimension;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.Location;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.SpigotReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class SpigotConversionUtil {
    public static Location fromBukkitLocation(org.bukkit.Location location) {
        return new Location(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static org.bukkit.Location toBukkitLocation(World world, Location location) {
        return new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static PotionType fromBukkitPotionEffectType(PotionEffectType potionEffectType) {
        return PotionTypes.getById(potionEffectType.getId(), PacketEvents.getAPI().getServerManager().getVersion());
    }

    public static PotionEffectType toBukkitPotionEffectType(PotionType potionType) {
        return PotionEffectType.getById((int)potionType.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
    }

    public static GameMode fromBukkitGameMode(org.bukkit.GameMode gameMode) {
        return GameMode.getById(gameMode.getValue());
    }

    public static org.bukkit.GameMode toBukkitGameMode(GameMode gameMode) {
        return org.bukkit.GameMode.getByValue((int)gameMode.getId());
    }

    public static WrappedBlockState fromBukkitBlockData(BlockData blockData) {
        String string = blockData.getAsString(false);
        return WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), string);
    }

    public static BlockData toBukkitBlockData(WrappedBlockState blockState) {
        return Bukkit.createBlockData((String)blockState.toString());
    }

    public static me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.entity.type.EntityType fromBukkitEntityType(EntityType entityType) {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            return EntityTypes.getByName(entityType.getKey().toString());
        }
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return EntityTypes.getByName("minecraft:" + entityType.getName());
        }
        if (entityType.getTypeId() == -1) {
            return null;
        }
        return EntityTypes.getById(serverVersion.toClientVersion(), entityType.getTypeId());
    }

    public static EntityType toBukkitEntityType(me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.entity.type.EntityType entityType) {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return EntityType.fromName((String)entityType.getName().getKey());
        }
        return EntityType.fromId((int)entityType.getId(serverVersion.toClientVersion()));
    }

    public static ItemType fromBukkitItemMaterial(Material material) {
        ItemStack bukkitStack = new ItemStack(material);
        me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack stack = SpigotConversionUtil.fromBukkitItemStack(bukkitStack);
        return stack.getType();
    }

    public static Material toBukkitItemMaterial(ItemType itemType) {
        me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack stack = me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack.builder().type(itemType).build();
        ItemStack bukkitStack = SpigotConversionUtil.toBukkitItemStack(stack);
        return bukkitStack.getType();
    }

    public static WrappedBlockState fromBukkitMaterialData(MaterialData materialData) {
        int combinedID = SpigotReflectionUtil.getBlockDataCombinedId(materialData);
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        return WrappedBlockState.getByGlobalId(serverVersion.toClientVersion(), combinedID);
    }

    public static MaterialData toBukkitMaterialData(WrappedBlockState state) {
        return SpigotReflectionUtil.getBlockDataByCombinedId(state.getGlobalId());
    }

    public static me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack fromBukkitItemStack(ItemStack itemStack) {
        return SpigotReflectionUtil.decodeBukkitItemStack(itemStack);
    }

    public static ItemStack toBukkitItemStack(me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack itemStack) {
        return SpigotReflectionUtil.encodeBukkitItemStack(itemStack);
    }

    public static Dimension fromBukkitWorld(World world) {
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_14)) {
            return new Dimension(world.getEnvironment().getId());
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16)) {
            Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
            return new Dimension(SpigotReflectionUtil.getDimensionId(worldServer));
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16_2)) {
            Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
            Dimension dimension = new Dimension(new NBTCompound());
            dimension.setDimensionName(SpigotReflectionUtil.getDimensionKey(worldServer));
            return dimension;
        }
        Object worldServer = SpigotReflectionUtil.convertBukkitWorldToWorldServer(world);
        Object nbt = SpigotReflectionUtil.convertWorldServerDimensionToNMSNbt(worldServer);
        return new Dimension(SpigotReflectionUtil.fromMinecraftNBT(nbt));
    }

    public static ParticleType fromBukkitParticle(Enum<?> particle) {
        return SpigotReflectionUtil.toPacketEventsParticle(particle);
    }

    public static Enum<?> toBukkitParticle(ParticleType particle) {
        return SpigotReflectionUtil.fromPacketEventsParticle(particle);
    }

    public static Entity getEntityById(@Nullable World world, int entityId) {
        return SpigotReflectionUtil.getEntityById(world, entityId);
    }
}

