/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util;

import java.util.logging.Level;
import java.util.regex.Pattern;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.format.NamedTextColor;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import org.jetbrains.annotations.Nullable;

public class LogManager {
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");

    protected void log(Level level, @Nullable NamedTextColor color, String message) {
        message = STRIP_COLOR_PATTERN.matcher(message).replaceAll("");
        PacketEvents.getAPI().getLogger().log(level, color != null ? color.toString() : "" + message);
    }

    public void info(String message) {
        this.log(Level.INFO, null, message);
    }

    public void warn(String message) {
        this.log(Level.WARNING, null, message);
    }

    public void severe(String message) {
        this.log(Level.SEVERE, null, message);
    }

    public void debug(String message) {
        if (PacketEvents.getAPI().getSettings().isDebugEnabled()) {
            this.log(Level.FINE, null, message);
        }
    }
}

