/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk;

import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.ShortArray3d;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.impl.v1_16.Chunk_v1_9;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.impl.v1_7.Chunk_v1_7;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.impl.v1_8.Chunk_v1_8;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.palette.DataPalette;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.palette.ListPalette;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.palette.PaletteType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.chunk.storage.LegacyFlexibleStorage;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.states.WrappedBlockState;

public interface BaseChunk {
    public int getBlockId(int var1, int var2, int var3);

    default public WrappedBlockState get(ClientVersion version, int x, int y, int z) {
        return this.get(version, x, y, z, true);
    }

    default public WrappedBlockState get(ClientVersion version, int x, int y, int z, boolean clone) {
        return WrappedBlockState.getByGlobalId(version, this.getBlockId(x, y, z), clone);
    }

    default public WrappedBlockState get(int x, int y, int z) {
        return this.get(x, y, z, true);
    }

    default public WrappedBlockState get(int x, int y, int z, boolean clone) {
        return this.get(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), x, y, z, clone);
    }

    default public void set(int x, int y, int z, WrappedBlockState state) {
        this.set(x, y, z, state.getGlobalId());
    }

    public void set(int var1, int var2, int var3, int var4);

    default public void set(ClientVersion version, int x, int y, int z, int combinedID) {
        this.set(x, y, z, combinedID);
    }

    public boolean isEmpty();

    public static BaseChunk create() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return new Chunk_v1_18();
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return new Chunk_v1_9(0, DataPalette.createForChunk());
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return new Chunk_v1_9(0, new DataPalette(new ListPalette(4), new LegacyFlexibleStorage(4, 4096), PaletteType.CHUNK));
        }
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_8)) {
            return new Chunk_v1_8(new ShortArray3d(4096), null, null);
        }
        return new Chunk_v1_7(false, true);
    }
}

