/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.stats;

import java.util.HashMap;
import java.util.Map;
import me.onlyjordon.swiftdisguise.libs.gson.JsonElement;
import me.onlyjordon.swiftdisguise.libs.gson.JsonObject;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.stats.Statistic;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.MappingHelper;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.adventure.AdventureSerializer;

public class Statistics {
    private static final Map<String, Statistic> STATISTIC_MAP = new HashMap<String, Statistic>();

    public static Statistic getById(String id) {
        return STATISTIC_MAP.get(id);
    }

    static {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isOlderThan(ServerVersion.V_1_12_2)) {
            JsonObject mapping = MappingHelper.getJSONObject("stats/statistics");
            mapping = version.isOlderThanOrEquals(ServerVersion.V_1_8_3) ? mapping.getAsJsonObject("V_1_8") : mapping.getAsJsonObject("V_1_12");
            for (final Map.Entry<String, JsonElement> entry : mapping.entrySet()) {
                final Component value = AdventureSerializer.parseComponent(entry.getValue().getAsString());
                Statistic statistic = new Statistic(){

                    @Override
                    public String getId() {
                        return (String)entry.getKey();
                    }

                    @Override
                    public Component display() {
                        return value;
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof Statistic) {
                            return ((Statistic)obj).getId().equals(this.getId());
                        }
                        return false;
                    }
                };
                STATISTIC_MAP.put(entry.getKey(), statistic);
            }
        }
    }
}

