/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data;

import java.util.Optional;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.mapper.MappedEntity;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.resources.ResourceLocation;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.Vector3i;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class ParticleVibrationData
extends ParticleData {
    private Vector3i startingPosition;
    private PositionType type;
    @Nullable
    private Vector3i blockPosition;
    @Nullable
    private Integer entityId;
    @Nullable
    private Float entityEyeHeight;
    private int ticks;

    public ParticleVibrationData(Vector3i startingPosition, @Nullable Vector3i blockPosition, int ticks) {
        this.startingPosition = startingPosition;
        this.type = PositionType.BLOCK;
        this.blockPosition = blockPosition;
        this.entityId = null;
        this.ticks = ticks;
    }

    public ParticleVibrationData(Vector3i startingPosition, int entityId, int ticks) {
        this.startingPosition = startingPosition;
        this.type = PositionType.ENTITY;
        this.blockPosition = null;
        this.entityId = entityId;
        this.entityEyeHeight = null;
        this.ticks = ticks;
    }

    public ParticleVibrationData(Vector3i startingPosition, int entityId, float entityEyeHeight, int ticks) {
        this.startingPosition = startingPosition;
        this.type = PositionType.ENTITY;
        this.blockPosition = null;
        this.entityId = entityId;
        this.entityEyeHeight = Float.valueOf(entityEyeHeight);
        this.ticks = ticks;
    }

    public Vector3i getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(Vector3i startingPosition) {
        this.startingPosition = startingPosition;
    }

    public PositionType getType() {
        return this.type;
    }

    public Optional<Vector3i> getBlockPosition() {
        return Optional.ofNullable(this.blockPosition);
    }

    public void setBlockPosition(@Nullable Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public Optional<Integer> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public Optional<Float> getEntityEyeHeight() {
        return Optional.ofNullable(this.entityEyeHeight);
    }

    public void setEntityEyeHeight(@Nullable Float entityEyeHeight) {
        this.entityEyeHeight = entityEyeHeight;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public static ParticleVibrationData read(PacketWrapper<?> wrapper) {
        PositionType positionType;
        Vector3i startingPos;
        Vector3i vector3i = startingPos = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4) ? Vector3i.zero() : wrapper.readBlockPosition();
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            positionType = PositionType.getById(wrapper.readVarInt());
        } else {
            String positionTypeName = wrapper.readString();
            positionType = PositionType.getByName(positionTypeName);
            if (positionType == null) {
                throw new IllegalArgumentException("Unknown position type: " + positionTypeName);
            }
        }
        switch (positionType) {
            case BLOCK: {
                return new ParticleVibrationData(startingPos, wrapper.readBlockPosition(), wrapper.readVarInt());
            }
            case ENTITY: {
                if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
                    return new ParticleVibrationData(startingPos, wrapper.readVarInt(), wrapper.readFloat(), wrapper.readVarInt());
                }
                return new ParticleVibrationData(startingPos, wrapper.readVarInt(), wrapper.readVarInt());
            }
        }
        throw new IllegalArgumentException("Illegal position type: " + positionType);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleVibrationData data) {
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_19_4)) {
            wrapper.writeBlockPosition(data.getStartingPosition());
        }
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            wrapper.writeVarInt(data.getType().getId(wrapper.getServerVersion().toClientVersion()));
        } else {
            wrapper.writeIdentifier(data.getType().getName());
        }
        if (data.getType() == PositionType.BLOCK) {
            wrapper.writeBlockPosition(data.getBlockPosition().get());
        } else if (data.getType() == PositionType.ENTITY) {
            wrapper.writeVarInt(data.getEntityId().get());
            if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
                wrapper.writeFloat(data.getEntityEyeHeight().orElse(Float.valueOf(0.0f)).floatValue());
            }
        }
        wrapper.writeVarInt(data.getTicks());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static enum PositionType implements MappedEntity
    {
        BLOCK(new ResourceLocation("minecraft:block")),
        ENTITY(new ResourceLocation("minecraft:entity"));

        private final ResourceLocation name;

        private PositionType(ResourceLocation name) {
            this.name = name;
        }

        @Override
        public ResourceLocation getName() {
            return this.name;
        }

        public static PositionType getById(int id) {
            switch (id) {
                case 0: {
                    return BLOCK;
                }
                case 1: {
                    return ENTITY;
                }
            }
            throw new IllegalArgumentException("Illegal position type id: " + id);
        }

        @Nullable
        public static PositionType getByName(String name) {
            return PositionType.getByName(new ResourceLocation(name));
        }

        @Nullable
        public static PositionType getByName(ResourceLocation name) {
            for (PositionType type : PositionType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        @Override
        public int getId(ClientVersion version) {
            return this.ordinal();
        }
    }
}

