/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data;

import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.ItemStack;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.type.ItemTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.LegacyConvertible;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.LegacyParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;

public class ParticleItemStackData
extends ParticleData
implements LegacyConvertible {
    private ItemStack itemStack;

    public ParticleItemStackData(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ParticleItemStackData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return new ParticleItemStackData(wrapper.readItemStack());
        }
        return new ParticleItemStackData(ItemStack.builder().type(ItemTypes.getById(wrapper.getClientVersion(), wrapper.readVarInt())).build());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleItemStackData data) {
        wrapper.writeItemStack(data.getItemStack());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofTwo(this.itemStack.getType().getId(version), this.itemStack.getLegacyData());
    }
}

