/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data;

import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.LegacyConvertible;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.LegacyParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;

public class ParticleBlockStateData
extends ParticleData
implements LegacyConvertible {
    private WrappedBlockState blockState;

    public ParticleBlockStateData(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public WrappedBlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public static ParticleBlockStateData read(PacketWrapper<?> wrapper) {
        int blockID = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9) ? wrapper.readVarInt() : (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? wrapper.readInt() : wrapper.readVarInt());
        return new ParticleBlockStateData(WrappedBlockState.getByGlobalId(wrapper.getServerVersion().toClientVersion(), blockID));
    }

    public static void write(PacketWrapper<?> wrapper, ParticleBlockStateData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            wrapper.writeVarInt(data.getBlockState().getGlobalId());
        } else {
            wrapper.writeInt(data.getBlockState().getGlobalId());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofOne(this.blockState.getGlobalId());
    }
}

