/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.enchantment.Enchantment;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.type.ItemType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.item.type.ItemTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTInt;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTList;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTShort;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTString;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import org.jetbrains.annotations.Nullable;

public class ItemStack {
    public static final ItemStack EMPTY = new ItemStack(ItemTypes.AIR, 0, new NBTCompound(), 0);
    private final ItemType type;
    private int amount;
    @Nullable
    private NBTCompound nbt;
    private int legacyData = -1;
    private boolean cachedIsEmpty = false;

    private ItemStack(ItemType type, int amount, @Nullable NBTCompound nbt, int legacyData) {
        this.type = type;
        this.amount = amount;
        this.nbt = nbt;
        this.legacyData = legacyData;
        this.updateCachedEmptyStatus();
    }

    public int getMaxStackSize() {
        return this.getType().getMaxAmount();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        if (!this.cachedIsEmpty && this.getType().getMaxDurability() > 0) {
            NBTCompound tag = this.getNBT();
            return tag == null || !tag.getBoolean("Unbreakable");
        }
        return false;
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        if (this.nbt == null) {
            return 0;
        }
        NBTInt damage = this.nbt.getTagOfTypeOrNull("Damage", NBTInt.class);
        return damage == null ? 0 : damage.getAsInt();
    }

    public void setDamageValue(int damage) {
        this.getOrCreateTag().setTag("Damage", new NBTInt(Math.max(0, damage)));
    }

    public int getMaxDamage() {
        return this.getType().getMaxDurability();
    }

    public NBTCompound getOrCreateTag() {
        if (this.nbt == null) {
            this.nbt = new NBTCompound();
        }
        return this.nbt;
    }

    private void updateCachedEmptyStatus() {
        this.cachedIsEmpty = this.isEmpty();
    }

    public ItemType getType() {
        return this.cachedIsEmpty ? ItemTypes.AIR : this.type;
    }

    public int getAmount() {
        return this.cachedIsEmpty ? 0 : this.amount;
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public void grow(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.updateCachedEmptyStatus();
    }

    public ItemStack split(int toTake) {
        int i = Math.min(toTake, this.getAmount());
        ItemStack itemstack = this.copy();
        itemstack.setAmount(i);
        this.shrink(i);
        return itemstack;
    }

    public ItemStack copy() {
        return this.cachedIsEmpty ? EMPTY : new ItemStack(this.type, this.amount, this.nbt == null ? null : this.nbt.copy(), this.legacyData);
    }

    @Nullable
    public NBTCompound getNBT() {
        return this.nbt;
    }

    public void setNBT(NBTCompound nbt) {
        this.nbt = nbt;
    }

    public int getLegacyData() {
        return this.legacyData;
    }

    public void setLegacyData(int legacyData) {
        this.legacyData = legacyData;
    }

    public boolean isEnchantable(ClientVersion version) {
        if (this.getType() == ItemTypes.BOOK) {
            return this.getAmount() == 1;
        }
        if (this.getType() == ItemTypes.ENCHANTED_BOOK) {
            return false;
        }
        return this.getMaxStackSize() == 1 && this.canBeDepleted() && !this.isEnchanted(version);
    }

    public boolean isEnchanted(ClientVersion version) {
        String tagName = this.getEnchantmentsTagName(version);
        return !this.isEmpty() && this.nbt != null && this.nbt.getCompoundListTagOrNull(tagName) != null && !this.nbt.getCompoundListTagOrNull(tagName).getTags().isEmpty();
    }

    private List<Enchantment> getEnchantments(@Nullable NBTCompound nbt, ClientVersion version) {
        String tagName = this.getEnchantmentsTagName(version);
        if (nbt == null || nbt.getCompoundListTagOrNull(tagName) == null) {
            return new ArrayList<Enchantment>(0);
        }
        NBTList<NBTCompound> nbtList = nbt.getCompoundListTagOrNull(tagName);
        List<NBTCompound> compounds = nbtList.getTags();
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(compounds.size());
        for (NBTCompound compound : compounds) {
            EnchantmentType type = ItemStack.getEnchantmentTypeFromTag(compound, version);
            if (type == null) continue;
            NBTShort levelTag = compound.getTagOfTypeOrNull("lvl", NBTShort.class);
            int level = levelTag.getAsInt();
            Enchantment enchantment = Enchantment.builder().type(type).level(level).build();
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    public List<Enchantment> getEnchantments(ClientVersion version) {
        return this.getEnchantments(this.nbt, version);
    }

    public int getEnchantmentLevel(EnchantmentType enchantment, ClientVersion version) {
        if (this.isEnchanted(version)) {
            assert (this.nbt != null);
            String tagName = this.getEnchantmentsTagName(version);
            for (NBTCompound base : this.nbt.getCompoundListTagOrNull(tagName).getTags()) {
                EnchantmentType type = ItemStack.getEnchantmentTypeFromTag(base, version);
                if (enchantment != type) continue;
                NBTShort nbtShort = base.getTagOfTypeOrNull("lvl", NBTShort.class);
                if (nbtShort == null) {
                    return 0;
                }
                return nbtShort.getAsInt();
            }
        }
        return 0;
    }

    @Nullable
    private static EnchantmentType getEnchantmentTypeFromTag(NBTCompound tag, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_13)) {
            String id = tag.getStringTagValueOrNull("id");
            return EnchantmentTypes.getByName(id);
        }
        NBTShort idTag = tag.getTagOfTypeOrNull("id", NBTShort.class);
        return EnchantmentTypes.getById(version, idTag.getAsInt());
    }

    public void setEnchantments(List<Enchantment> enchantments, ClientVersion version) {
        this.nbt = this.getOrCreateTag();
        String tagName = this.getEnchantmentsTagName(version);
        if (enchantments.isEmpty()) {
            if (this.nbt.getTagOrNull(tagName) != null) {
                this.nbt.removeTag(tagName);
            }
        } else {
            ArrayList<NBTCompound> list = new ArrayList<NBTCompound>();
            for (Enchantment enchantment : enchantments) {
                NBTCompound compound = new NBTCompound();
                if (version.isNewerThanOrEquals(ClientVersion.V_1_13)) {
                    compound.setTag("id", new NBTString(enchantment.getType().getName().toString()));
                } else {
                    compound.setTag("id", new NBTShort((short)enchantment.getType().getId(version)));
                }
                compound.setTag("lvl", new NBTShort((short)enchantment.getLevel()));
                list.add(compound);
            }
            assert (this.nbt != null);
            this.nbt.setTag(tagName, new NBTList<NBTCompound>(NBTType.COMPOUND, list));
        }
    }

    public String getEnchantmentsTagName(ClientVersion version) {
        String tagName;
        String string = tagName = version.isNewerThanOrEquals(ClientVersion.V_1_13) ? "Enchantments" : "ench";
        if (this.type == ItemTypes.ENCHANTED_BOOK) {
            tagName = "StoredEnchantments";
        }
        return tagName;
    }

    public boolean canBeDepleted() {
        return this.getType().getMaxDurability() > 0;
    }

    public boolean is(ItemType type) {
        return this.getType() == type;
    }

    public static boolean isSameItemSameTags(ItemStack stack, ItemStack otherStack) {
        return stack.is(otherStack.getType()) && ItemStack.tagMatches(stack, otherStack);
    }

    public static boolean tagMatches(ItemStack left, ItemStack right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right.isEmpty();
        }
        if (right == null) {
            return left.isEmpty();
        }
        return Objects.equals(left.nbt, right.nbt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return this.getType().equals(itemStack.getType()) && this.amount == itemStack.amount && Objects.equals(this.nbt, itemStack.nbt) && this.legacyData == itemStack.legacyData;
        }
        return false;
    }

    public String toString() {
        if (this.cachedIsEmpty) {
            return "ItemStack[null]";
        }
        String identifier = this.type == null ? "null" : this.type.getName().toString();
        int maxAmount = this.getType().getMaxAmount();
        return "ItemStack[type=" + identifier + ", amount=" + this.amount + "/" + maxAmount + ", nbt tag names: " + (this.nbt != null ? this.nbt.getTagNames() : "[null]") + ", legacyData=" + this.legacyData + "]";
    }

    public boolean isEmpty() {
        return this.type == null || this.type == ItemTypes.AIR || this.amount <= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ItemType type;
        private int amount = 1;
        private NBTCompound nbt = null;
        private int legacyData = -1;

        public Builder type(ItemType type) {
            this.type = type;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder nbt(NBTCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder legacyData(int legacyData) {
            this.legacyData = legacyData;
            return this;
        }

        public ItemStack build() {
            return new ItemStack(this.type, this.amount, this.nbt, this.legacyData);
        }
    }
}

