/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.entity.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.entity.type.EntityType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.resources.ResourceLocation;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.TypesBuilder;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.TypesBuilderData;
import org.jetbrains.annotations.Nullable;

public class EntityTypes {
    private static final Map<String, EntityType> ENTITY_TYPE_MAP = new HashMap<String, EntityType>();
    private static final Map<Byte, Map<Integer, EntityType>> ENTITY_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, EntityType>>();
    private static final Map<Byte, Map<Integer, EntityType>> LEGACY_ENTITY_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, EntityType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("entity/entity_type_mappings", ClientVersion.V_1_10, ClientVersion.V_1_11, ClientVersion.V_1_12, ClientVersion.V_1_13, ClientVersion.V_1_14, ClientVersion.V_1_15, ClientVersion.V_1_16, ClientVersion.V_1_16_2, ClientVersion.V_1_17, ClientVersion.V_1_19, ClientVersion.V_1_19_3, ClientVersion.V_1_19_4, ClientVersion.V_1_20_3);
    private static final TypesBuilder LEGACY_TYPES_BUILDER = new TypesBuilder("entity/legacy_entity_type_mappings", ClientVersion.V_1_8, ClientVersion.V_1_9, ClientVersion.V_1_10, ClientVersion.V_1_11, ClientVersion.V_1_12, ClientVersion.V_1_13);
    public static final EntityType ENTITY;
    public static final EntityType LIVINGENTITY;
    public static final EntityType ABSTRACT_INSENTIENT;
    public static final EntityType ABSTRACT_CREATURE;
    public static final EntityType ABSTRACT_AGEABLE;
    public static final EntityType ABSTRACT_ANIMAL;
    public static final EntityType ABSTRACT_TAMEABLE_ANIMAL;
    public static final EntityType ABSTRACT_PARROT;
    public static final EntityType ABSTRACT_HORSE;
    public static final EntityType CHESTED_HORSE;
    public static final EntityType ABSTRACT_GOLEM;
    public static final EntityType ABSTRACT_FISHES;
    public static final EntityType ABSTRACT_MONSTER;
    public static final EntityType ABSTRACT_PIGLIN;
    public static final EntityType ABSTRACT_ILLAGER_BASE;
    public static final EntityType ABSTRACT_EVO_ILLU_ILLAGER;
    public static final EntityType ABSTRACT_SKELETON;
    public static final EntityType ABSTRACT_FLYING;
    public static final EntityType ABSTRACT_AMBIENT;
    public static final EntityType ABSTRACT_WATERMOB;
    public static final EntityType ABSTRACT_HANGING;
    public static final EntityType ABSTRACT_LIGHTNING;
    public static final EntityType ABSTRACT_ARROW;
    public static final EntityType ABSTRACT_FIREBALL;
    public static final EntityType PROJECTILE_ABSTRACT;
    public static final EntityType MINECART_ABSTRACT;
    public static final EntityType CHESTED_MINECART_ABSTRACT;
    public static final EntityType AREA_EFFECT_CLOUD;
    public static final EntityType ARMOR_STAND;
    public static final EntityType ALLAY;
    public static final EntityType ARROW;
    public static final EntityType AXOLOTL;
    public static final EntityType BAT;
    public static final EntityType BEE;
    public static final EntityType BLAZE;
    public static final EntityType BOAT;
    public static final EntityType CHEST_BOAT;
    public static final EntityType CAT;
    public static final EntityType CAMEL;
    public static final EntityType SPIDER;
    public static final EntityType CAVE_SPIDER;
    public static final EntityType CHICKEN;
    public static final EntityType COD;
    public static final EntityType COW;
    public static final EntityType CREEPER;
    public static final EntityType DOLPHIN;
    public static final EntityType DONKEY;
    public static final EntityType DRAGON_FIREBALL;
    public static final EntityType ZOMBIE;
    public static final EntityType DROWNED;
    public static final EntityType GUARDIAN;
    public static final EntityType ELDER_GUARDIAN;
    public static final EntityType END_CRYSTAL;
    public static final EntityType ENDER_DRAGON;
    public static final EntityType ENDERMAN;
    public static final EntityType ENDERMITE;
    public static final EntityType EVOKER;
    public static final EntityType EVOKER_FANGS;
    public static final EntityType EXPERIENCE_ORB;
    public static final EntityType EYE_OF_ENDER;
    public static final EntityType FALLING_BLOCK;
    public static final EntityType FIREWORK_ROCKET;
    public static final EntityType FOX;
    public static final EntityType FROG;
    public static final EntityType GHAST;
    public static final EntityType GIANT;
    public static final EntityType ITEM_FRAME;
    public static final EntityType GLOW_ITEM_FRAME;
    public static final EntityType SQUID;
    public static final EntityType GLOW_SQUID;
    public static final EntityType GOAT;
    public static final EntityType HOGLIN;
    public static final EntityType HORSE;
    public static final EntityType HUSK;
    public static final EntityType ILLUSIONER;
    public static final EntityType IRON_GOLEM;
    public static final EntityType ITEM;
    public static final EntityType FIREBALL;
    public static final EntityType LEASH_KNOT;
    public static final EntityType LIGHTNING_BOLT;
    public static final EntityType LLAMA;
    public static final EntityType LLAMA_SPIT;
    public static final EntityType SLIME;
    public static final EntityType MAGMA_CUBE;
    public static final EntityType MARKER;
    public static final EntityType MINECART;
    public static final EntityType CHEST_MINECART;
    public static final EntityType COMMAND_BLOCK_MINECART;
    public static final EntityType FURNACE_MINECART;
    public static final EntityType HOPPER_MINECART;
    public static final EntityType SPAWNER_MINECART;
    public static final EntityType TNT_MINECART;
    public static final EntityType MULE;
    public static final EntityType MOOSHROOM;
    public static final EntityType OCELOT;
    public static final EntityType PAINTING;
    public static final EntityType PANDA;
    public static final EntityType PARROT;
    public static final EntityType PHANTOM;
    public static final EntityType PIG;
    public static final EntityType PIGLIN;
    public static final EntityType PIGLIN_BRUTE;
    public static final EntityType PILLAGER;
    public static final EntityType POLAR_BEAR;
    public static final EntityType TNT;
    public static final EntityType PUFFERFISH;
    public static final EntityType RABBIT;
    public static final EntityType RAVAGER;
    public static final EntityType SALMON;
    public static final EntityType SHEEP;
    public static final EntityType SHULKER;
    public static final EntityType SHULKER_BULLET;
    public static final EntityType SILVERFISH;
    public static final EntityType SKELETON;
    public static final EntityType SKELETON_HORSE;
    public static final EntityType SMALL_FIREBALL;
    public static final EntityType SNOW_GOLEM;
    public static final EntityType SNOWBALL;
    public static final EntityType SPECTRAL_ARROW;
    public static final EntityType STRAY;
    public static final EntityType STRIDER;
    public static final EntityType EGG;
    public static final EntityType ENDER_PEARL;
    public static final EntityType EXPERIENCE_BOTTLE;
    public static final EntityType POTION;
    public static final EntityType TADPOLE;
    @Deprecated
    public static final EntityType TIPPED_ARROW;
    public static final EntityType TRIDENT;
    public static final EntityType TRADER_LLAMA;
    public static final EntityType TROPICAL_FISH;
    public static final EntityType TURTLE;
    public static final EntityType VEX;
    public static final EntityType VILLAGER;
    public static final EntityType VINDICATOR;
    public static final EntityType WANDERING_TRADER;
    public static final EntityType WARDEN;
    public static final EntityType WITCH;
    public static final EntityType WITHER;
    public static final EntityType WITHER_SKELETON;
    public static final EntityType WITHER_SKULL;
    public static final EntityType WOLF;
    public static final EntityType ZOGLIN;
    public static final EntityType ZOMBIE_HORSE;
    public static final EntityType ZOMBIE_VILLAGER;
    public static final EntityType ZOMBIFIED_PIGLIN;
    public static final EntityType PLAYER;
    public static final EntityType FISHING_BOBBER;
    public static final EntityType ENDER_SIGNAL;
    public static final EntityType THROWN_EXP_BOTTLE;
    public static final EntityType PRIMED_TNT;
    public static final EntityType FIREWORK;
    public static final EntityType MINECART_COMMAND;
    public static final EntityType MINECART_RIDEABLE;
    public static final EntityType MINECART_CHEST;
    public static final EntityType MINECART_FURNACE;
    public static final EntityType MINECART_TNT;
    public static final EntityType MINECART_HOPPER;
    public static final EntityType MINECART_MOB_SPAWNER;
    public static final EntityType DISPLAY;
    public static final EntityType BLOCK_DISPLAY;
    public static final EntityType ITEM_DISPLAY;
    public static final EntityType TEXT_DISPLAY;
    public static final EntityType INTERACTION;
    public static final EntityType SNIFFER;
    public static final EntityType BREEZE;
    public static final EntityType WIND_CHARGE;

    public static EntityType define(String key, @Nullable EntityType parent) {
        int index;
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        final TypesBuilderData legacyData = LEGACY_TYPES_BUILDER.define(key);
        final Optional<EntityType> optParent = Optional.ofNullable(parent);
        EntityType entityType = new EntityType(){
            private final int[] ids;
            private final int[] legacyIds;
            {
                this.ids = data.getData();
                this.legacyIds = legacyData.getData();
            }

            @Override
            public Optional<EntityType> getParent() {
                return optParent;
            }

            @Override
            public int getLegacyId(ClientVersion version) {
                if (version.isNewerThanOrEquals(ClientVersion.V_1_14)) {
                    return -1;
                }
                int index = LEGACY_TYPES_BUILDER.getDataIndex(version);
                return this.legacyIds[index];
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                int index = TYPES_BUILDER.getDataIndex(version);
                return this.ids[index];
            }
        };
        ENTITY_TYPE_MAP.put(entityType.getName().toString(), entityType);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            index = TYPES_BUILDER.getDataIndex(version);
            Map typeIdMap = ENTITY_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            typeIdMap.put(entityType.getId(version), entityType);
        }
        for (ClientVersion version : LEGACY_TYPES_BUILDER.getVersions()) {
            index = LEGACY_TYPES_BUILDER.getDataIndex(version);
            Map legacyTypeIdMap = LEGACY_ENTITY_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            legacyTypeIdMap.put(entityType.getLegacyId(version), entityType);
        }
        return entityType;
    }

    public static boolean isTypeInstanceOf(EntityType type, EntityType parent) {
        while (type != null) {
            if (type == parent) {
                return true;
            }
            if (type.getParent().isPresent()) {
                type = type.getParent().get();
                continue;
            }
            return false;
        }
        return false;
    }

    public static EntityType getByName(String name) {
        return ENTITY_TYPE_MAP.get(name);
    }

    public static EntityType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        return ENTITY_TYPE_ID_MAP.get((byte)index).get(id);
    }

    public static EntityType getByLegacyId(ClientVersion version, int id) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_14)) {
            return null;
        }
        int index = LEGACY_TYPES_BUILDER.getDataIndex(version);
        return LEGACY_ENTITY_TYPE_ID_MAP.get((byte)index).get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
        LEGACY_TYPES_BUILDER.unloadFileMappings();
        ENTITY = EntityTypes.define("entity", null);
        LIVINGENTITY = EntityTypes.define("livingentity", ENTITY);
        ABSTRACT_INSENTIENT = EntityTypes.define("abstract_insentient", LIVINGENTITY);
        ABSTRACT_CREATURE = EntityTypes.define("abstract_creature", ABSTRACT_INSENTIENT);
        ABSTRACT_AGEABLE = EntityTypes.define("abstract_ageable", ABSTRACT_CREATURE);
        ABSTRACT_ANIMAL = EntityTypes.define("abstract_animal", ABSTRACT_AGEABLE);
        ABSTRACT_TAMEABLE_ANIMAL = EntityTypes.define("abstract_tameable_animal", ABSTRACT_ANIMAL);
        ABSTRACT_PARROT = EntityTypes.define("abstract_parrot", ABSTRACT_TAMEABLE_ANIMAL);
        ABSTRACT_HORSE = EntityTypes.define("abstract_horse", ABSTRACT_ANIMAL);
        CHESTED_HORSE = EntityTypes.define("chested_horse", ABSTRACT_HORSE);
        ABSTRACT_GOLEM = EntityTypes.define("abstract_golem", ABSTRACT_CREATURE);
        ABSTRACT_FISHES = EntityTypes.define("abstract_fishes", ABSTRACT_CREATURE);
        ABSTRACT_MONSTER = EntityTypes.define("abstract_monster", ABSTRACT_CREATURE);
        ABSTRACT_PIGLIN = EntityTypes.define("abstract_piglin", ABSTRACT_MONSTER);
        ABSTRACT_ILLAGER_BASE = EntityTypes.define("abstract_illager_base", ABSTRACT_MONSTER);
        ABSTRACT_EVO_ILLU_ILLAGER = EntityTypes.define("abstract_evo_illu_illager", ABSTRACT_ILLAGER_BASE);
        ABSTRACT_SKELETON = EntityTypes.define("abstract_skeleton", ABSTRACT_MONSTER);
        ABSTRACT_FLYING = EntityTypes.define("abstract_flying", ABSTRACT_INSENTIENT);
        ABSTRACT_AMBIENT = EntityTypes.define("abstract_ambient", ABSTRACT_INSENTIENT);
        ABSTRACT_WATERMOB = EntityTypes.define("abstract_watermob", ABSTRACT_INSENTIENT);
        ABSTRACT_HANGING = EntityTypes.define("abstract_hanging", ENTITY);
        ABSTRACT_LIGHTNING = EntityTypes.define("abstract_lightning", ENTITY);
        ABSTRACT_ARROW = EntityTypes.define("abstract_arrow", ENTITY);
        ABSTRACT_FIREBALL = EntityTypes.define("abstract_fireball", ENTITY);
        PROJECTILE_ABSTRACT = EntityTypes.define("projectile_abstract", ENTITY);
        MINECART_ABSTRACT = EntityTypes.define("minecart_abstract", ENTITY);
        CHESTED_MINECART_ABSTRACT = EntityTypes.define("chested_minecart_abstract", MINECART_ABSTRACT);
        AREA_EFFECT_CLOUD = EntityTypes.define("area_effect_cloud", ENTITY);
        ARMOR_STAND = EntityTypes.define("armor_stand", LIVINGENTITY);
        ALLAY = EntityTypes.define("allay", ABSTRACT_CREATURE);
        ARROW = EntityTypes.define("arrow", ABSTRACT_ARROW);
        AXOLOTL = EntityTypes.define("axolotl", ABSTRACT_ANIMAL);
        BAT = EntityTypes.define("bat", ABSTRACT_AMBIENT);
        BEE = EntityTypes.define("bee", ABSTRACT_INSENTIENT);
        BLAZE = EntityTypes.define("blaze", ABSTRACT_MONSTER);
        BOAT = EntityTypes.define("boat", ENTITY);
        CHEST_BOAT = EntityTypes.define("chest_boat", BOAT);
        CAT = EntityTypes.define("cat", ABSTRACT_TAMEABLE_ANIMAL);
        CAMEL = EntityTypes.define("camel", ABSTRACT_HORSE);
        SPIDER = EntityTypes.define("spider", ABSTRACT_MONSTER);
        CAVE_SPIDER = EntityTypes.define("cave_spider", SPIDER);
        CHICKEN = EntityTypes.define("chicken", ABSTRACT_ANIMAL);
        COD = EntityTypes.define("cod", ABSTRACT_FISHES);
        COW = EntityTypes.define("cow", ABSTRACT_ANIMAL);
        CREEPER = EntityTypes.define("creeper", ABSTRACT_MONSTER);
        DOLPHIN = EntityTypes.define("dolphin", ABSTRACT_INSENTIENT);
        DONKEY = EntityTypes.define("donkey", CHESTED_HORSE);
        DRAGON_FIREBALL = EntityTypes.define("dragon_fireball", ABSTRACT_FIREBALL);
        ZOMBIE = EntityTypes.define("zombie", ABSTRACT_MONSTER);
        DROWNED = EntityTypes.define("drowned", ZOMBIE);
        GUARDIAN = EntityTypes.define("guardian", ABSTRACT_MONSTER);
        ELDER_GUARDIAN = EntityTypes.define("elder_guardian", GUARDIAN);
        END_CRYSTAL = EntityTypes.define("end_crystal", ENTITY);
        ENDER_DRAGON = EntityTypes.define("ender_dragon", ABSTRACT_INSENTIENT);
        ENDERMAN = EntityTypes.define("enderman", ABSTRACT_MONSTER);
        ENDERMITE = EntityTypes.define("endermite", ABSTRACT_MONSTER);
        EVOKER = EntityTypes.define("evoker", ABSTRACT_EVO_ILLU_ILLAGER);
        EVOKER_FANGS = EntityTypes.define("evoker_fangs", ENTITY);
        EXPERIENCE_ORB = EntityTypes.define("experience_orb", ENTITY);
        EYE_OF_ENDER = EntityTypes.define("eye_of_ender", ENTITY);
        FALLING_BLOCK = EntityTypes.define("falling_block", ENTITY);
        FIREWORK_ROCKET = EntityTypes.define("firework_rocket", ENTITY);
        FOX = EntityTypes.define("fox", ABSTRACT_ANIMAL);
        FROG = EntityTypes.define("frog", ABSTRACT_ANIMAL);
        GHAST = EntityTypes.define("ghast", ABSTRACT_FLYING);
        GIANT = EntityTypes.define("giant", ABSTRACT_MONSTER);
        ITEM_FRAME = EntityTypes.define("item_frame", ABSTRACT_HANGING);
        GLOW_ITEM_FRAME = EntityTypes.define("glow_item_frame", ITEM_FRAME);
        SQUID = EntityTypes.define("squid", ABSTRACT_WATERMOB);
        GLOW_SQUID = EntityTypes.define("glow_squid", SQUID);
        GOAT = EntityTypes.define("goat", ABSTRACT_ANIMAL);
        HOGLIN = EntityTypes.define("hoglin", ABSTRACT_ANIMAL);
        HORSE = EntityTypes.define("horse", ABSTRACT_HORSE);
        HUSK = EntityTypes.define("husk", ZOMBIE);
        ILLUSIONER = EntityTypes.define("illusioner", ABSTRACT_EVO_ILLU_ILLAGER);
        IRON_GOLEM = EntityTypes.define("iron_golem", ABSTRACT_GOLEM);
        ITEM = EntityTypes.define("item", ENTITY);
        FIREBALL = EntityTypes.define("fireball", ABSTRACT_FIREBALL);
        LEASH_KNOT = EntityTypes.define("leash_knot", ABSTRACT_HANGING);
        LIGHTNING_BOLT = EntityTypes.define("lightning_bolt", ABSTRACT_LIGHTNING);
        LLAMA = EntityTypes.define("llama", CHESTED_HORSE);
        LLAMA_SPIT = EntityTypes.define("llama_spit", ENTITY);
        SLIME = EntityTypes.define("slime", ABSTRACT_INSENTIENT);
        MAGMA_CUBE = EntityTypes.define("magma_cube", SLIME);
        MARKER = EntityTypes.define("marker", ENTITY);
        MINECART = EntityTypes.define("minecart", MINECART_ABSTRACT);
        CHEST_MINECART = EntityTypes.define("chest_minecart", CHESTED_MINECART_ABSTRACT);
        COMMAND_BLOCK_MINECART = EntityTypes.define("command_block_minecart", MINECART_ABSTRACT);
        FURNACE_MINECART = EntityTypes.define("furnace_minecart", MINECART_ABSTRACT);
        HOPPER_MINECART = EntityTypes.define("hopper_minecart", CHESTED_MINECART_ABSTRACT);
        SPAWNER_MINECART = EntityTypes.define("spawner_minecart", MINECART_ABSTRACT);
        TNT_MINECART = EntityTypes.define("tnt_minecart", MINECART_ABSTRACT);
        MULE = EntityTypes.define("mule", CHESTED_HORSE);
        MOOSHROOM = EntityTypes.define("mooshroom", COW);
        OCELOT = EntityTypes.define("ocelot", ABSTRACT_TAMEABLE_ANIMAL);
        PAINTING = EntityTypes.define("painting", ABSTRACT_HANGING);
        PANDA = EntityTypes.define("panda", ABSTRACT_INSENTIENT);
        PARROT = EntityTypes.define("parrot", ABSTRACT_PARROT);
        PHANTOM = EntityTypes.define("phantom", ABSTRACT_FLYING);
        PIG = EntityTypes.define("pig", ABSTRACT_ANIMAL);
        PIGLIN = EntityTypes.define("piglin", ABSTRACT_PIGLIN);
        PIGLIN_BRUTE = EntityTypes.define("piglin_brute", ABSTRACT_PIGLIN);
        PILLAGER = EntityTypes.define("pillager", ABSTRACT_ILLAGER_BASE);
        POLAR_BEAR = EntityTypes.define("polar_bear", ABSTRACT_ANIMAL);
        TNT = EntityTypes.define("tnt", ENTITY);
        PUFFERFISH = EntityTypes.define("pufferfish", ABSTRACT_FISHES);
        RABBIT = EntityTypes.define("rabbit", ABSTRACT_ANIMAL);
        RAVAGER = EntityTypes.define("ravager", ABSTRACT_MONSTER);
        SALMON = EntityTypes.define("salmon", ABSTRACT_FISHES);
        SHEEP = EntityTypes.define("sheep", ABSTRACT_ANIMAL);
        SHULKER = EntityTypes.define("shulker", ABSTRACT_GOLEM);
        SHULKER_BULLET = EntityTypes.define("shulker_bullet", ENTITY);
        SILVERFISH = EntityTypes.define("silverfish", ABSTRACT_MONSTER);
        SKELETON = EntityTypes.define("skeleton", ABSTRACT_SKELETON);
        SKELETON_HORSE = EntityTypes.define("skeleton_horse", ABSTRACT_HORSE);
        SMALL_FIREBALL = EntityTypes.define("small_fireball", ABSTRACT_FIREBALL);
        SNOW_GOLEM = EntityTypes.define("snow_golem", ABSTRACT_GOLEM);
        SNOWBALL = EntityTypes.define("snowball", PROJECTILE_ABSTRACT);
        SPECTRAL_ARROW = EntityTypes.define("spectral_arrow", ABSTRACT_ARROW);
        STRAY = EntityTypes.define("stray", ABSTRACT_SKELETON);
        STRIDER = EntityTypes.define("strider", ABSTRACT_ANIMAL);
        EGG = EntityTypes.define("egg", PROJECTILE_ABSTRACT);
        ENDER_PEARL = EntityTypes.define("ender_pearl", PROJECTILE_ABSTRACT);
        EXPERIENCE_BOTTLE = EntityTypes.define("experience_bottle", PROJECTILE_ABSTRACT);
        POTION = EntityTypes.define("potion", PROJECTILE_ABSTRACT);
        TADPOLE = EntityTypes.define("tadpole", ABSTRACT_FISHES);
        TIPPED_ARROW = EntityTypes.define("tipped_arrow", ARROW);
        TRIDENT = EntityTypes.define("trident", ABSTRACT_ARROW);
        TRADER_LLAMA = EntityTypes.define("trader_llama", CHESTED_HORSE);
        TROPICAL_FISH = EntityTypes.define("tropical_fish", ABSTRACT_FISHES);
        TURTLE = EntityTypes.define("turtle", ABSTRACT_ANIMAL);
        VEX = EntityTypes.define("vex", ABSTRACT_MONSTER);
        VILLAGER = EntityTypes.define("villager", ABSTRACT_AGEABLE);
        VINDICATOR = EntityTypes.define("vindicator", ABSTRACT_ILLAGER_BASE);
        WANDERING_TRADER = EntityTypes.define("wandering_trader", ABSTRACT_AGEABLE);
        WARDEN = EntityTypes.define("warden", ABSTRACT_MONSTER);
        WITCH = EntityTypes.define("witch", ABSTRACT_MONSTER);
        WITHER = EntityTypes.define("wither", ABSTRACT_MONSTER);
        WITHER_SKELETON = EntityTypes.define("wither_skeleton", ABSTRACT_SKELETON);
        WITHER_SKULL = EntityTypes.define("wither_skull", ABSTRACT_FIREBALL);
        WOLF = EntityTypes.define("wolf", ABSTRACT_TAMEABLE_ANIMAL);
        ZOGLIN = EntityTypes.define("zoglin", ABSTRACT_MONSTER);
        ZOMBIE_HORSE = EntityTypes.define("zombie_horse", ABSTRACT_HORSE);
        ZOMBIE_VILLAGER = EntityTypes.define("zombie_villager", ZOMBIE);
        ZOMBIFIED_PIGLIN = EntityTypes.define("zombified_piglin", ZOMBIE);
        PLAYER = EntityTypes.define("player", LIVINGENTITY);
        FISHING_BOBBER = EntityTypes.define("fishing_bobber", ENTITY);
        ENDER_SIGNAL = EntityTypes.define("ender_signal", ENTITY);
        THROWN_EXP_BOTTLE = EntityTypes.define("thrown_exp_bottle", PROJECTILE_ABSTRACT);
        PRIMED_TNT = EntityTypes.define("primed_tnt", ENTITY);
        FIREWORK = EntityTypes.define("firework", ENTITY);
        MINECART_COMMAND = EntityTypes.define("minecart_command", MINECART_ABSTRACT);
        MINECART_RIDEABLE = EntityTypes.define("minecart_rideable", MINECART_ABSTRACT);
        MINECART_CHEST = EntityTypes.define("minecart_chest", MINECART_ABSTRACT);
        MINECART_FURNACE = EntityTypes.define("minecart_furnace", MINECART_ABSTRACT);
        MINECART_TNT = EntityTypes.define("minecart_tnt", MINECART_ABSTRACT);
        MINECART_HOPPER = EntityTypes.define("minecart_hopper", MINECART_ABSTRACT);
        MINECART_MOB_SPAWNER = EntityTypes.define("minecart_mob_spawner", MINECART_ABSTRACT);
        DISPLAY = EntityTypes.define("display", ENTITY);
        BLOCK_DISPLAY = EntityTypes.define("block_display", DISPLAY);
        ITEM_DISPLAY = EntityTypes.define("item_display", DISPLAY);
        TEXT_DISPLAY = EntityTypes.define("text_display", DISPLAY);
        INTERACTION = EntityTypes.define("interaction", DISPLAY);
        SNIFFER = EntityTypes.define("sniffer", ABSTRACT_ANIMAL);
        BREEZE = EntityTypes.define("breeze", ABSTRACT_MONSTER);
        WIND_CHARGE = EntityTypes.define("wind_charge", PROJECTILE_ABSTRACT);
    }
}

