/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.message.reader.impl;

import java.time.Instant;
import java.util.UUID;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.ChatType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.ChatTypes;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.message.ChatMessage;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat.message.reader.ChatMessageProcessor;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatMessageProcessor_v1_19
implements ChatMessageProcessor {
    @Override
    public ChatMessage readChatMessage(@NotNull PacketWrapper<?> wrapper) {
        Component chatContent = wrapper.readComponent();
        Component unsignedChatContent = (Component)wrapper.readOptional(PacketWrapper::readComponent);
        int id = wrapper.readVarInt();
        ChatType type = ChatTypes.getById(wrapper.getServerVersion().toClientVersion(), id);
        UUID senderUUID = wrapper.readUUID();
        Component senderDisplayName = wrapper.readComponent();
        @Nullable Component teamName = (Component)wrapper.readOptional(PacketWrapper::readComponent);
        Instant timestamp = wrapper.readTimestamp();
        long salt = wrapper.readLong();
        byte[] signature = wrapper.readByteArray();
        return new ChatMessage_v1_19(chatContent, unsignedChatContent, type, senderUUID, senderDisplayName, teamName, timestamp, salt, signature);
    }

    @Override
    public void writeChatMessage(@NotNull PacketWrapper<?> wrapper, @NotNull ChatMessage data) {
        ChatMessage_v1_19 newData = (ChatMessage_v1_19)data;
        wrapper.writeComponent(newData.getChatContent());
        wrapper.writeOptional(newData.getUnsignedChatContent(), PacketWrapper::writeComponent);
        wrapper.writeVarInt(newData.getType().getId(wrapper.getServerVersion().toClientVersion()));
        wrapper.writeUUID(newData.getSenderUUID());
        wrapper.writeComponent(newData.getSenderDisplayName());
        wrapper.writeOptional(newData.getTeamName(), PacketWrapper::writeComponent);
        wrapper.writeTimestamp(newData.getTimestamp());
        wrapper.writeLong(newData.getSalt());
        wrapper.writeByteArray(newData.getSignature());
    }
}

