/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.chat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.resources.ResourceLocation;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public class Parsers {
    private static final List<Parser> parsers = Arrays.asList(new Parser("brigadier:bool", null, null), new Parser("brigadier:float", packetWrapper -> {
        byte flags = packetWrapper.readByte();
        float min2 = (flags & 1) != 0 ? packetWrapper.readFloat() : -3.4028235E38f;
        float max = (flags & 2) != 0 ? packetWrapper.readFloat() : Float.MAX_VALUE;
        return Arrays.asList(flags, Float.valueOf(min2), Float.valueOf(max));
    }, (packetWrapper, properties) -> {
        byte flags = (Byte)properties.get(0);
        packetWrapper.writeByte(flags);
        if ((flags & 1) != 0) {
            packetWrapper.writeFloat(((Float)properties.get(1)).floatValue());
        }
        if ((flags & 2) != 0) {
            packetWrapper.writeFloat(((Float)properties.get(2)).floatValue());
        }
    }), new Parser("brigadier:double", packetWrapper -> {
        byte flags = packetWrapper.readByte();
        double min2 = (flags & 1) != 0 ? packetWrapper.readDouble() : -1.7976931348623157E308;
        double max = (flags & 2) != 0 ? packetWrapper.readDouble() : Double.MAX_VALUE;
        return Arrays.asList(flags, min2, max);
    }, (packetWrapper, properties) -> {
        byte flags = (Byte)properties.get(0);
        packetWrapper.writeByte(flags);
        if ((flags & 1) != 0) {
            packetWrapper.writeDouble((Double)properties.get(1));
        }
        if ((flags & 2) != 0) {
            packetWrapper.writeDouble((Double)properties.get(2));
        }
    }), new Parser("brigadier:integer", packetWrapper -> {
        byte flags = packetWrapper.readByte();
        int min2 = (flags & 1) != 0 ? packetWrapper.readInt() : Integer.MIN_VALUE;
        int max = (flags & 2) != 0 ? packetWrapper.readInt() : Integer.MAX_VALUE;
        return Arrays.asList(flags, min2, max);
    }, (packetWrapper, properties) -> {
        byte flags = (Byte)properties.get(0);
        packetWrapper.writeByte(flags);
        if ((flags & 1) != 0) {
            packetWrapper.writeInt((Integer)properties.get(1));
        }
        if ((flags & 2) != 0) {
            packetWrapper.writeInt((Integer)properties.get(2));
        }
    }), new Parser("brigadier:long", packetWrapper -> {
        byte flags = packetWrapper.readByte();
        long min2 = (flags & 1) != 0 ? packetWrapper.readLong() : Long.MIN_VALUE;
        long max = (flags & 2) != 0 ? packetWrapper.readLong() : Long.MAX_VALUE;
        return Arrays.asList(flags, min2, max);
    }, (packetWrapper, properties) -> {
        byte flags = (Byte)properties.get(0);
        packetWrapper.writeByte(flags);
        if ((flags & 1) != 0) {
            packetWrapper.writeLong((Long)properties.get(1));
        }
        if ((flags & 2) != 0) {
            packetWrapper.writeLong((Long)properties.get(2));
        }
    }), new Parser("brigadier:string", packetWrapper -> Collections.singletonList(packetWrapper.readVarInt()), (packetWrapper, properties) -> packetWrapper.writeVarInt((Integer)properties.get(0))), new Parser("minecraft:entity", packetWrapper -> Collections.singletonList(packetWrapper.readByte()), (packetWrapper, properties) -> packetWrapper.writeByte(((Byte)properties.get(0)).intValue())), new Parser("minecraft:game_profile", null, null), new Parser("minecraft:block_pos", null, null), new Parser("minecraft:column_pos", null, null), new Parser("minecraft:vec3", null, null), new Parser("minecraft:vec2", null, null), new Parser("minecraft:block_state", null, null), new Parser("minecraft:block_predicate", null, null), new Parser("minecraft:item_stack", null, null), new Parser("minecraft:item_predicate", null, null), new Parser("minecraft:color", null, null), new Parser("minecraft:component", null, null), new Parser("minecraft:style", null, null), new Parser("minecraft:message", null, null), new Parser("minecraft:nbt", null, null), new Parser("minecraft:nbt_tag", null, null), new Parser("minecraft:nbt_path", null, null), new Parser("minecraft:objective", null, null), new Parser("minecraft:objective_criteria", null, null), new Parser("minecraft:operation", null, null), new Parser("minecraft:particle", null, null), new Parser("minecraft:angle", null, null), new Parser("minecraft:rotation", null, null), new Parser("minecraft:scoreboard_slot", null, null), new Parser("minecraft:score_holder", packetWrapper -> Collections.singletonList(packetWrapper.readByte()), (packetWrapper, properties) -> packetWrapper.writeByte(((Byte)properties.get(0)).intValue())), new Parser("minecraft:swizzle", null, null), new Parser("minecraft:team", null, null), new Parser("minecraft:item_slot", null, null), new Parser("minecraft:resource_location", null, null), new Parser("minecraft:function", null, null), new Parser("minecraft:entity_anchor", null, null), new Parser("minecraft:int_range", null, null), new Parser("minecraft:float_range", null, null), new Parser("minecraft:dimension", null, null), new Parser("minecraft:gamemode", null, null), new Parser("minecraft:time", packetWrapper -> Collections.singletonList(packetWrapper.readInt()), (packetWrapper, properties) -> packetWrapper.writeInt((Integer)properties.get(0))), new Parser("minecraft:resource_or_tag", packetWrapper -> Collections.singletonList(packetWrapper.readIdentifier()), (packetWrapper, properties) -> packetWrapper.writeIdentifier((ResourceLocation)properties.get(0))), new Parser("minecraft:resource_or_tag_key", packetWrapper -> Collections.singletonList(packetWrapper.readIdentifier()), (packetWrapper, properties) -> packetWrapper.writeIdentifier((ResourceLocation)properties.get(0))), new Parser("minecraft:resource", packetWrapper -> Collections.singletonList(packetWrapper.readIdentifier()), (packetWrapper, properties) -> packetWrapper.writeIdentifier((ResourceLocation)properties.get(0))), new Parser("minecraft:resource_key", packetWrapper -> Collections.singletonList(packetWrapper.readIdentifier()), (packetWrapper, properties) -> packetWrapper.writeIdentifier((ResourceLocation)properties.get(0))), new Parser("minecraft:template_mirror", null, null), new Parser("minecraft:template_rotation", null, null), new Parser("minecraft:heightmap", null, null), new Parser("minecraft:uuid", null, null));

    public static List<Parser> getParsers() {
        return parsers;
    }

    public static final class Parser {
        private final String name;
        private final Optional<Function<PacketWrapper<?>, List<Object>>> read;
        private final Optional<BiConsumer<PacketWrapper<?>, List<Object>>> write;

        public Parser(String name, @Nullable Function<PacketWrapper<?>, List<Object>> read, @Nullable BiConsumer<PacketWrapper<?>, List<Object>> write) {
            this.name = name;
            this.read = Optional.ofNullable(read);
            this.write = Optional.ofNullable(write);
        }

        public Optional<List<Object>> readProperties(PacketWrapper<?> packetWrapper) {
            return this.read.map(fn -> (List)fn.apply(packetWrapper));
        }

        public void writeProperties(PacketWrapper<?> packetWrapper, List<Object> properties) {
            this.write.ifPresent(fn -> fn.accept(packetWrapper, properties));
        }
    }
}

