/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager;

import java.net.InetSocketAddress;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListenerAbstract;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListenerPriority;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketReceiveEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketSendEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.protocol.ProtocolManager;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.server.ServerVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.ConnectionState;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.nbt.NBTList;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.packettype.PacketType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.User;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.UserProfile;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRespawn;

public class InternalPacketListener
extends PacketListenerAbstract {
    public InternalPacketListener() {
        this(PacketListenerPriority.LOWEST);
    }

    public InternalPacketListener(PacketListenerPriority priority) {
        super(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(PacketSendEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            Object channel = event.getChannel();
            WrapperLoginServerLoginSuccess loginSuccess = new WrapperLoginServerLoginSuccess(event);
            UserProfile profile = loginSuccess.getUserProfile();
            user.getProfile().setUUID(profile.getUUID());
            user.getProfile().setName(profile.getName());
            user.getProfile().setTextureProperties(profile.getTextureProperties());
            Object object = channel;
            synchronized (object) {
                ProtocolManager.CHANNELS.put(profile.getUUID(), channel);
            }
            PacketEvents.getAPI().getLogManager().debug("Mapped player UUID with their channel.");
            boolean proxy = PacketEvents.getAPI().getInjector().isProxy();
            if (proxy ? event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_2) : event.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
                user.setEncoderState(ConnectionState.CONFIGURATION);
            } else {
                user.setConnectionState(ConnectionState.PLAY);
            }
        } else if (event.getPacketType() == PacketType.Configuration.Server.REGISTRY_DATA) {
            WrapperConfigServerRegistryData registryData = new WrapperConfigServerRegistryData(event);
            NBTCompound registryDataTag = registryData.getRegistryData();
            if (registryDataTag != null) {
                NBTList<NBTCompound> list = registryDataTag.getCompoundTagOrNull("minecraft:dimension_type").getCompoundListTagOrNull("value");
                user.setWorldNBT(list);
            }
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            NBTCompound dimension;
            WrapperPlayServerJoinGame joinGame = new WrapperPlayServerJoinGame(event);
            user.setEntityId(joinGame.getEntityId());
            user.setDimension(joinGame.getDimension());
            if (event.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                return;
            }
            NBTCompound dimensionCodec = joinGame.getDimensionCodec();
            if (dimensionCodec != null) {
                NBTList<NBTCompound> list = dimensionCodec.getCompoundTagOrNull("minecraft:dimension_type").getCompoundListTagOrNull("value");
                user.setWorldNBT(list);
            }
            if ((dimension = user.getWorldNBT(joinGame.getDimension().getDimensionName())) != null) {
                NBTCompound worldNBT = dimension.getCompoundTagOrNull("element");
                user.setMinWorldHeight(worldNBT.getNumberTagOrNull("min_y").getAsInt());
                user.setTotalWorldHeight(worldNBT.getNumberTagOrNull("height").getAsInt());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            WrapperPlayServerRespawn respawn2 = new WrapperPlayServerRespawn(event);
            user.setDimension(respawn2.getDimension());
            if (event.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                return;
            }
            NBTCompound dimension = user.getWorldNBT(respawn2.getDimension().getDimensionName());
            if (dimension != null) {
                NBTCompound worldNBT = dimension.getCompoundTagOrNull("element");
                user.setMinWorldHeight(worldNBT.getNumberTagOrNull("min_y").getAsInt());
                user.setTotalWorldHeight(worldNBT.getNumberTagOrNull("height").getAsInt());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.CONFIGURATION_START) {
            user.setEncoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Server.CONFIGURATION_END) {
            user.setEncoderState(ConnectionState.PLAY);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            Object channel = event.getChannel();
            InetSocketAddress address = event.getSocketAddress();
            WrapperHandshakingClientHandshake handshake = new WrapperHandshakingClientHandshake(event);
            ConnectionState nextState = handshake.getNextConnectionState();
            ClientVersion clientVersion = handshake.getClientVersion();
            user.setClientVersion(clientVersion);
            PacketEvents.getAPI().getLogManager().debug("Processed " + address.getHostString() + ":" + address.getPort() + "'s client version. Client Version: " + clientVersion.getReleaseName());
            user.setConnectionState(nextState);
        } else if (event.getPacketType() == PacketType.Login.Client.LOGIN_SUCCESS_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Play.Client.CONFIGURATION_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Client.CONFIGURATION_END_ACK) {
            user.setDecoderState(ConnectionState.PLAY);
        }
    }
}

