/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager;

import java.net.InetSocketAddress;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketReceiveEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.manager.InternalPacketListener;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.ConnectionState;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.packettype.PacketType;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.ClientVersion;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.User;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.protocolsupport.ProtocolSupportUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;

public class InternalBukkitPacketListener
extends InternalPacketListener {
    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            InetSocketAddress address = event.getSocketAddress();
            WrapperHandshakingClientHandshake handshake = new WrapperHandshakingClientHandshake(event);
            ConnectionState nextState = handshake.getNextConnectionState();
            ClientVersion clientVersion = handshake.getClientVersion();
            PacketEvents.getAPI().getLogManager().debug("Read handshake version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion));
            if (ViaVersionUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                PacketEvents.getAPI().getLogManager().debug("Read ViaVersion version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion) + " with UUID=" + user.getUUID());
            } else if (ProtocolSupportUtil.isAvailable()) {
                clientVersion = ClientVersion.getById(ProtocolSupportUtil.getProtocolVersion(user.getAddress()));
                PacketEvents.getAPI().getLogManager().debug("Read ProtocolSupport version for " + address.getHostString() + ":" + address.getPort() + " as " + (Object)((Object)clientVersion));
            }
            if (clientVersion == ClientVersion.UNKNOWN) {
                PacketEvents.getAPI().getLogManager().debug("Client version for " + address.getHostString() + ":" + address.getPort() + " is unknown!");
            }
            user.setClientVersion(clientVersion);
            PacketEvents.getAPI().getLogManager().debug("Processed " + address.getHostString() + ":" + address.getPort() + "'s client version. Client Version: " + clientVersion.getReleaseName());
            user.setConnectionState(nextState);
        } else {
            super.onPacketReceive(event);
        }
    }
}

