/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.injector.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import me.onlyjordon.swiftdisguise.libs.kyori.adventure.text.Component;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.exception.PacketProcessException;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.injector.connection.ServerConnectionInitializer;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.injector.handlers.PacketEventsEncoder;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.ConnectionState;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.protocol.player.User;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.ExceptionUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.FoliaCompatUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.PacketEventsImplHelper;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.util.SpigotReflectionUtil;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public Player player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player, input, true);
        out.add(input.retain());
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (ExceptionUtil.isException(cause, PacketProcessException.class) && !SpigotReflectionUtil.isMinecraftServerInstanceDebugging() && this.user != null && this.user.getDecoderState() != ConnectionState.HANDSHAKING) {
            if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                cause.printStackTrace();
            } else {
                PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
            }
            if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
                try {
                    this.user.sendPacket(new WrapperPlayServerDisconnect(Component.text("Invalid packet")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.user.closeConnection();
                if (this.player != null) {
                    FoliaCompatUtil.runTaskForEntity((Entity)this.player, (Plugin)PacketEvents.getAPI().getPlugin(), () -> this.player.kickPlayer("Invalid packet"), null, 1L);
                }
                PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to invalid packet!");
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (PacketEventsEncoder.COMPRESSION_ENABLED_EVENT == null || event != PacketEventsEncoder.COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, event);
            return;
        }
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

